/*
 * Decompiled with CFR 0.152.
 */
package utilities;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import structures.BranchyPath;
import structures.Continuous;
import structures.Edge;
import structures.EdgeLibrary;
import structures.Feature;
import structures.Graph;
import structures.Library;
import structures.NodeLibrary;
import structures.Pair;
import structures.PairDirectory;
import structures.Path;
import structures.PathManager;
import structures.Subgraph;
import structures.Value;
import utilities.Enums;
import utilities.GamsUtils;
import utilities.GenUtils;
import utilities.GraphUtils;
import utilities.StringUtils;

public class GamsPrinter {
    protected Graph graph;
    protected Graph bgGraph;
    protected PathManager pm;
    protected NodeLibrary nodeLibe;
    protected EdgeLibrary edgeLibe;
    protected Map<String, Subgraph> subgraphs;
    protected Map<String, PairDirectory> pairDirs;
    protected HashMap<Edge, String> eids;
    protected HashMap<Path, String> pids;
    protected static final int EL_COLS = 20;
    protected static final int TUPLE_COLS = 5;
    public static final String ETYPE = "etype";
    public static final String IN_CX = "in_cx";
    public static final String CX = "complex";
    protected LabelMode labelMode = LabelMode.STRIP;

    public GamsPrinter(Graph orig, PathManager pm, NodeLibrary nodeLibe, EdgeLibrary edgeLibe, Map<String, Subgraph> subgraphs) {
        this.graph = orig;
        this.pm = pm;
        this.nodeLibe = nodeLibe;
        this.edgeLibe = edgeLibe;
        this.subgraphs = subgraphs;
        HashSet<Edge> allEdges = new HashSet<Edge>(this.graph.edges());
        for (Subgraph s : this.subgraphs.values()) {
            allEdges.addAll(s.edges());
        }
        this.eids = GamsPrinter.makeUniqueEdgeIds(allEdges);
        this.pids = GamsPrinter.makeUniquePathIds(this.pm);
    }

    public GamsPrinter(Graph orig, PathManager pm, NodeLibrary nodeLibe, EdgeLibrary edgeLibe) {
        this.graph = orig;
        this.pm = pm;
        this.nodeLibe = nodeLibe;
        this.edgeLibe = edgeLibe;
        this.eids = GamsPrinter.makeUniqueEdgeIds(this.graph.edges());
        this.pids = GamsPrinter.makeUniquePathIds(this.pm);
        this.subgraphs = new HashMap<String, Subgraph>();
    }

    public GamsPrinter(Graph g, Graph orig, PathManager pm, NodeLibrary nodeLibe, EdgeLibrary edgeLibe, Map<String, Subgraph> subgraphs, Map<String, PairDirectory> pairDirs) {
        this.graph = g;
        this.pm = pm;
        this.nodeLibe = nodeLibe;
        this.edgeLibe = edgeLibe;
        HashSet<Edge> allEdges = new HashSet<Edge>(this.graph.edges());
        if (this.subgraphs != null) {
            for (Subgraph s : this.subgraphs.values()) {
                allEdges.addAll(s.edges());
            }
        }
        this.eids = GamsPrinter.makeUniqueEdgeIds(allEdges);
        this.pids = GamsPrinter.makeUniquePathIds(this.pm);
        this.subgraphs = subgraphs;
        this.pairDirs = pairDirs;
    }

    public void setLabelMode(LabelMode mode) {
        this.labelMode = mode;
    }

    public void printNodeSets(PrintStream stream) {
        String[] nfeats = new String[this.nodeLibe.features().size()];
        int i = 0;
        Iterator<String> iterator = this.nodeLibe.featureNames().iterator();
        while (iterator.hasNext()) {
            String name;
            nfeats[i] = name = iterator.next();
            ++i;
        }
        this.printNodeSets(stream, nfeats);
    }

    public void printNodeSets(PrintStream stream, String[] nodeFeatureNames) {
        HashSet<String> ids = new HashSet<String>(this.graph.nodes());
        if (this.pairDirs != null) {
            for (PairDirectory p : this.pairDirs.values()) {
                ids.addAll(p.getFirsts());
                ids.addAll(p.getSeconds());
            }
        }
        ids = this.gamsifySet(ids);
        String set = GamsUtils.makeSetList("node", "all nodes", ids, 20);
        stream.println(set);
        String[] stringArray = nodeFeatureNames;
        int n = nodeFeatureNames.length;
        int n2 = 0;
        while (n2 < n) {
            String fname = stringArray[n2];
            Feature feat = this.nodeLibe.getFeature(fname);
            boolean ok = this.printFeature(stream, feat);
            assert (ok) : "Problem printing feature from printNodeSets: " + feat.name();
            ++n2;
        }
        Feature cxN = this.nodeLibe.getFeature(CX);
        Feature etype = this.edgeLibe.getFeature(ETYPE);
        if (cxN != null && etype.legal(IN_CX) != null) {
            this.printComplexSets(stream);
        }
    }

    public void printComplexSets(PrintStream stream) {
        Feature etype = this.edgeLibe.getFeature(ETYPE);
        assert (etype != null) : "Don't call printComplexSets without having complexes";
        Feature isCxFeat = this.nodeLibe.getFeature(CX);
        Set isCx = this.nodeLibe.get(isCxFeat);
        HashMap<String, HashSet<String>> cxMap = new HashMap<String, HashSet<String>>();
        for (String cx : isCx) {
            HashSet<String> members = new HashSet<String>();
            for (Edge e : this.graph.incident(cx)) {
                Value type = this.edgeLibe.getValue(e, etype);
                if (type == null || !type.toString().equals(IN_CX)) continue;
                for (String o : e.nodes()) {
                    members.add(this.gamsify(o));
                }
            }
            members.remove(cx);
            if (members.size() <= 0) continue;
            cxMap.put(this.gamsify(cx), members);
        }
        String cxSet = null;
        cxSet = cxMap.size() > 0 ? GamsUtils.makeTupleSet("cxprot(node,node)", "complex membership", cxMap, 5) : GamsUtils.makeEmpty("cxprot(node,node)", "complex membership");
        stream.println(cxSet);
        Set inCx = this.edgeLibe.get(etype, etype.legal(IN_CX));
        HashMap<String, Double> sizes = new HashMap<String, Double>();
        for (Edge e : inCx) {
            for (String n : e.nodes()) {
                if (!isCx.contains(n) || !this.graph.contains(n)) continue;
                if (!sizes.containsKey(n)) {
                    sizes.put(n, 0.0);
                }
                sizes.put(n, sizes.get(n) + 1.0);
            }
        }
        String cxSizeParam = GamsUtils.makeParameter("complexSize(node)", "size of complete complex", sizes);
        stream.println(cxSizeParam);
    }

    public void printEdgeSets(PrintStream stream) {
        this.printEdgeSets(stream, false);
    }

    public void printEdgeSets(PrintStream stream, boolean printSign) {
        String[] efeats = new String[this.edgeLibe.features().size()];
        int i = 0;
        Iterator<String> iterator = this.edgeLibe.featureNames().iterator();
        while (iterator.hasNext()) {
            String name;
            efeats[i] = name = iterator.next();
            ++i;
        }
        this.printEdgeSets(stream, efeats, printSign);
    }

    public void printEdgeSets(PrintStream stream, String[] featNames, boolean printSign) {
        HashSet<String> ids = this.gamsifySet(this.graph.edges());
        String set = GamsUtils.makeSetList("edge", "all edges", ids, 20);
        stream.println(set);
        HashSet<Edge> signed = new HashSet<Edge>();
        HashSet<Edge> activating = new HashSet<Edge>();
        HashSet<Edge> inhibiting = new HashSet<Edge>();
        HashSet<Edge> ppi = new HashSet<Edge>();
        for (Edge e : this.graph.edges()) {
            if (!e.isDirected()) {
                ppi.add(e);
            }
            switch (e.sign()) {
                case POSITIVE: {
                    signed.add(e);
                    activating.add(e);
                    break;
                }
                case NEGATIVE: {
                    signed.add(e);
                    inhibiting.add(e);
                    break;
                }
            }
        }
        String ppiset = GamsUtils.makeSetList("ppi(edge)", "undirected edges", this.gamsifySet(ppi), 20);
        stream.println(ppiset);
        if (printSign) {
            String signset = GamsUtils.makeSetList("signed(edge)", "signed edges", this.gamsifySet(signed), 20);
            stream.println(signset);
            String actset = GamsUtils.makeSetList("activating(edge)", "positively-signed edges", this.gamsifySet(activating), 20);
            stream.println(actset);
            String inhset = GamsUtils.makeSetList("inhibitory(edge)", "negatively-signed edges", this.gamsifySet(inhibiting), 20);
            stream.println(inhset);
        }
        String[] stringArray = featNames;
        int n = featNames.length;
        int actset = 0;
        while (actset < n) {
            String featName = stringArray[actset];
            Feature feat = this.edgeLibe.getFeature(featName);
            boolean ok = this.printFeature(stream, feat);
            assert (ok) : "Problem printing feature from printEdgeSets: " + feat.name();
            ++actset;
        }
        HashSet<String> edgeTups = new HashSet<String>();
        for (Edge e : this.graph.edges()) {
            String eid = this.gamsify(e);
            String nid = this.gamsify(e.i());
            String njd = this.gamsify(e.j());
            edgeTups.add(String.format("%s.%s.%s", eid, nid, njd));
        }
        String enode = GamsUtils.makeSetList("enode(edge,node,node)", "edges with nodes", edgeTups, 20);
        stream.println(enode);
    }

    public void printPathSets(PrintStream stream) {
        this.printPathSets(stream, true, new HashSet<String>());
    }

    public void printPathSets(PrintStream stream, boolean printPathDirs) {
        this.printPathSets(stream, printPathDirs, new HashSet<String>());
    }

    public void printPathSets(PrintStream stream, boolean printPathDirs, Set<String> hidden) {
        HashSet<Path> allPaths = new HashSet<Path>();
        if (hidden.size() > 0) {
            for (Path p : this.pm.allPaths()) {
                if (hidden.contains(p.getNode(0))) continue;
                allPaths.add(p);
            }
        } else {
            allPaths.addAll(this.pm.allPaths());
        }
        HashSet<String> ids = this.gamsifySet(allPaths);
        String set = GamsUtils.makeSetList("path", "all paths", ids, 20);
        stream.println(set);
        for (String label : this.pm.allLabels()) {
            HashSet<Path> lpath = new HashSet<Path>(this.pm.getPathsForLabel(label));
            lpath.retainAll(allPaths);
            HashSet<String> lids = this.gamsifySet(lpath);
            String lset = GamsUtils.makeSetList(String.format("%s(path)", label), String.format("paths from pathfinder %s", label), lids, 20);
            stream.println(lset);
        }
        if (printPathDirs) {
            HashMap<Path.PathOrder, HashMap<String, HashSet<String>>> divided = this.getPathDirs(allPaths);
            String fwdSet = GamsUtils.makeTupleSet("fwd(edge,path)", "undirected edges that proceed forward in paths", divided.get((Object)Path.PathOrder.ABOVE), 5);
            stream.println(fwdSet);
            String backSet = GamsUtils.makeTupleSet("back(edge,path)", "undirected edges that proceed in reverse in paths", divided.get((Object)Path.PathOrder.BELOW), 5);
            stream.println(backSet);
        }
        HashMap<String, HashSet<String>> pnodes = new HashMap<String, HashSet<String>>();
        HashMap<String, HashSet<String>> pedges = new HashMap<String, HashSet<String>>();
        HashMap<String, HashSet<String>> pstart = new HashMap<String, HashSet<String>>();
        HashSet<String> npid = new HashSet<String>();
        HashSet<String> epid = new HashSet<String>();
        for (Path p : allPaths) {
            String pid = this.gamsify(p);
            String start = this.gamsify(p.getNode(0));
            if (!pstart.containsKey(start)) {
                pstart.put(start, new HashSet());
            }
            pstart.get(start).add(pid);
            for (String n : p.nodes()) {
                String nid = this.gamsify(n);
                if (!pnodes.containsKey(nid)) {
                    pnodes.put(nid, new HashSet());
                }
                pnodes.get(nid).add(pid);
                npid.add(pid);
            }
            for (Edge e : p.edges()) {
                String eid = this.gamsify(e);
                if (!pedges.containsKey(eid)) {
                    pedges.put(eid, new HashSet());
                }
                pedges.get(eid).add(pid);
                epid.add(pid);
            }
        }
        String pstartSet = GamsUtils.makeTupleSet("pstart(node,path)", "nodes that start paths", pstart, 5);
        stream.println(pstartSet);
        String pnodeSet = GamsUtils.makeTupleSet("pnode(node,path)", "nodes in paths", pnodes, 5);
        stream.println(pnodeSet);
        String pedgeSet = GamsUtils.makeTupleSet("pedge(edge,path)", "edges in paths", pedges, 5);
        stream.println(pedgeSet);
    }

    public void printSubgraphSets(PrintStream stream, Map<String, Enums.AddEdgeMode> edgeModes) {
        this.printSubgraphSets(stream, edgeModes, this.pm);
    }

    public void printSubgraphSets(PrintStream stream, Map<String, Enums.AddEdgeMode> edgeModes, PathManager pathman) {
        String nodeStr;
        String edgeStr;
        String sgset;
        if (this.subgraphs.size() == 0) {
            sgset = GamsUtils.makeEmpty("subgraph", "subgraph IDs");
            edgeStr = GamsUtils.makeEmpty("subedge(subgraph, edge)", "subgraphs and edges");
            nodeStr = GamsUtils.makeEmpty("subnode(subgraph, node)", "subgraphs and nodes");
        } else {
            sgset = GamsUtils.makeSetList("subgraph", "subgraph IDs", this.subgraphs.keySet(), 20);
            HashMap<String, HashSet<String>> nodes = new HashMap<String, HashSet<String>>();
            HashMap<String, HashSet<String>> edges = new HashMap<String, HashSet<String>>();
            for (String subname : this.subgraphs.keySet()) {
                if (!nodes.containsKey(subname)) {
                    nodes.put(subname, new HashSet());
                    edges.put(subname, new HashSet());
                }
                Subgraph sub = this.subgraphs.get(subname);
                Enums.AddEdgeMode mode = edgeModes.get(subname);
                Collection<Edge> addEdges = PathManager.filterEdges(pathman, sub.edges(), mode);
                for (Edge e : addEdges) {
                    edges.get(subname).add(this.gamsify(e));
                    for (String n : e.nodes()) {
                        nodes.get(subname).add(this.gamsify(n));
                    }
                }
            }
            edgeStr = GamsUtils.makeTupleSet("subedge(subgraph, edge)", "subgraphs and edges", edges, 5);
            nodeStr = GamsUtils.makeTupleSet("subnode(subgraph, node)", "subgraphs and nodes", nodes, 5);
        }
        stream.println(sgset);
        stream.println(nodeStr);
        stream.println(edgeStr);
    }

    public void printPairSets(PrintStream stream, boolean pathsOnly) {
        for (Map.Entry<String, PairDirectory> pdE : this.pairDirs.entrySet()) {
            HashMap<String, HashSet<String>> map = new HashMap<String, HashSet<String>>();
            for (String first : pdE.getValue().getFirsts()) {
                if (pathsOnly && !this.pm.contains(first)) continue;
                HashSet<String> tars = new HashSet<String>();
                for (String tar : pdE.getValue().getSeconds(first)) {
                    if (pathsOnly && !this.pm.contains(tar)) continue;
                    tars.add(this.gamsify(tar));
                }
                if (tars.size() <= 0) continue;
                map.put(this.gamsify(first), tars);
            }
            String name = this.clean(pdE.getKey());
            String set = GamsUtils.makeTupleSet(String.format("%s(node,node)", name), "pairs from " + name, map, 5);
            stream.println(set);
        }
    }

    protected HashMap<Path.PathOrder, HashMap<String, HashSet<String>>> getPathDirs(Set<Path> reqPaths) {
        HashMap<Path.PathOrder, HashMap<String, HashSet<String>>> divided = new HashMap<Path.PathOrder, HashMap<String, HashSet<String>>>();
        Path.PathOrder[] pathOrderArray = new Path.PathOrder[]{Path.PathOrder.ABOVE, Path.PathOrder.BELOW};
        int n = pathOrderArray.length;
        int n2 = 0;
        while (n2 < n) {
            Path.PathOrder order = pathOrderArray[n2];
            divided.put(order, new HashMap());
            ++n2;
        }
        for (Path p : reqPaths) {
            String pid = this.gamsify(p);
            for (Edge e : p.edges()) {
                String eid = this.gamsify(e);
                if (e.isDirected()) continue;
                Path.PathOrder order = p.order(e.i(), e.j());
                assert (order != Path.PathOrder.NA) : "Shouldn't have undirected paths at this point.";
                HashMap<String, HashSet<String>> subMap = divided.get((Object)order);
                if (!subMap.containsKey(eid)) {
                    subMap.put(eid, new HashSet());
                }
                subMap.get(eid).add(pid);
            }
        }
        return divided;
    }

    public boolean printFeature(PrintStream stream, Feature feature) {
        GraphUtils.Element elType = null;
        Library libe = null;
        String suffix = "!!";
        if (this.nodeLibe.hasFeature(feature)) {
            libe = this.nodeLibe;
            elType = GraphUtils.Element.NODE;
            suffix = "N";
        } else if (this.edgeLibe.hasFeature(feature)) {
            elType = GraphUtils.Element.EDGE;
            libe = this.edgeLibe;
            suffix = "E";
        } else {
            return false;
        }
        if (feature.type() == Value.Type.CONTINUOUS) {
            this.printParameterFeat(elType, suffix, stream, feature);
        } else {
            this.printDiscreteFeat(elType, suffix, stream, feature);
        }
        return true;
    }

    protected boolean printParameterFeat(GraphUtils.Element elType, String suffix, PrintStream stream, Feature feature) {
        assert (feature.type() == Value.Type.CONTINUOUS) : "Don't call printParameterFeat on non-Continuous features.";
        Library libe = this.nodeLibe;
        Set<Object> things = this.graph.nodes();
        if (elType == GraphUtils.Element.EDGE) {
            libe = this.edgeLibe;
            things = this.graph.edges();
        }
        if (!libe.hasFeature(feature)) {
            return false;
        }
        HashSet<String> ids = new HashSet<String>();
        HashMap<String, Double> vals = new HashMap<String, Double>();
        for (Object o : things) {
            Continuous v;
            String id = this.gamsify(o);
            if (!libe.contains(o) || (v = (Continuous)libe.getValue(o, feature)) == null) continue;
            ids.add(id);
            vals.put(id, v.getValue());
        }
        String fname = this.clean(feature.name());
        String all = GamsUtils.makeSetList(String.format("%sFeature%s(%s)", fname, suffix, elType.toString().toLowerCase()), feature.note(), ids, 20);
        stream.println(all);
        String param = GamsUtils.makeParameter(String.format("%sParam%s(%s)", fname, suffix, elType.toString().toLowerCase()), feature.note(), vals);
        stream.println(param);
        return true;
    }

    protected boolean printDiscreteFeat(GraphUtils.Element elType, String suffix, PrintStream stream, Feature feature) {
        Value[] vals;
        Set allThings;
        assert (feature.type() != Value.Type.CONTINUOUS) : "Don't call printDiscreteFeat on Continuous features.";
        Library libe = this.nodeLibe;
        Set<Object> graphThings = this.graph.nodes();
        if (elType == GraphUtils.Element.EDGE) {
            libe = this.edgeLibe;
            graphThings = this.graph.edges();
        }
        if ((allThings = libe.get(feature)) == null) {
            return false;
        }
        allThings.retainAll(graphThings);
        HashSet<String> ids = new HashSet<String>();
        for (Object o : allThings) {
            String id = this.gamsify(o);
            ids.add(id);
        }
        String featName = this.clean(feature.name());
        String all = GamsUtils.makeSetList(String.format("%sFeature%s(%s)", featName, suffix, elType.toString().toLowerCase()), feature.note(), ids, 20);
        stream.println(all);
        Value[] valueArray = vals = feature.values();
        int n = vals.length;
        int n2 = 0;
        while (n2 < n) {
            Value v = valueArray[n2];
            Set subThings = libe.get(feature, v);
            HashSet<String> subIds = new HashSet<String>();
            for (Object o : subThings) {
                if (!graphThings.contains(o)) continue;
                String id = this.gamsify(o);
                subIds.add(id);
            }
            String valName = this.clean(v.toString());
            String set = GamsUtils.makeSetList(String.format("%sValue%s(%s)", valName, suffix, elType.toString().toLowerCase()), String.format("%s=%s", feature.name(), v.toString()), subIds, 20);
            stream.println(set);
            ++n2;
        }
        return true;
    }

    public String clean(String s) {
        return s.replaceAll("[^A-Za-z0-9]", "");
    }

    public String gamsify(Object o) {
        String orig = o.toString();
        if (o instanceof Edge) {
            orig = this.eids.get((Edge)o);
        } else if (o instanceof Path) {
            orig = this.pids.get((Path)o);
        }
        assert (orig != null) : String.format("Problem: item %s wasn't gamsified? Returned null.", o.toString());
        String update = null;
        switch (this.labelMode) {
            case STRIP: {
                update = orig.replaceAll("[^A-Za-z0-9]", "");
                break;
            }
            case QUOTE: {
                update = String.format("'%s'", orig);
            }
        }
        assert (update.length() > 0) : "Lost name entirely by removing non-alphanumeric chars: " + orig;
        return update;
    }

    protected HashSet<String> getMutuallyExclusiveEdgePairs() {
        HashSet<String> tuples = new HashSet<String>();
        for (String nodeA : this.graph.nodes()) {
            for (String nodeB : this.graph.neighbors(nodeA)) {
                Set<Edge> inc = this.graph.adjacent(nodeA, nodeB);
                if (inc.size() <= 1) continue;
                Set<Pair<Edge, Edge>> pairs = GenUtils.allPairs(inc);
                for (Pair<Edge, Edge> p : pairs) {
                    String b;
                    String a = this.gamsify(p.first());
                    if (a.compareTo(b = this.gamsify(p.second())) > 0) {
                        String temp = a;
                        a = b;
                        b = temp;
                    }
                    tuples.add(String.format("%s.%s", a, b));
                }
            }
        }
        return tuples;
    }

    public <T> HashSet<String> gamsifySet(Collection<T> items) {
        HashSet<String> ids = new HashSet<String>();
        for (T p : items) {
            ids.add(this.gamsify(p));
        }
        return ids;
    }

    public <T> ArrayList<String> gamsifyList(Collection<T> items) {
        ArrayList<String> ids = new ArrayList<String>();
        for (T p : items) {
            ids.add(this.gamsify(p));
        }
        return ids;
    }

    protected static HashMap<Edge, String> makeUniqueEdgeIds(Set<Edge> edges) {
        HashMap<Edge, String> map = new HashMap<Edge, String>();
        int i = 0;
        for (Edge e : edges) {
            String id = String.format("edge%d", i);
            ++i;
            map.put(e, id);
        }
        return map;
    }

    public Map<Edge, String> getEdgeIDs() {
        return Collections.unmodifiableMap(this.eids);
    }

    protected static HashMap<Path, String> makeUniquePathIds(PathManager pm) {
        HashMap<Path, String> map = new HashMap<Path, String>();
        int i = 0;
        for (Path p : pm.allPaths()) {
            String id = String.format("p%d", i);
            ++i;
            map.put(p, id);
        }
        return map;
    }

    public String nodeString(Path p) {
        StringBuilder sb = new StringBuilder();
        if (p instanceof BranchyPath) {
            BranchyPath bp = (BranchyPath)p;
            sb.append(StringUtils.join(this.gamsifyList(bp.bodyPath().nodes()), "|"));
            if (bp.termini().size() > 0) {
                sb.append(String.format("|[%s]", StringUtils.join(this.gamsifySet(bp.termini()), ",")));
            }
        } else {
            sb.append(StringUtils.join(this.gamsifyList(p.nodes()), "|"));
        }
        return sb.toString();
    }

    public String edgeString(Path p) {
        StringBuilder sb = new StringBuilder();
        if (p instanceof BranchyPath) {
            BranchyPath bp = (BranchyPath)p;
            sb.append(StringUtils.join(this.gamsifyList(bp.bodyPath().edges()), "|"));
            if (bp.termini().size() > 0) {
                sb.append(String.format("|[%s]", StringUtils.join(this.gamsifyList(bp.terminalEdges()), ",")));
            }
        } else {
            sb.append(StringUtils.join(this.gamsifyList(p.edges()), "|"));
        }
        return sb.toString();
    }

    public static enum LabelMode {
        QUOTE,
        STRIP;

    }

    protected static enum SubgraphMode {
        ALL,
        TARGET_IN_PATH,
        SOURCE_IN_PATH;

    }
}

