/*
 * Decompiled with CFR 0.152.
 */
package utilities;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import structures.Edge;
import structures.EdgeLibrary;
import structures.Feature;
import structures.Graph;
import structures.NodeLibrary;
import structures.Path;
import structures.PathManager;
import structures.Value;
import utilities.StringUtils;

public class CytoscapePrinter {
    public static final String NONE = "";
    public static final String DELIM = "\t";

    public static boolean printSif(Graph g, String output, boolean cleanUp) {
        File outf = null;
        try (PrintWriter pw = null;){
            try {
                outf = new File(output);
                pw = new PrintWriter(outf);
                ArrayList<Edge> edges = new ArrayList<Edge>(g.edges());
                Collections.sort(edges);
                for (Edge e : edges) {
                    String sif = CytoscapePrinter.edgeSif(e, false, cleanUp);
                    pw.write(String.format("%s\n", sif));
                }
            }
            catch (FileNotFoundException fnfe) {
                if (pw != null) {
                    pw.close();
                }
                return false;
            }
        }
        return true;
    }

    public static boolean printSif(Graph g, String output) {
        return CytoscapePrinter.printSif(g, output, false);
    }

    public static boolean printSif(PathManager pm, String output, boolean cleanUp) {
        HashSet<String> edges = new HashSet<String>();
        for (Path p : pm.allPaths()) {
            List<String> pathEdges = CytoscapePrinter.edgeSifs(p, cleanUp);
            for (String s : pathEdges) {
                edges.add(s);
            }
        }
        File outf = null;
        try (PrintWriter pw = null;){
            try {
                outf = new File(output);
                pw = new PrintWriter(outf);
                for (String sif : edges) {
                    pw.write(String.format("%s\n", sif));
                }
            }
            catch (FileNotFoundException fnfe) {
                if (pw != null) {
                    pw.close();
                }
                return false;
            }
        }
        return true;
    }

    public static boolean printSif(PathManager pm, String output) {
        return CytoscapePrinter.printSif(pm, output, false);
    }

    public static List<String> edgeSifs(Path p, boolean cleanUp) {
        ArrayList<String> edges = new ArrayList<String>();
        int i = 0;
        while (i < p.edgeLength()) {
            Edge e = p.getEdge(i);
            if (e.isDirected()) {
                edges.add(CytoscapePrinter.edgeSif(e, false, cleanUp));
            } else if (e.i().equals(p.getNode(i))) {
                edges.add(CytoscapePrinter.edgeSif(e, false, cleanUp));
            } else {
                assert (e.j().equals(p.getNode(i))) : "Trying to print a badly formed path: " + p.toString();
                edges.add(CytoscapePrinter.edgeSifReverse(e, false, cleanUp));
            }
            ++i;
        }
        return edges;
    }

    protected static String edgeSif(Edge e, boolean useParens, boolean doClean) {
        String type;
        String string = type = e.isDirected() ? "d" : "u";
        if (useParens) {
            type = String.format("(%s)", type);
        }
        String i = e.i();
        String j = e.j();
        if (doClean) {
            i = CytoscapePrinter.clean(i);
            j = CytoscapePrinter.clean(j);
        }
        return String.format("%s %s %s", i, type, j);
    }

    protected static String edgeSif(Edge e, boolean useParens) {
        return CytoscapePrinter.edgeSif(e, useParens, false);
    }

    public static String clean(String s) {
        return s.replaceAll("[^A-Za-z0-9]", NONE);
    }

    protected static String edgeSifReverse(Edge e, boolean useParens, boolean doClean) {
        assert (!e.isDirected()) : "Are you sure you want to print your directed edge in reverse?";
        String type = "u";
        if (useParens) {
            type = String.format("(%s)", type);
        }
        String i = e.i();
        String j = e.j();
        if (doClean) {
            i = CytoscapePrinter.clean(i);
            j = CytoscapePrinter.clean(j);
        }
        return String.format("%s %s %s", j, type, i);
    }

    protected static String edgeSifReverse(Edge e, boolean useParens) {
        return CytoscapePrinter.edgeSifReverse(e, useParens, false);
    }

    public static boolean printEdgeAttribute(String attrName, Map<Edge, String> idMap, String filename, boolean cytoV3, boolean cleanUp) {
        File outf = null;
        try (PrintWriter pw = null;){
            try {
                outf = new File(filename);
                pw = new PrintWriter(outf);
                if (cytoV3) {
                    pw.format("ID\t%s\n", attrName);
                } else {
                    pw.format("%s\n", attrName);
                }
                for (Edge e : idMap.keySet()) {
                    if (cytoV3) {
                        pw.format("%s\t%s\n", CytoscapePrinter.edgeSif(e, true, cleanUp), idMap.get(e));
                        if (e.isDirected()) continue;
                        pw.format("%s\t%s\n", CytoscapePrinter.edgeSifReverse(e, true, cleanUp), idMap.get(e));
                        continue;
                    }
                    pw.format("%s = %s\n", CytoscapePrinter.edgeSif(e, true, cleanUp), idMap.get(e));
                    if (e.isDirected()) continue;
                    pw.format("%s = %s\n", CytoscapePrinter.edgeSifReverse(e, true, cleanUp), idMap.get(e));
                }
            }
            catch (FileNotFoundException fnfe) {
                if (pw != null) {
                    pw.close();
                }
                return false;
            }
        }
        return true;
    }

    public static boolean printNodeFeatures(NodeLibrary libe, String output, boolean cleanUp) {
        ArrayList<Feature> feats = new ArrayList<Feature>(libe.features());
        if (feats.size() == 0) {
            return false;
        }
        Collections.sort(feats, new Comparator<Feature>(){

            @Override
            public int compare(Feature a, Feature b) {
                return a.name().compareTo(b.name());
            }
        });
        File outf = null;
        try (PrintWriter pw = null;){
            try {
                outf = new File(output);
                pw = new PrintWriter(outf);
                pw.write("NODE");
                for (Feature f : feats) {
                    pw.write(DELIM + f.name());
                }
                pw.write("\n");
                Iterator<Object> iterator = libe.items().iterator();
                while (iterator.hasNext()) {
                    String nodeO;
                    String node = nodeO = (String)iterator.next();
                    if (cleanUp) {
                        node = CytoscapePrinter.clean(nodeO);
                    }
                    pw.write(node);
                    for (Feature f : feats) {
                        Value val = libe.getValue(node, f);
                        String valStr = val != null ? val.toString() : NONE;
                        pw.write(String.format("%s%s", DELIM, valStr));
                    }
                    pw.write("\n");
                }
            }
            catch (FileNotFoundException fnfe) {
                if (pw != null) {
                    pw.close();
                }
                return false;
            }
        }
        return true;
    }

    public static boolean printEdgeFeatures(EdgeLibrary libe, String output, boolean cleanUp) {
        ArrayList<Feature> feats = new ArrayList<Feature>(libe.features());
        if (feats.size() == 0) {
            return false;
        }
        Collections.sort(feats, new Comparator<Feature>(){

            @Override
            public int compare(Feature a, Feature b) {
                return a.name().compareTo(b.name());
            }
        });
        File outf = null;
        try (PrintWriter pw = null;){
            try {
                outf = new File(output);
                pw = new PrintWriter(outf);
                pw.write(String.format("sif_style", new Object[0]));
                for (Feature f : feats) {
                    pw.write(DELIM + f.name());
                }
                pw.write("\tfilenames");
                pw.write("\n");
                for (Edge item : libe.items()) {
                    StringBuilder row = new StringBuilder();
                    boolean first = true;
                    for (Feature f : feats) {
                        String valStr;
                        Value val = libe.getValue(item, f);
                        String string = valStr = val != null ? val.toString() : NONE;
                        if (first) {
                            row.append(String.format("%s", valStr));
                            first = false;
                            continue;
                        }
                        row.append(String.format("%s%s", DELIM, valStr));
                    }
                    ArrayList<String> strs = new ArrayList<String>();
                    for (String fn : libe.getFilenames(item)) {
                        String basename = new File(fn).getName();
                        String[] sp = basename.split("\\.(?=[^\\.]+$)");
                        strs.add(sp[0]);
                    }
                    row.append(String.format("%s%s\n", DELIM, StringUtils.join(strs, "|")));
                    String sif = CytoscapePrinter.edgeSif(item, true, cleanUp);
                    pw.write(String.format("%s%s%s", sif, DELIM, row.toString()));
                    if (item.isDirected()) continue;
                    pw.write(String.format("%s%s%s", CytoscapePrinter.edgeSifReverse(item, true, cleanUp), DELIM, row.toString()));
                }
            }
            catch (FileNotFoundException fnfe) {
                if (pw != null) {
                    pw.close();
                }
                return false;
            }
        }
        return true;
    }
}

