/*
 * Decompiled with CFR 0.152.
 */
package structures;

import structures.Continuous;
import structures.Discrete;
import structures.Ordinal;

public abstract class Value
implements Comparable<Value> {
    public abstract Type getType();

    public static Value[] convert(Type type, String[] valStrs) {
        int len = valStrs.length;
        Value[] allVals = new Value[len];
        int i = 0;
        while (i < len) {
            if (type == Type.CONTINUOUS) {
                allVals[i] = Continuous.makeValue(valStrs[i]);
            } else if (type == Type.DISCRETE || type == Type.SET) {
                allVals[i] = Discrete.makeValue(valStrs[i]);
            } else if (type == Type.ORDINAL) {
                allVals[i] = Ordinal.makeValue(valStrs[i], i);
                assert (false) : "Ordinal value reading notimplemented.";
            }
            ++i;
        }
        return allVals;
    }

    public static enum Type {
        DISCRETE(false),
        CONTINUOUS(true),
        ORDINAL(true),
        SET(false);

        private final boolean ordered;

        private Type(boolean isOrdered) {
            this.ordered = isOrdered;
        }

        public boolean isComparable() {
            return this.ordered;
        }

        public static Type fromString(String type) {
            if ((type = type.toUpperCase()).equals("DISCRETE")) {
                return DISCRETE;
            }
            if (type.equals("CONTINUOUS")) {
                return CONTINUOUS;
            }
            if (type.equals("SET") || type.equals("CATSET")) {
                return SET;
            }
            if (type.equals("ORDINAL")) {
                return ORDINAL;
            }
            return null;
        }

        public String toString() {
            if (this == DISCRETE) {
                return "discrete";
            }
            if (this == CONTINUOUS) {
                return "continuous";
            }
            if (this == SET) {
                return "categorical_set";
            }
            if (this == ORDINAL) {
                return "ordinal";
            }
            return null;
        }
    }
}

