/*
 * Decompiled with CFR 0.152.
 */
package structures;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import structures.Edge;

public class Subgraph {
    protected final String name;
    protected final Set<Edge> edges;
    protected final Set<String> nodes;
    protected final String toString;

    public Subgraph(String name, Collection<String> nodes, Collection<Edge> edges) {
        this.name = name;
        this.edges = new HashSet<Edge>(edges);
        this.toString = this.buildString();
        this.nodes = new HashSet<String>(nodes);
        for (Edge e : edges) {
            this.nodes.addAll(e.nodes());
        }
    }

    public Subgraph(String name, Collection<Edge> edges) {
        this.name = name;
        this.edges = new HashSet<Edge>(edges);
        this.toString = this.buildString();
        this.nodes = new HashSet<String>();
        for (Edge e : edges) {
            this.nodes.addAll(e.nodes());
        }
    }

    public String name() {
        return this.name;
    }

    public boolean contains(String node) {
        return this.nodes.contains(node);
    }

    public boolean contains(Edge e) {
        return this.edges.contains(e);
    }

    public Set<String> nodes() {
        return Collections.unmodifiableSet(this.nodes);
    }

    public Set<Edge> edges() {
        return Collections.unmodifiableSet(this.edges);
    }

    public String toString() {
        return this.toString;
    }

    protected String buildString() {
        StringBuilder sb = new StringBuilder(String.format("Subgraph %s", this.name));
        for (Edge e : this.edges) {
            sb.append("\n\t");
            sb.append(e.i);
            if (!e.directed) {
                switch (e.sign) {
                    case UNKNOWN: {
                        sb.append(" -- ");
                        break;
                    }
                    case POSITIVE: {
                        sb.append(" <--> ");
                        break;
                    }
                    case NEGATIVE: {
                        sb.append(" |--| ");
                    }
                }
            } else if (e.directed) {
                switch (e.sign) {
                    case UNKNOWN: {
                        sb.append(" --+ ");
                        break;
                    }
                    case POSITIVE: {
                        sb.append(" --> ");
                        break;
                    }
                    case NEGATIVE: {
                        sb.append(" --| ");
                    }
                }
            }
            sb.append(e.j);
        }
        return sb.toString();
    }
}

