/*
 * Decompiled with CFR 0.152.
 */
package structures;

import exceptions.DuplicateException;
import exceptions.InvalidValueException;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Scanner;
import java.util.Set;
import structures.PairDirectory;
import utilities.Enums;
import utilities.GenUtils;

public class ScoredPairDirectory
extends PairDirectory {
    protected final HashMap<String, HashMap<String, Double>> scores = new HashMap();

    protected ScoredPairDirectory(String filename, String name) {
        super(filename, name);
    }

    protected double add(String a, String b, Enums.Sign s, double score) {
        Enums.Sign overwrite = super.add(a, b, s);
        if (!this.scores.containsKey(a)) {
            this.scores.put(a, new HashMap());
        }
        Double prev = this.scores.get(a).put(b, score);
        return prev;
    }

    protected double add(String a, String b, double score) {
        return this.add(a, b, Enums.Sign.UNKNOWN, score);
    }

    public double getScore(String a, String b) {
        if (this.contains(a, b)) {
            return this.scores.get(a).get(b);
        }
        throw new NullPointerException(String.format("No scored pair %s->%s", a, b));
    }

    public static ScoredPairDirectory readScoredPairs(String filename, String name, String targetFormat, boolean readSigns, String posText, String negText) throws InvalidValueException, DuplicateException, FileNotFoundException {
        HashMap<String, Enums.Sign> signMap = null;
        if (readSigns) {
            signMap = new HashMap<String, Enums.Sign>();
            if (posText != null) {
                signMap.put(posText, Enums.Sign.POSITIVE);
            }
            if (negText != null) {
                signMap.put(negText, Enums.Sign.NEGATIVE);
            }
        }
        Scanner s = null;
        try {
            s = new Scanner(new File(filename));
        }
        catch (FileNotFoundException fnfe) {
            throw new FileNotFoundException("Unable to read ordered pair file " + filename);
        }
        ScoredPairDirectory pairs = new ScoredPairDirectory(filename, name);
        while (s.hasNext()) {
            Object[] sp = s.nextLine().trim().split("\t");
            if (sp.length == 0 || sp[0].startsWith("#")) continue;
            if (sp.length < 3) {
                throw new InvalidValueException(String.format("Reading scored pairs from %s: Improper line '%s'\n", filename, Arrays.toString(sp)));
            }
            String nodeA = sp[0];
            String nodeB = String.format(targetFormat, sp[1]);
            Enums.Sign sign = Enums.Sign.UNKNOWN;
            int scoreCol = 2;
            double score = 0.0;
            if (readSigns && sp.length > 2 && signMap.containsKey(sp[2])) {
                sign = (Enums.Sign)((Object)signMap.get(sp[2]));
                if (pairs.hasSign(nodeA, nodeB) && sign != pairs.getSign(nodeA, nodeB)) {
                    throw new DuplicateException(String.format("We already specified a different sign for %s->%s (%s, now %s)", new Object[]{nodeA, nodeB, sign, pairs.getSign(nodeA, nodeB)}));
                }
                scoreCol = 3;
            }
            try {
                score = Double.parseDouble((String)sp[scoreCol]);
            }
            catch (NumberFormatException nfe) {
                throw new InvalidValueException(String.format("Bad score format: %f", sp[scoreCol]));
            }
            double d = pairs.add(nodeA, nodeB, sign, score);
        }
        return pairs;
    }

    public static ScoredPairDirectory scoreJaccard(PairDirectory one, PairDirectory two, String name) {
        String comboFile = String.format("%s.%s", one.filename, two.filename);
        ScoredPairDirectory scored = new ScoredPairDirectory(comboFile, name);
        for (String oneFirst : one.getFirsts()) {
            Set<String> oneSeconds = one.getSeconds(oneFirst);
            for (String twoFirst : two.getFirsts()) {
                Set<String> twoSeconds = two.getSeconds(twoFirst);
                double jaccard = GenUtils.jaccard(oneSeconds, twoSeconds);
                scored.add(oneFirst, twoFirst, jaccard);
            }
        }
        return scored;
    }
}

