/*
 * Decompiled with CFR 0.152.
 */
package structures;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import structures.Edge;
import structures.Graph;
import structures.Path;
import utilities.Enums;

public class PathManager {
    public static final String DEFAULT = "DEFAULT";
    protected HashMap<String, HashSet<Path>> nodesToPaths = new HashMap();
    protected HashMap<Path, HashSet<String>> pathLabels = new HashMap();
    protected HashMap<String, HashSet<Path>> labelsToPaths = new HashMap();

    public PathManager() {
    }

    public PathManager(Collection<Path> paths, String label) {
        this();
        this.addAll(paths, label);
    }

    public void addAll(PathManager pathMan) {
        for (String label : pathMan.allLabels()) {
            this.addAll(pathMan.getPathsForLabel(label), label);
        }
    }

    public void addAll(Collection<Path> paths, String label) {
        for (Path p : paths) {
            this.add(p, label);
        }
    }

    public void add(Path p, String label) {
        boolean has = this.contains(p);
        if (!this.pathLabels.containsKey(p)) {
            this.pathLabels.put(p, new HashSet());
        }
        this.pathLabels.get(p).add(label);
        if (!this.labelsToPaths.containsKey(label)) {
            this.labelsToPaths.put(label, new HashSet());
        }
        this.labelsToPaths.get(label).add(p);
        if (has) {
            return;
        }
        for (String node : p.nodes()) {
            if (!this.nodesToPaths.containsKey(node)) {
                this.nodesToPaths.put(node, new HashSet());
            }
            this.nodesToPaths.get(node).add(p);
        }
    }

    public Set<Path> allPaths() {
        return Collections.unmodifiableSet(this.pathLabels.keySet());
    }

    public PathManager reduce(Set<String> toHide, String label) {
        PathManager newPM = new PathManager();
        for (Map.Entry<String, HashSet<Path>> entry : this.labelsToPaths.entrySet()) {
            if (entry.getKey().equals(label)) {
                for (Path p : entry.getValue()) {
                    if (toHide.contains(p.getNode(0))) continue;
                    newPM.add(p, label);
                }
                continue;
            }
            newPM.addAll((Collection<Path>)entry.getValue(), entry.getKey());
        }
        return newPM;
    }

    public int size() {
        return this.pathLabels.size();
    }

    public int nodeCount() {
        return this.nodesToPaths.keySet().size();
    }

    public boolean contains(String node) {
        return this.nodesToPaths.containsKey(node);
    }

    public boolean contains(Path p) {
        return this.pathLabels.containsKey(p);
    }

    public Set<Path> getPaths(String node) {
        if (!this.nodesToPaths.containsKey(node)) {
            return null;
        }
        return Collections.unmodifiableSet((Set)this.nodesToPaths.get(node));
    }

    public Set<Path> getPathsForLabel(String label) {
        return this.labelsToPaths.get(label);
    }

    public Set<String> getLabels(Path p) {
        return this.pathLabels.get(p);
    }

    public Set<String> allLabels() {
        return Collections.unmodifiableSet(this.labelsToPaths.keySet());
    }

    public static Graph makeGraph(PathManager man) {
        Graph g = new Graph();
        for (Path p : man.allPaths()) {
            g.addAll(p.edges());
        }
        return g;
    }

    public static Collection<Edge> filterEdges(PathManager man, Collection<Edge> edges, Enums.AddEdgeMode mode) {
        if (mode == Enums.AddEdgeMode.ALL) {
            return edges;
        }
        HashSet<Edge> retEdges = new HashSet<Edge>();
        for (Edge e : edges) {
            if ((mode == Enums.AddEdgeMode.SOURCE_IN_PATH || !e.isDirected()) && man.contains(e.i())) {
                retEdges.add(e);
            }
            if (mode != Enums.AddEdgeMode.TARGET_IN_PATH && e.isDirected() || !man.contains(e.j())) continue;
            retEdges.add(e);
        }
        return retEdges;
    }

    public static HashMap<Path, HashSet<Edge>> filterSubgraphEdgesByPath(PathManager man, Collection<Edge> edges, Enums.AddEdgeMode mode) {
        HashMap<Path, HashSet<Edge>> index = new HashMap<Path, HashSet<Edge>>();
        for (Edge e : edges) {
            Set<Path> epaths;
            if (mode == Enums.AddEdgeMode.SOURCE_IN_PATH || !e.isDirected()) {
                epaths = man.getPaths(e.i());
                if (epaths == null) continue;
                for (Path p : epaths) {
                    if (!index.containsKey(p)) {
                        index.put(p, new HashSet());
                    }
                    index.get(p).add(e);
                }
            }
            if (mode != Enums.AddEdgeMode.TARGET_IN_PATH && e.isDirected() || (epaths = man.getPaths(e.j())) == null) continue;
            for (Path p : epaths) {
                if (!index.containsKey(p)) {
                    index.put(p, new HashSet());
                }
                index.get(p).add(e);
            }
        }
        return index;
    }
}

