/*
 * Decompiled with CFR 0.152.
 */
package structures;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import structures.Edge;

public class Path {
    protected final ArrayList<String> nodes;
    protected final ArrayList<Edge> edges;
    protected String toString;
    protected HashSet<String> termini;

    protected Path() {
        this.nodes = new ArrayList();
        this.edges = new ArrayList();
        this.termini = new HashSet();
    }

    public Path(String node) {
        this.nodes = new ArrayList();
        this.edges = new ArrayList();
        this.nodes.add(node);
        this.toString = this.buildString();
        this.termini = new HashSet();
        this.termini.add(node);
    }

    public Path(ArrayList<String> nodes, ArrayList<Edge> edges) {
        this.nodes = nodes;
        this.edges = edges;
        this.termini = new HashSet();
        this.termini.add(nodes.get(nodes.size() - 1));
        this.toString = this.buildString();
    }

    public Path copyAdd(Edge e) {
        assert (this.nodes.size() > 0) : "Trying to add an edge to an empty path. Don't do it.";
        String curLast = this.getNode(-1);
        String first = "";
        String second = "";
        if (e.isDirected()) {
            first = e.i();
            second = e.j();
            if (!first.equals(curLast)) {
                return null;
            }
        } else if (e.i().equals(curLast)) {
            first = e.i();
            second = e.j();
        } else if (e.j().equals(curLast)) {
            first = e.j();
            second = e.i();
        } else {
            return null;
        }
        assert (first.length() > 0 && second.length() > 0) : "Trying to an an empty node to a path.";
        if (this.nodes.contains(second)) {
            return null;
        }
        ArrayList<String> newN = new ArrayList<String>(this.nodes());
        ArrayList<Edge> newE = new ArrayList<Edge>(this.edges());
        newN.add(second);
        newE.add(e);
        return new Path(newN, newE);
    }

    public PathOrder order(String a, String b) {
        int ai = this.nodes.indexOf(a);
        int bi = this.nodes.indexOf(b);
        if (ai < 0 || bi < 0) {
            return PathOrder.NA;
        }
        assert (ai != bi) : "Called Path.order on the same node.";
        if (ai < bi) {
            return PathOrder.ABOVE;
        }
        if (bi < ai) {
            return PathOrder.BELOW;
        }
        return PathOrder.NA;
    }

    public String getNode(int i) {
        if (i < 0) {
            return this.nodes.get(this.nodes.size() + i);
        }
        return this.nodes.get(i);
    }

    public Edge getEdge(int i) {
        if (i < 0) {
            return this.edges.get(this.edges.size() + i);
        }
        return this.edges.get(i);
    }

    public int edgeLength() {
        return this.edges.size();
    }

    public List<String> nodes() {
        return Collections.unmodifiableList(this.nodes);
    }

    public List<Edge> edges() {
        return Collections.unmodifiableList(this.edges);
    }

    public Set<String> termini() {
        return Collections.unmodifiableSet(this.termini());
    }

    public Path copy() {
        Path copy = new Path(new ArrayList<String>(this.nodes), new ArrayList<Edge>(this.edges));
        return copy;
    }

    public String toString() {
        return this.toString;
    }

    protected String buildString() {
        StringBuilder sb = new StringBuilder(this.getNode(0));
        int i = 1;
        while (i < this.nodes.size()) {
            String nextN = this.nodes.get(i);
            Edge e = this.edges.get(i - 1);
            if (!e.directed) {
                switch (e.sign) {
                    case UNKNOWN: {
                        sb.append(" -- ");
                        break;
                    }
                    case POSITIVE: {
                        sb.append(" <--> ");
                        break;
                    }
                    case NEGATIVE: {
                        sb.append(" |--| ");
                    }
                }
            } else if (e.directed) {
                switch (e.sign) {
                    case UNKNOWN: {
                        sb.append(" --+ ");
                        break;
                    }
                    case POSITIVE: {
                        sb.append(" --> ");
                        break;
                    }
                    case NEGATIVE: {
                        sb.append(" --| ");
                    }
                }
            }
            sb.append(nextN);
            ++i;
        }
        return sb.toString();
    }

    public boolean equals(Object other) {
        if (!(other instanceof Path)) {
            return false;
        }
        return this.toString().equals(other.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public static enum PathOrder {
        ABOVE,
        BELOW,
        NA;

    }
}

