/*
 * Decompiled with CFR 0.152.
 */
package structures;

import exceptions.DuplicateException;
import exceptions.InvalidValueException;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Scanner;
import java.util.Set;
import structures.Node;
import utilities.Enums;

public class PairDirectory {
    protected final String filename;
    protected final String name;
    protected final HashMap<String, HashMap<String, Enums.Sign>> orderedPairs;

    protected PairDirectory(String filename, String name) {
        this.filename = filename;
        this.name = name;
        this.orderedPairs = new HashMap();
    }

    protected Enums.Sign add(String a, String b, Enums.Sign s) {
        if (!this.orderedPairs.containsKey(a)) {
            this.orderedPairs.put(a, new HashMap());
        }
        Enums.Sign overwrite = this.orderedPairs.get(a).put(b, s);
        return overwrite;
    }

    public Set<String> getFirsts() {
        return Collections.unmodifiableSet(this.orderedPairs.keySet());
    }

    public Set<String> getSeconds(String first) {
        return Collections.unmodifiableSet(this.orderedPairs.get(first).keySet());
    }

    public Set<String> getSeconds() {
        HashSet<String> seconds = new HashSet<String>();
        for (HashMap<String, Enums.Sign> secondSet : this.orderedPairs.values()) {
            seconds.addAll(secondSet.keySet());
        }
        return seconds;
    }

    public PartialOrder getOrder(String a, String b) {
        boolean back;
        boolean fw = this.orderedPairs.containsKey(a) && this.orderedPairs.get(a).containsKey(b);
        boolean bl = back = this.orderedPairs.containsKey(b) && this.orderedPairs.get(b).containsKey(a);
        if (fw && !back) {
            return PartialOrder.ABOVE;
        }
        if (back && !fw) {
            return PartialOrder.BELOW;
        }
        return PartialOrder.UNRESTRICTED;
    }

    public boolean contains(String a, String b) {
        if (this.orderedPairs.containsKey(a)) {
            return this.getSeconds(a).contains(b);
        }
        return false;
    }

    public boolean hasSelfPair(String a) {
        return this.orderedPairs.containsKey(a) && this.orderedPairs.get(a).containsKey(a);
    }

    public Enums.Sign getSign(String a, String b) {
        if (this.hasSign(a, b)) {
            return this.orderedPairs.get(a).get(b);
        }
        return Enums.Sign.UNKNOWN;
    }

    public boolean hasSign(String a, String b) {
        return this.orderedPairs.containsKey(a) && this.orderedPairs.get(a).containsKey(b);
    }

    public int size() {
        int size = 0;
        for (HashMap<String, Enums.Sign> inner : this.orderedPairs.values()) {
            size += inner.size();
        }
        return size;
    }

    public String filename() {
        return this.filename;
    }

    public static PairDirectory readOrderedPairs(String filename, String name, String targetFormat, boolean readSigns, String posText, String negText) throws InvalidValueException, DuplicateException, FileNotFoundException {
        HashMap<String, Enums.Sign> signMap = null;
        if (readSigns) {
            signMap = new HashMap<String, Enums.Sign>();
            if (posText != null) {
                signMap.put(posText, Enums.Sign.POSITIVE);
            }
            if (negText != null) {
                signMap.put(negText, Enums.Sign.NEGATIVE);
            }
        }
        Scanner s = null;
        try {
            s = new Scanner(new File(filename));
        }
        catch (FileNotFoundException fnfe) {
            throw new FileNotFoundException("Unable to read ordered pair file " + filename);
        }
        PairDirectory pairs = new PairDirectory(filename, name);
        while (s.hasNext()) {
            Object[] sp = s.nextLine().trim().split("\t");
            if (sp.length == 0 || sp[0].startsWith("#")) continue;
            if (sp.length < 2) {
                throw new InvalidValueException(String.format("Reading pairs from %s: Improper line '%s'\n", filename, Arrays.toString(sp)));
            }
            String nodeA = sp[0];
            String nodeB = String.format(targetFormat, sp[1]);
            nodeA = Node.makeNode(nodeA);
            nodeB = Node.makeNode(nodeB);
            Enums.Sign sign = Enums.Sign.UNKNOWN;
            if (readSigns && sp.length > 2 && signMap.containsKey(sp[2])) {
                sign = (Enums.Sign)((Object)signMap.get(sp[2]));
                if (pairs.hasSign(nodeA, nodeB) && sign != pairs.getSign(nodeA, nodeB)) {
                    throw new DuplicateException(String.format("We already specified a different sign for %s->%s (%s, now %s)", new Object[]{nodeA, nodeB, sign, pairs.getSign(nodeA, nodeB)}));
                }
            }
            Enums.Sign sign2 = pairs.add(nodeA, nodeB, sign);
        }
        return pairs;
    }

    public static PairDirectory readOrderedPairs(String filename, String name) throws InvalidValueException, DuplicateException, FileNotFoundException {
        return PairDirectory.readOrderedPairs(filename, name, "%s", false, null, null);
    }

    public static PairDirectory readIndirectory(String filename, String name) throws InvalidValueException, DuplicateException, FileNotFoundException {
        Scanner s = null;
        try {
            s = new Scanner(new File(filename));
        }
        catch (FileNotFoundException fnfe) {
            throw new FileNotFoundException("Unable to read Indirectory file " + filename);
        }
        PairDirectory indirectory = new PairDirectory(filename, name);
        while (s.hasNext()) {
            String[] sp = s.nextLine().trim().split("\t");
            if (sp.length == 0 || sp[0].startsWith("#")) continue;
            String event = sp[0];
            String nodeA = sp[1];
            String nodeB = sp[2];
            if (indirectory.hasSign(nodeA, nodeB)) {
                throw new DuplicateException(String.format("We already specified a sign for %s->%s (%s, now %s)", new Object[]{nodeA, nodeB, event, indirectory.getSign(nodeA, nodeB)}));
            }
            Enums.Sign read = null;
            if (event.equals("Regulation")) {
                read = Enums.Sign.UNKNOWN;
            } else if (event.equals("Positive_regulation")) {
                read = Enums.Sign.POSITIVE;
            } else if (event.equals("Negative_regulation")) {
                read = Enums.Sign.NEGATIVE;
            } else {
                throw new InvalidValueException("Unknown event type: " + event);
            }
            Enums.Sign over = indirectory.add(nodeA, nodeB, read);
            assert (over == null) : "A duplicate slipped in?";
        }
        return indirectory;
    }

    public String toString() {
        String str = String.format("PairDirectory %s.\n\tContains %d pairs. %d sources, %d unique targets.", this.filename, this.size(), this.getFirsts().size(), this.getSeconds().size());
        return str;
    }

    public String tabFormat() {
        StringBuilder sb = new StringBuilder(String.format("#PairDirectory %s:\n", this.filename));
        for (String f : this.getFirsts()) {
            for (String s : this.getSeconds(f)) {
                sb.append(String.format("%s\t%s\t%s\n", new Object[]{f, s, this.getSign(f, s)}));
            }
        }
        return sb.toString();
    }

    public static enum PartialOrder {
        ABOVE,
        BELOW,
        UNRESTRICTED;

    }
}

