/*
 * Decompiled with CFR 0.152.
 */
package structures;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import structures.CatSet;
import structures.Feature;
import structures.Value;

public abstract class Library<T> {
    protected static final String CONTENT_TYPE = "Abstract";
    protected HashMap<T, HashMap<Feature, Value>> featMap = new HashMap();
    protected HashMap<Feature, HashMap<Value, HashSet<T>>> backMap = new HashMap();
    protected HashSet<Feature> features = new HashSet();
    protected HashMap<String, Feature> featureNames = new HashMap();

    protected Library() {
    }

    public boolean addValues(Feature feature, Map<T, Value> values) {
        if (this.hasFeature(feature)) {
            return false;
        }
        boolean canAdd = this.addFeature(feature);
        if (!canAdd) {
            return false;
        }
        HashMap<Value, HashSet<T>> subBack = this.backMap.get(feature);
        for (Map.Entry<T, Value> entry : values.entrySet()) {
            T item = entry.getKey();
            Value val = entry.getValue();
            if (!this.featMap.containsKey(item)) {
                this.featMap.put(item, new HashMap());
            }
            assert (!this.hasFeature(item, feature)) : "Duplicate feature value.";
            this.featMap.get(item).put(feature, val);
            if (val instanceof CatSet) {
                CatSet cats = (CatSet)val;
                for (Value value : cats.getValue()) {
                    if (!subBack.containsKey(value)) {
                        subBack.put(value, new HashSet());
                    }
                    subBack.get(value).add(item);
                }
                continue;
            }
            if (!subBack.containsKey(val)) {
                subBack.put(val, new HashSet());
            }
            subBack.get(val).add(item);
        }
        return true;
    }

    protected abstract String getContentType();

    public String toString() {
        StringBuilder sb = new StringBuilder(String.format("%s Library: ", this.getContentType()));
        sb.append(String.format("%d feature(s) covering %d %s(s)", this.features.size(), this.featMap.size(), this.getContentType().toLowerCase()));
        for (Feature f : this.features) {
            sb.append(String.format("\n\t%s\t%d %s(s)", f.toString(), this.get(f).size(), this.getContentType().toLowerCase()));
        }
        return sb.toString();
    }

    public String summarize(Set<T> items) {
        StringBuilder sb = new StringBuilder(String.format("Summarizing features from %d %ss:", items.size(), this.getContentType().toLowerCase()));
        for (Feature f : this.features) {
            HashSet<T> intersect = new HashSet<T>(this.get(f));
            int orig = intersect.size();
            intersect.retainAll(items);
            sb.append(String.format("\n\t%s\t%d / %d %s(s)", f.toString(), intersect.size(), orig, this.getContentType().toLowerCase()));
        }
        return sb.toString();
    }

    public int size() {
        return this.featMap.size();
    }

    public Feature getFeature(String name) {
        return this.featureNames.get(name);
    }

    public Set<Feature> getFeatures() {
        return Collections.unmodifiableSet(this.backMap.keySet());
    }

    public Map<Feature, Value> getFeatures(T n) {
        if (this.featMap.containsKey(n)) {
            return Collections.unmodifiableMap((Map)this.featMap.get(n));
        }
        return null;
    }

    public Set<T> items() {
        return Collections.unmodifiableSet(this.featMap.keySet());
    }

    public boolean contains(T item) {
        return this.featMap.containsKey(item);
    }

    public boolean hasFeature(Feature feat) {
        return this.features.contains(feat);
    }

    public boolean hasFeature(T item, Feature feat) {
        return this.features.contains(feat) && this.featMap.containsKey(item) && this.featMap.get(item).containsKey(feat);
    }

    public Set<Feature> features() {
        return Collections.unmodifiableSet(this.features);
    }

    public Set<String> featureNames() {
        return Collections.unmodifiableSet(this.featureNames.keySet());
    }

    public Value getValue(T item, Feature feat) {
        if (this.hasFeature(item, feat)) {
            return this.featMap.get(item).get(feat);
        }
        return null;
    }

    public Set<T> get(Feature f) {
        if (!this.hasFeature(f)) {
            return null;
        }
        HashMap<Value, HashSet<T>> items = this.backMap.get(f);
        HashSet<T> got = new HashSet<T>();
        for (HashSet<T> set : items.values()) {
            got.addAll(set);
        }
        return got;
    }

    public Set<T> get(Feature f, Value v) {
        if (!this.hasFeature(f)) {
            return null;
        }
        HashMap<Value, HashSet<T>> items = this.backMap.get(f);
        if (items == null || v == null) {
            return null;
        }
        if (!(v instanceof CatSet)) {
            return Collections.unmodifiableSet((Set)items.get(v));
        }
        HashSet rets = new HashSet();
        CatSet c = (CatSet)v;
        for (Value value : c.getValue()) {
            rets.addAll(items.get(value));
        }
        return Collections.unmodifiableSet(rets);
    }

    protected boolean addFeature(Feature feature) {
        Value[] vs;
        boolean ok = this.features.add(feature);
        if (!ok) {
            return false;
        }
        this.featureNames.put(feature.name(), feature);
        this.backMap.put(feature, new HashMap());
        Value[] valueArray = vs = feature.values();
        int n = vs.length;
        int n2 = 0;
        while (n2 < n) {
            Value v = valueArray[n2];
            this.backMap.get(feature).put(v, new HashSet());
            ++n2;
        }
        return true;
    }
}

