/*
 * Decompiled with CFR 0.152.
 */
package structures;

import exceptions.DuplicateException;
import exceptions.InvalidValueException;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.Scanner;
import utilities.Enums;

public class Indirectory {
    protected final String filename;
    protected final HashMap<String, HashMap<String, Enums.Sign>> orderedPairs;

    protected Indirectory(String filename) {
        this.filename = filename;
        this.orderedPairs = new HashMap();
    }

    protected Enums.Sign add(String a, String b, Enums.Sign s) {
        if (!this.orderedPairs.containsKey(a)) {
            this.orderedPairs.put(a, new HashMap());
        }
        Enums.Sign overwrite = this.orderedPairs.get(a).put(b, s);
        return overwrite;
    }

    public PartialOrder requiredOrder(String a, String b) {
        boolean back;
        boolean fw = this.orderedPairs.containsKey(a) && this.orderedPairs.get(a).containsKey(b);
        boolean bl = back = this.orderedPairs.containsKey(b) && this.orderedPairs.get(b).containsKey(a);
        if (fw && !back) {
            return PartialOrder.ABOVE;
        }
        if (back && !fw) {
            return PartialOrder.BELOW;
        }
        return PartialOrder.UNRESTRICTED;
    }

    public Enums.Sign requiredSign(String a, String b) {
        if (this.specifiesSign(a, b)) {
            return this.orderedPairs.get(a).get(b);
        }
        return Enums.Sign.UNKNOWN;
    }

    public boolean specifiesSign(String a, String b) {
        return this.orderedPairs.containsKey(a) && this.orderedPairs.get(a).containsKey(b);
    }

    public int size() {
        int size = 0;
        for (HashMap<String, Enums.Sign> inner : this.orderedPairs.values()) {
            size += inner.size();
        }
        return size;
    }

    public String filename() {
        return this.filename;
    }

    public static Indirectory readIndirectory(String filename, int startCol) throws InvalidValueException, DuplicateException, FileNotFoundException {
        Scanner s = null;
        try {
            s = new Scanner(new File(filename));
        }
        catch (FileNotFoundException fnfe) {
            throw new FileNotFoundException("Unable to read Indirectory file " + filename);
        }
        Indirectory indirectory = new Indirectory(filename);
        while (s.hasNext()) {
            String[] sp = s.nextLine().trim().split("\t");
            if (sp.length == 0 || sp[0].startsWith("#")) continue;
            String event = sp[0];
            String nodeA = sp[1];
            String nodeB = sp[2];
            if (indirectory.specifiesSign(nodeA, nodeB)) {
                throw new DuplicateException(String.format("We already specified a sign for %s->%s (%s, now %s)", new Object[]{nodeA, nodeB, event, indirectory.requiredSign(nodeA, nodeB)}));
            }
            Enums.Sign read = null;
            if (event.equals("Regulation")) {
                read = Enums.Sign.UNKNOWN;
            } else if (event.equals("Positive_regulation")) {
                read = Enums.Sign.POSITIVE;
            } else if (event.equals("Negative_regulation")) {
                read = Enums.Sign.NEGATIVE;
            } else {
                throw new InvalidValueException("Unknown event type: " + event);
            }
            Enums.Sign over = indirectory.add(nodeA, nodeB, read);
            assert (over == null) : "A duplicate slipped in?";
        }
        return indirectory;
    }

    public static enum PartialOrder {
        ABOVE,
        BELOW,
        UNRESTRICTED;

    }
}

