/*
 * Decompiled with CFR 0.152.
 */
package structures;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import structures.Edge;
import structures.EdgeCollapser;
import structures.EdgeLibrary;
import utilities.Enums;
import utilities.StringUtils;

public class IfConsistentCollapser
implements EdgeCollapser {
    protected boolean doForwarding;
    protected HashSet<String> specialDirecting = null;

    public IfConsistentCollapser() {
    }

    public IfConsistentCollapser(String[] args) {
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s.contains("redirect")) {
                String[] split = s.split("=");
                String boop = split[1].substring(1, split[1].length() - 1);
                String[] nodes = boop.split("\\|");
                HashSet<String> nset = new HashSet<String>();
                String[] stringArray2 = nodes;
                int n3 = nodes.length;
                int n4 = 0;
                while (n4 < n3) {
                    String node = stringArray2[n4];
                    nset.add(node);
                    ++n4;
                }
                this.doForwardDirection(nset);
            }
            ++n2;
        }
    }

    @Override
    public HashMap<Edge, HashSet<Edge>> redirect(EdgeLibrary original) {
        if (!this.doForwarding) {
            return null;
        }
        HashMap<Edge, HashSet<Edge>> map = new HashMap<Edge, HashSet<Edge>>();
        for (Edge e : original.items()) {
            Edge redir = this.redirect(e);
            if (!map.containsKey(e)) {
                map.put(e, new HashSet());
            }
            map.get(e).add(redir);
        }
        return map;
    }

    @Override
    public HashMap<Edge, HashSet<Edge>> collapse(EdgeLibrary original) {
        HashMap<Edge, HashSet<Edge>> map = new HashMap<Edge, HashSet<Edge>>();
        HashMap collapse = new HashMap();
        for (Edge eo : original.items()) {
            HashSet<Edge> connect = original.containsConnection(eo);
            for (Edge ec : connect) {
                String prefix = ec.key.substring(0, ec.key.lastIndexOf("."));
                if (!collapse.containsKey(prefix)) {
                    collapse.put(prefix, new HashMap());
                }
                if (!((HashMap)collapse.get(prefix)).containsKey((Object)ec.sign())) {
                    ((HashMap)collapse.get(prefix)).put(ec.sign(), ec);
                }
                assert (((Edge)((HashMap)collapse.get(prefix)).get((Object)ec.sign)).equals(ec)) : String.format("duplicate edge dir/sign %s %s", ec, ((HashMap)collapse.get(prefix)).get((Object)ec.sign));
            }
        }
        for (String prefix : collapse.keySet()) {
            String[] sp = prefix.split(".");
            HashMap slot = (HashMap)collapse.get(prefix);
            if (slot.size() > 1 && slot.containsKey((Object)Enums.Sign.UNKNOWN)) {
                Edge unk = (Edge)slot.get((Object)Enums.Sign.UNKNOWN);
                HashSet had = map.put(unk, new HashSet());
                assert (had == null) : "Weird duplication??";
                Enums.Sign[] signArray = new Enums.Sign[]{Enums.Sign.POSITIVE, Enums.Sign.NEGATIVE};
                int n = signArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Enums.Sign s = signArray[n2];
                    if (slot.containsKey((Object)s)) {
                        map.get(unk).add((Edge)slot.get((Object)s));
                    }
                    ++n2;
                }
                continue;
            }
            for (Enums.Sign s : slot.keySet()) {
                HashSet<Edge> boop = new HashSet<Edge>();
                boop.add((Edge)slot.get((Object)s));
                map.put((Edge)slot.get((Object)s), boop);
            }
        }
        return map;
    }

    public Edge redirect(Edge e) {
        Edge retEdge = e;
        if (!(e.directed || !this.specialDirecting.contains(e.i()) && !this.specialDirecting.contains(e.j()) || this.specialDirecting.contains(e.i()) && this.specialDirecting.contains(e.j()))) {
            String source = this.specialDirecting.contains(e.i()) ? e.i() : e.j();
            String other = this.specialDirecting.contains(e.i()) ? e.j() : e.i();
            retEdge = new Edge(source, other, true, e.sign());
        }
        return retEdge;
    }

    @Override
    public void doForwardDirection(String node) {
        if (this.specialDirecting == null) {
            this.specialDirecting = new HashSet();
        }
        this.specialDirecting.add(node);
        this.doForwarding = true;
    }

    @Override
    public void doForwardDirection(Collection<String> nodes) {
        if (this.specialDirecting == null) {
            this.specialDirecting = new HashSet();
        }
        this.specialDirecting.addAll(nodes);
        this.doForwarding = true;
    }

    @Override
    public boolean doRedirecting() {
        return this.doForwarding;
    }

    public String toString() {
        if (this.doRedirecting()) {
            return String.format("IfConsistentCollapser\tredirect=(%s)", StringUtils.sortJoin(this.specialDirecting, "|"));
        }
        return "IfConsistentCollapser";
    }
}

