/*
 * Decompiled with CFR 0.152.
 */
package structures;

import exceptions.DuplicateException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import structures.Edge;
import structures.EdgeLibrary;
import utilities.StringUtils;

public class Graph {
    protected HashMap<String, HashMap<RType, HashMap<String, HashSet<Edge>>>> graph = new HashMap();

    public Graph() {
    }

    public Graph(Set<Edge> edges) {
        this();
        this.addAll(edges);
    }

    public Set<String> nodes() {
        return Collections.unmodifiableSet(this.graph.keySet());
    }

    public boolean contains(String node) {
        return this.graph.containsKey(node);
    }

    public Graph copy() {
        Graph newG = new Graph(this.edges());
        return newG;
    }

    public Graph restrict(Set<String> nodes) {
        Graph newG = new Graph();
        for (String a : nodes) {
            newG.add(a);
            for (String b : nodes) {
                Set<Edge> adj = this.adjacent(a, b);
                if (adj == null) continue;
                newG.addAll(adj);
            }
        }
        return newG;
    }

    public Graph removeEdgeless() {
        Graph newG = this.copy();
        for (String s : this.nodes()) {
            if (this.incident(s).size() != 0) continue;
            newG.remove(s);
        }
        return newG;
    }

    public Graph removeSelfLoops() {
        Graph unselfish = new Graph();
        for (Edge e : this.edges()) {
            if (e.isSelfLoop()) continue;
            unselfish.add(e);
        }
        return unselfish;
    }

    public boolean contains(Edge edge) {
        if (!this.contains(edge.i) || !this.contains(edge.j)) {
            return false;
        }
        boolean found = false;
        for (RType type : this.get(edge.i).keySet()) {
            found = this.get(edge.i, type).get(edge.j).contains(edge);
            if (found) break;
        }
        return found;
    }

    public Set<Edge> edges() {
        HashSet<Edge> edges = new HashSet<Edge>();
        for (String n : this.nodes()) {
            edges.addAll(this.incident(n));
        }
        return edges;
    }

    public int degree(String node) {
        return this.neighbors(node).size();
    }

    public int degree(String node, RType type) {
        try {
            return this.neighbors(node, type).size();
        }
        catch (NullPointerException npe) {
            return 0;
        }
    }

    public Set<Edge> adjacent(String a, String b) {
        HashSet found = new HashSet();
        if (this.contains(a) && this.contains(b)) {
            for (RType type : this.graph.get(a).keySet()) {
                HashMap<String, HashSet<Edge>> edgeMap = this.get(a, type);
                if (!edgeMap.containsKey(b)) continue;
                found.addAll(edgeMap.get(b));
            }
        }
        return Collections.unmodifiableSet(found);
    }

    public Set<String> neighbors(String a) {
        Set<Edge> incident = this.incident(a);
        HashSet<String> neighbors = new HashSet<String>();
        for (Edge e : incident) {
            assert (e.nodes().contains(a)) : "Node not in incident edge? Weird.";
            if (!e.i().equals(a)) {
                neighbors.add(e.i());
                continue;
            }
            if (e.j().equals(a)) continue;
            neighbors.add(e.j());
        }
        return neighbors;
    }

    public Set<String> neighbors(String a, RType type) {
        if (!this.contains(a)) {
            return null;
        }
        Set<Edge> incident = this.incident(a, type);
        HashSet<String> nodes = new HashSet<String>();
        for (Edge e : incident) {
            Set<String> enodes = e.nodes();
            enodes.remove(a);
            if (enodes.size() == 0) {
                nodes.add(a);
                continue;
            }
            nodes.addAll(enodes);
        }
        return nodes;
    }

    public Set<Edge> incident(String a, RType type) {
        if (!this.contains(a)) {
            return null;
        }
        HashSet<Edge> incident = new HashSet<Edge>();
        for (HashSet<Edge> nei : this.graph.get(a).get((Object)type).values()) {
            incident.addAll(nei);
        }
        return incident;
    }

    public Set<Edge> incident(String a) {
        HashSet<Edge> incident = new HashSet<Edge>();
        if (!this.contains(a)) {
            return incident;
        }
        for (RType type : this.graph.get(a).keySet()) {
            for (String b : this.graph.get(a).get((Object)type).keySet()) {
                HashSet<Edge> found = this.graph.get(a).get((Object)type).get(b);
                incident.addAll(found);
            }
        }
        return incident;
    }

    public boolean add(Edge edge) {
        RType jType;
        if (!this.graph.containsKey(edge.i())) {
            this.graph.put(edge.i(), this.getInnerMapTemplate());
        }
        if (!this.graph.containsKey(edge.j())) {
            this.graph.put(edge.j(), this.getInnerMapTemplate());
        }
        RType iType = edge.directed ? RType.OUTGOING : RType.UNDIRECTED;
        RType rType = jType = edge.directed ? RType.INCOMING : RType.UNDIRECTED;
        if (!this.graph.get(edge.i()).get((Object)iType).containsKey(edge.j())) {
            this.graph.get(edge.i()).get((Object)iType).put(edge.j(), new HashSet());
        }
        boolean repI = this.graph.get(edge.i()).get((Object)iType).get(edge.j()).add(edge);
        if (!this.graph.get(edge.j()).get((Object)jType).containsKey(edge.i())) {
            this.graph.get(edge.j()).get((Object)jType).put(edge.i(), new HashSet());
        }
        boolean repJ = this.graph.get(edge.j()).get((Object)jType).get(edge.i()).add(edge);
        assert (repI == repJ || edge.isSelfLoop()) : String.format("Graph imbalanced. Tried to add edge %s, but one direction was already there.", new Object[0]);
        return repI;
    }

    public void addAll(Collection<Edge> edges) {
        for (Edge e : edges) {
            this.add(e);
        }
    }

    public boolean add(String n) {
        if (this.graph.containsKey(n)) {
            return false;
        }
        HashMap<RType, HashMap<String, HashSet<Edge>>> template = this.getInnerMapTemplate();
        this.graph.put(n, template);
        return true;
    }

    public Set<Edge> remove(String a) {
        if (!this.contains(a)) {
            return null;
        }
        Set<Edge> incident = this.incident(a);
        for (Edge e : incident) {
            this.remove(e);
        }
        HashMap<RType, HashMap<String, HashSet<Edge>>> rem = this.graph.remove(a);
        return incident;
    }

    public Edge remove(Edge e) {
        if (!this.contains(e.i) || !this.contains(e.j)) {
            return null;
        }
        int found = 0;
        RType[] rTypeArray = RType.values();
        int n = rTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            boolean rem2;
            boolean rem;
            RType type = rTypeArray[n2];
            boolean bl = rem = this.get(e.i, type).containsKey(e.j) && this.get(e.i, type).get(e.j).remove(e);
            if (rem) {
                ++found;
            }
            boolean bl2 = rem2 = this.get(e.j, type).containsKey(e.i) && this.get(e.j, type).get(e.i).remove(e);
            if (rem2) {
                ++found;
            }
            if (found == 2 || found == 1 && !e.isDirected() && e.isSelfLoop()) {
                return e;
            }
            ++n2;
        }
        return null;
    }

    public static Graph createFromEdgeLibrary(EdgeLibrary el) throws DuplicateException {
        Graph g = new Graph();
        for (Edge e : el.items()) {
            g.add(e);
        }
        return g;
    }

    protected HashMap<RType, HashMap<String, HashSet<Edge>>> get(String a) {
        return this.graph.get(a);
    }

    protected HashMap<String, HashSet<Edge>> get(String a, RType type) {
        if (!this.contains(a)) {
            return null;
        }
        return this.graph.get(a).get((Object)type);
    }

    private HashMap<RType, HashMap<String, HashSet<Edge>>> getInnerMapTemplate() {
        HashMap<RType, HashMap<String, HashSet<Edge>>> template = new HashMap<RType, HashMap<String, HashSet<Edge>>>();
        RType[] rTypeArray = RType.values();
        int n = rTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            RType type = rTypeArray[n2];
            template.put(type, new HashMap());
            ++n2;
        }
        return template;
    }

    public String graphNeighborStructure() {
        StringBuilder sb = new StringBuilder();
        ArrayList<String> nodes = new ArrayList<String>(this.nodes());
        Collections.sort(nodes);
        for (String n : nodes) {
            sb.append(String.valueOf(n) + "\n");
            RType[] rTypeArray = RType.values();
            int n2 = rTypeArray.length;
            int n3 = 0;
            while (n3 < n2) {
                RType type = rTypeArray[n3];
                Set<String> neigh = this.neighbors(n, type);
                Set<Edge> edges = this.incident(n, type);
                String edgeStr = StringUtils.sortJoin(edges, ", ");
                sb.append(String.format("\t%s\t[%s]\t[%s]\n", new Object[]{type, StringUtils.sortJoin(neigh, ", "), edgeStr}));
                ++n3;
            }
        }
        return sb.toString();
    }

    public String toString() {
        return this.graphNeighborStructure();
    }

    public static enum RType {
        INCOMING,
        OUTGOING,
        UNDIRECTED;

    }
}

