/*
 * Decompiled with CFR 0.152.
 */
package structures;

import exceptions.InvalidValueException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Random;
import java.util.Scanner;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import structures.CatSet;
import structures.Continuous;
import structures.Discrete;
import structures.Node;
import structures.Value;

public final class Feature {
    private final int SEED = 12345;
    private final Random rand = new Random(12345L);
    private final String name;
    private final Value.Type type;
    private final Value[] values;
    private final String note;
    private final String source;
    private final String toString;
    public static final String DELIM = "\\|";
    private static final int MIN = 0;
    private static final int MAX = 1;
    public static final Feature DEFAULT = new Feature("DEFAULT", Value.Type.DISCRETE, new Value[]{Discrete.makeValue("default")}, "default", "default");

    public Feature(String name, Value.Type type, Value[] values, String note, String source) {
        this.name = name;
        this.type = type;
        this.values = values;
        this.note = note;
        this.source = source;
        this.toString = this.makeToString();
    }

    public boolean isComparable() {
        return this.type.isComparable();
    }

    public String name() {
        return this.name;
    }

    public Value.Type type() {
        return this.type;
    }

    public Value[] values() {
        return this.values;
    }

    public String note() {
        return this.note;
    }

    public String source() {
        return this.source;
    }

    public Value max() {
        assert (this.type == Value.Type.CONTINUOUS) : "Can't call this on a non-continuous feature.";
        return this.values[1];
    }

    public Value min() {
        assert (this.type == Value.Type.CONTINUOUS) : "Can't call this on a non-continuous feature.";
        return this.values[0];
    }

    private boolean legalString(String testValue) {
        Value[] valueArray = this.values;
        int n = this.values.length;
        int n2 = 0;
        while (n2 < n) {
            Value s = valueArray[n2];
            if (s.toString().equals(testValue)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean legalContinuous(String testValue) {
        double dMin = ((Continuous)this.values[0]).getValue();
        double dMax = ((Continuous)this.values[1]).getValue();
        double val = -1.0;
        try {
            val = Double.parseDouble(testValue);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return val >= dMin && val <= dMax;
    }

    public Value legal(String testValue) {
        if (this.type == Value.Type.DISCRETE) {
            if (this.legalString(testValue)) {
                return Discrete.makeValue(testValue);
            }
            return null;
        }
        if (this.type == Value.Type.CONTINUOUS) {
            if (this.legalContinuous(testValue)) {
                return Continuous.makeValue(testValue);
            }
            return null;
        }
        if (this.type == Value.Type.SET) {
            String[] vals = testValue.split(DELIM);
            if (vals.length == 0) {
                return null;
            }
            HashSet<Discrete> set = new HashSet<Discrete>();
            String[] stringArray = vals;
            int n = vals.length;
            int n2 = 0;
            while (n2 < n) {
                String v = stringArray[n2];
                if (!this.legalString(v)) {
                    return null;
                }
                set.add(Discrete.makeValue(v));
                ++n2;
            }
            return CatSet.makeValue(set);
        }
        assert (false) : String.format("Value type %s not implemented (Feature %s)", new Object[]{this.type, this.name});
        return null;
    }

    public String toString() {
        return this.toString;
    }

    private String makeToString() {
        String vals = "";
        int i = 0;
        while (i < this.values.length) {
            vals = String.valueOf(vals) + this.values[i] + ",";
            ++i;
        }
        String s = String.format("%s\t%s\t[%s]", this.name, this.type.toString(), vals.substring(0, vals.length() - 1));
        return s;
    }

    public boolean equals(Object other) {
        if (other instanceof Feature) {
            return this.toString().equals(other.toString());
        }
        return false;
    }

    public int hashCode() {
        return this.toString.hashCode();
    }

    public static HashMap<String, Value> readNodeFeature(Feature feature, String filename, String delim, int col) throws IOException, InvalidValueException {
        Scanner s = null;
        try {
            s = new Scanner(new File(filename));
        }
        catch (FileNotFoundException fnfe) {
            throw new FileNotFoundException(String.format("Couldn't find the feature file %s", filename));
        }
        HashMap<String, Value> values = new HashMap<String, Value>();
        while (s.hasNext()) {
            String[] sp;
            String line = s.nextLine().trim();
            if (line.startsWith("#") || (sp = line.split(delim)).length < col + 1) continue;
            String nodeID = Node.makeNode(sp[0].trim());
            if (values.containsKey(nodeID)) {
                throw new InvalidValueException(String.format("Feature %s, file %s: Duplicate node key '%s'", feature.name, filename, nodeID));
            }
            if (sp[col].length() == 0) continue;
            Value value = feature.legal(sp[col]);
            if (value == null) {
                throw new InvalidValueException(String.format("Feature %s, file %s: Invalid value '%s'", feature.name, filename, sp[col]));
            }
            values.put(nodeID, value);
        }
        return values;
    }

    public static HashMap<String, Value> readNodeFeatureDefaultValue(Feature feature, Value value, String filename, String delim, int col) throws IOException, InvalidValueException {
        Scanner s = null;
        try {
            s = new Scanner(new File(filename));
        }
        catch (FileNotFoundException fnfe) {
            throw new FileNotFoundException(String.format("Couldn't find the feature file %s", filename));
        }
        HashMap<String, Value> values = new HashMap<String, Value>();
        while (s.hasNext()) {
            String line = s.nextLine().trim();
            if (line.startsWith("#")) continue;
            String[] sp = line.split(delim);
            if (sp.length < col + 1) {
                throw new InvalidValueException(String.format("Trying to read node set for Feature %s, file %s: Too few fields on line '%s'", feature.name, filename, line));
            }
            String nodeID = Node.makeNode(sp[col]);
            if (nodeID.length() == 0) {
                throw new InvalidValueException(String.format("Feature %s, file %s: No node node key on this line '%s'", feature.name, filename, line));
            }
            if (values.containsKey(nodeID) && !values.get(nodeID).equals(value)) {
                throw new InvalidValueException(String.format("Feature %s, file %s: Duplicate node key '%s'", feature.name, filename, nodeID));
            }
            values.put(nodeID, value);
        }
        if (values.size() == 0) {
            throw new InvalidValueException(String.format("Feature %s, file %s: No nodes in file?", feature.name, filename));
        }
        return values;
    }

    public static Feature readFeatureDeclaration(String dec, String note, String source) throws InvalidValueException {
        String PAT_STR = "([0-9A-Za-z_\\-]+)=([\\.0-9A-Za-z_\\-]+)\\(([\\.0-9A-Za-z_\\-\\|]+)\\)";
        Pattern PAT = Pattern.compile(PAT_STR);
        Matcher m = PAT.matcher(dec);
        if (!m.find()) {
            throw new InvalidValueException("Can't build a feature out of this string: " + dec);
        }
        String name = m.group(1);
        Value.Type type = Value.Type.fromString(m.group(2).toUpperCase());
        String[] valStrs = m.group(3).split(DELIM);
        Value[] vals = Value.convert(type, valStrs);
        Feature feat = new Feature(name, type, vals, note, source);
        return feat;
    }

    public static Set<String> getFeatureNames(Set<Feature> feats) {
        HashSet<String> names = new HashSet<String>();
        for (Feature f : feats) {
            names.add(f.name());
        }
        return names;
    }

    public Value random() {
        if (this.type == Value.Type.CONTINUOUS) {
            double max = ((Continuous)this.max()).getValue();
            double min = ((Continuous)this.min()).getValue();
            double r = min + this.rand.nextDouble() * (max - min);
            return Continuous.makeValue(new Double(r).toString());
        }
        if (this.type == Value.Type.DISCRETE || this.type == Value.Type.ORDINAL) {
            int r = this.rand.nextInt(this.values.length);
            return this.values[r];
        }
        if (this.type == Value.Type.SET) {
            ArrayList<Discrete> vals = new ArrayList<Discrete>();
            double numVals = (double)this.rand.nextInt(this.values.length - 1) + 1.0;
            double prop = numVals / (double)this.values.length;
            Value[] valueArray = this.values;
            int n = this.values.length;
            int n2 = 0;
            while (n2 < n) {
                Value v = valueArray[n2];
                double test = this.rand.nextDouble();
                if (test <= prop) {
                    vals.add((Discrete)v);
                }
                ++n2;
            }
            return CatSet.makeValue(vals);
        }
        assert (false) : "Not implemented";
        return null;
    }

    public Value[] random(int num) {
        Value[] vals = new Value[num];
        int i = 0;
        while (i < vals.length) {
            if (this.type == Value.Type.CONTINUOUS) {
                double max = ((Continuous)this.max()).getValue();
                double min = ((Continuous)this.min()).getValue();
                double r = min + this.rand.nextDouble() * (max - min);
                vals[i] = Continuous.makeValue(new Double(r).toString());
            } else {
                int r = this.rand.nextInt(this.values.length);
                vals[i] = this.values[r];
            }
            ++i;
        }
        return vals;
    }
}

