/*
 * Decompiled with CFR 0.152.
 */
package structures;

import exceptions.DuplicateException;
import exceptions.InvalidValueException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import structures.CatSet;
import structures.Continuous;
import structures.Discrete;
import structures.Edge;
import structures.EdgeCollapser;
import structures.Feature;
import structures.Library;
import structures.Node;
import structures.Value;
import utilities.Enums;

public class EdgeLibrary
extends Library<Edge> {
    protected static final String CONTENT_TYPE = "Edge";
    public static final String COMMENT = "#";
    protected ArrayList<String> filenames = new ArrayList();
    protected HashMap<Edge, ArrayList<String>> edgeFns = new HashMap();
    public static final Feature COUNT_FEATURE = new Feature("count", Value.Type.CONTINUOUS, new Value[]{Continuous.makeValue(0.0), Continuous.makeValue(2.147483647E9)}, "count of instances of this edge", "on-demand");

    public EdgeLibrary() {
        if (!this.hasFeature(COUNT_FEATURE)) {
            this.addFeature(COUNT_FEATURE);
        }
    }

    @Override
    protected String getContentType() {
        return CONTENT_TYPE;
    }

    public List<String> getFilenames() {
        return Collections.unmodifiableList(this.filenames);
    }

    public List<String> getFilenames(Edge e) {
        return Collections.unmodifiableList((List)this.edgeFns.get(e));
    }

    public HashSet<Edge> containsConnection(String a, String b) {
        HashSet<Edge> contained = new HashSet<Edge>();
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        boolean[] blArray2 = blArray;
        int n = blArray.length;
        int n2 = 0;
        while (n2 < n) {
            boolean dir = blArray2[n2];
            Enums.Sign[] signArray = Enums.Sign.values();
            int n3 = signArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Enums.Sign sign = signArray[n4];
                Edge test1 = new Edge(a, b, dir, sign);
                Edge test2 = new Edge(b, a, dir, sign);
                if (this.contains(test1)) {
                    contained.add(test1);
                }
                if (this.contains(test2)) {
                    contained.add(test2);
                }
                ++n4;
            }
            ++n2;
        }
        return contained;
    }

    public HashSet<Edge> containsConnection(Edge e) {
        return this.containsConnection(e.i, e.j);
    }

    protected boolean uniqueConnection(Edge e) {
        HashSet<Edge> contained = this.containsConnection(e);
        return contained.contains(e) && contained.size() == 1;
    }

    public boolean addValues(Edge e, Map<Feature, Value> vals) {
        boolean ok = true;
        if (this.contains(e)) {
            Map<Feature, Value> myFeats = this.getFeatures(e);
            ArrayList<Feature> newFeats = new ArrayList<Feature>(vals.keySet());
            for (Feature f : newFeats) {
                if (!myFeats.containsKey(f)) continue;
                if (vals.get(f) != myFeats.get(f) && !f.type().equals((Object)Value.Type.SET)) {
                    ok = false;
                    continue;
                }
                if (vals.get(f) == myFeats.get(f) || !f.type().equals((Object)Value.Type.SET)) continue;
                CatSet newVal = (CatSet)vals.get(f);
                CatSet curVal = (CatSet)myFeats.get(f);
                HashSet<Discrete> newSet = new HashSet<Discrete>(curVal.getValue());
                newSet.addAll(newVal.getValue());
                vals.put(f, CatSet.makeValue(newSet));
            }
        }
        if (ok) {
            for (Map.Entry<Feature, Value> entry : vals.entrySet()) {
                boolean addFeature = this.addFeature(entry.getKey());
                boolean ok2 = this.addValue(e, entry.getKey(), entry.getValue(), true);
                assert (ok2) : String.format("Problem adding feature %s for edge %s", entry.getKey().name(), e);
            }
        }
        return ok;
    }

    private boolean addValue(Edge e, Feature f, Value val, boolean force) {
        Value add;
        assert (this.features.contains(f)) : String.format("Feature %s hasn't been added already.", f.name());
        boolean overwriting = false;
        if (this.hasFeature(e, f)) {
            if (val != this.getValue(e, f) && !force) {
                return false;
            }
            if (val == this.getValue(e, f)) {
                return true;
            }
            if (force) {
                overwriting = true;
            }
        }
        if (!this.contains(e)) {
            this.featMap.put(e, new HashMap());
        }
        if ((add = ((HashMap)this.featMap.get(e)).put(f, val)) != null && !force) {
            return false;
        }
        if (!(val instanceof CatSet)) {
            HashMap subBack = (HashMap)this.backMap.get(f);
            assert (subBack != null && val != null) : "wtf";
            if (!subBack.containsKey(val)) {
                subBack.put(val, new HashSet());
            }
            ((HashSet)subBack.get(val)).add(e);
            if (overwriting) {
                ((HashSet)subBack.get(add)).remove(e);
            }
        } else {
            CatSet catval = (CatSet)val;
            for (Value value : catval.getValue()) {
                HashMap subBack = (HashMap)this.backMap.get(f);
                assert (subBack != null && val != null) : "wtf";
                if (!subBack.containsKey(value)) {
                    subBack.put(val, new HashSet());
                }
                ((HashSet)subBack.get(value)).add(e);
            }
        }
        return true;
    }

    public boolean addAll(EdgeLibrary other) throws IncompatibleException {
        for (Edge e : other.items()) {
            HashMap<Feature, Value> feats = new HashMap<Feature, Value>(other.getFeatures(e));
            feats.remove(COUNT_FEATURE);
            double ocount = ((Continuous)other.getValue(e, COUNT_FEATURE)).getValue();
            double thiscount = this.contains(e) ? ((Continuous)this.getValue(e, COUNT_FEATURE)).getValue() : 0.0;
            boolean ok = this.addValues(e, feats);
            if (!ok) {
                throw new IncompatibleException("Incoming EdgeLibrary overwrites one or more features for some edge.");
            }
            this.addValue(e, COUNT_FEATURE, Continuous.makeValue(ocount + thiscount), true);
            if (!this.edgeFns.containsKey(e)) {
                this.edgeFns.put(e, new ArrayList());
            }
            this.edgeFns.get(e).addAll((Collection<String>)other.edgeFns.get(e));
        }
        return this.filenames.addAll(other.filenames);
    }

    public static EdgeLibrary readEdges(String filename, int start, Map<Feature, Value> autoFeats, HashSet<Integer> readCols, String srcFormat, String tarFormat) throws IOException, InvalidValueException, DuplicateException {
        EdgeLibrary el = new EdgeLibrary();
        try (Scanner s = null;){
            try {
                s = new Scanner(new File(filename));
                if (autoFeats != null) {
                    for (Feature f : autoFeats.keySet()) {
                        boolean ok = el.addFeature(f);
                        assert (ok) : "Something wrong with addFeature on adding default feature " + f.name();
                    }
                }
                el.addFeature(COUNT_FEATURE);
                HashMap<Integer, Feature> readFeatures = new HashMap<Integer, Feature>();
                if (readCols != null) {
                    String[] headers = s.nextLine().split("\t");
                    for (Integer i : readCols) {
                        String decl = headers[i];
                        Feature feat = Feature.readFeatureDeclaration(decl, String.format("column %d", i), filename);
                        el.addFeature(feat);
                        readFeatures.put(i, feat);
                    }
                }
                HashMap<Edge, Integer> counts = new HashMap<Edge, Integer>();
                boolean first = true;
                while (s.hasNext()) {
                    boolean bl;
                    String line = s.nextLine();
                    if (line.length() == 0 || line.startsWith(COMMENT) || line.length() == 0 || line.contains("dir") && line.contains("sign")) continue;
                    Object[] split = line.split("\t");
                    if (first && split.length < 4) {
                        first = false;
                        continue;
                    }
                    split[split.length - 1] = split[split.length - 1].trim();
                    if (split.length < 2) {
                        System.err.println(Arrays.toString(split));
                    }
                    Object aStr = srcFormat == null ? split[start] : String.format(srcFormat, split[start]);
                    Object bStr = tarFormat == null ? split[start + 1] : String.format(tarFormat, split[start + 1]);
                    String a = Node.makeNode((String)aStr);
                    String b = Node.makeNode((String)bStr);
                    assert (!a.contains(COMMENT) && !b.contains(COMMENT)) : String.valueOf(filename) + " might be weird: " + line;
                    boolean dir = ((String)split[start + 2]).trim().equals("1");
                    if (!dir && b.compareTo(a) < 0) {
                        String temp = b;
                        b = a;
                        a = temp;
                    }
                    Enums.Sign sign = Enums.Sign.fromValue(Integer.parseInt(((String)split[start + 3]).trim()));
                    Edge e = new Edge(a, b, dir, sign);
                    boolean dup = false;
                    if (!el.contains(e)) {
                        counts.put(e, 1);
                    } else {
                        counts.put(e, (Integer)counts.get(e) + 1);
                        dup = true;
                    }
                    HashMap<Feature, Value> feats = new HashMap<Feature, Value>();
                    if (autoFeats != null) {
                        for (Feature feature : autoFeats.keySet()) {
                            Value v = autoFeats.get(feature);
                            feats.put(feature, v);
                        }
                    }
                    if (readCols != null) {
                        for (Map.Entry entry : readFeatures.entrySet()) {
                            Integer col = (Integer)entry.getKey();
                            Feature feat = (Feature)entry.getValue();
                            boolean hasVal = false;
                            Value val = null;
                            if (split.length > col && ((String)split[col]).length() > 0) {
                                val = feat.legal((String)split[col]);
                                boolean bl2 = hasVal = val != null;
                            }
                            if (val == null && hasVal) {
                                throw new InvalidValueException(String.format("Bad value for feature %s: %s", feat.name(), split[col]));
                            }
                            if (val == null) continue;
                            feats.put(feat, val);
                        }
                    }
                    if (bl = el.addValues(e, feats)) continue;
                    throw new DuplicateException(String.format("EdgeLibe %s: Some feature defined (at least) twice for edge %s", filename, e));
                }
                for (Edge e : counts.keySet()) {
                    Continuous c = Continuous.makeValue(((Integer)counts.get(e)).intValue());
                    boolean success = el.addValue(e, COUNT_FEATURE, c, false);
                    assert (success) : "Weird trouble adding count values when reading file? " + filename + ", " + e;
                }
                el.filenames.add(filename);
                for (Edge e : el.items()) {
                    el.edgeFns.put(e, new ArrayList());
                    el.edgeFns.get(e).add(filename);
                }
            }
            catch (IOException ioe) {
                throw new IOException(String.format("Couldn't read edge file '%s'", filename));
            }
        }
        return el;
    }

    public EdgeLibrary collapse(EdgeCollapser collapser) {
        HashMap<Edge, HashSet<Edge>> map;
        EdgeLibrary origLibe = this;
        if (collapser.doRedirecting()) {
            map = collapser.redirect(this);
            origLibe = EdgeLibrary.resolve(this, map);
        }
        map = collapser.collapse(origLibe);
        EdgeLibrary resolved = EdgeLibrary.resolve(origLibe, map);
        return resolved;
    }

    public static EdgeLibrary resolve(EdgeLibrary orig, HashMap<Edge, HashSet<Edge>> map) {
        EdgeLibrary newLibe = new EdgeLibrary();
        for (Feature f : orig.features) {
            newLibe.addFeature(f);
        }
        for (Edge oe : map.keySet()) {
            HashMap<Feature, Value> ofeat = new HashMap<Feature, Value>(orig.getFeatures(oe));
            ofeat.remove(COUNT_FEATURE);
            HashSet<String> filenames = new HashSet<String>(orig.getFilenames(oe));
            Continuous oriCount = (Continuous)orig.getValue(oe, COUNT_FEATURE);
            for (Edge me : map.get(oe)) {
                Continuous meCount = Continuous.makeValue(0.0);
                if (!newLibe.contains(me) && orig.contains(me)) {
                    HashMap<Feature, Value> mefeats = new HashMap<Feature, Value>(orig.getFeatures(me));
                    mefeats.remove(COUNT_FEATURE);
                    boolean success = newLibe.addValues(me, mefeats);
                    assert (success) : "EdgeLibrary.collapse: Problem adding original feature values for edge " + me;
                    meCount = (Continuous)orig.getValue(me, COUNT_FEATURE);
                } else if (orig.contains(me)) {
                    meCount = (Continuous)orig.getValue(me, COUNT_FEATURE);
                }
                boolean success1 = newLibe.addValues(me, ofeat);
                assert (success1) : "You need to debug this, yo";
                if (me.equals(oe)) {
                    newLibe.addValue(me, COUNT_FEATURE, meCount, true);
                } else {
                    Continuous newCount = Continuous.makeValue(oriCount.getValue() + meCount.getValue());
                    newLibe.addValue(me, COUNT_FEATURE, newCount, true);
                }
                if (orig.contains(me)) {
                    filenames.addAll(orig.getFilenames(me));
                }
                newLibe.edgeFns.put(me, new ArrayList<String>(filenames));
            }
        }
        HashSet<String> masterfn = new HashSet<String>(orig.filenames);
        newLibe.filenames = new ArrayList<String>(masterfn);
        return newLibe;
    }

    public class IncompatibleException
    extends Exception {
        IncompatibleException(String message) {
            super(message);
        }
    }
}

