/*
 * Decompiled with CFR 0.152.
 */
package structures;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import structures.Edge;
import structures.EdgeLibrary;
import structures.IfConsistentCollapser;

public interface EdgeCollapser {
    public HashMap<Edge, HashSet<Edge>> collapse(EdgeLibrary var1);

    public void doForwardDirection(String var1);

    public void doForwardDirection(Collection<String> var1);

    public boolean doRedirecting();

    public HashMap<Edge, HashSet<Edge>> redirect(EdgeLibrary var1);

    public static enum Collapser {
        IF_CONSISTENT_COLLAPSER("IfConsistentCollapser");

        private String name;

        private Collapser(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public static Collapser fromName(String name) {
            Collapser[] collapserArray = Collapser.values();
            int n = collapserArray.length;
            int n2 = 0;
            while (n2 < n) {
                Collapser c = collapserArray[n2];
                if (name.equals(c.getName())) {
                    return c;
                }
                ++n2;
            }
            return null;
        }

        public EdgeCollapser make(String[] args) {
            switch (this) {
                case IF_CONSISTENT_COLLAPSER: {
                    return new IfConsistentCollapser(args);
                }
            }
            return null;
        }

        public EdgeCollapser make() {
            switch (this) {
                case IF_CONSISTENT_COLLAPSER: {
                    return new IfConsistentCollapser();
                }
            }
            return null;
        }
    }
}

