/*
 * Decompiled with CFR 0.152.
 */
package structures;

import java.util.HashSet;
import java.util.Set;
import utilities.Enums;

public class Edge
implements Comparable<Edge> {
    protected final String i;
    protected final String j;
    protected final String key;
    protected final boolean directed;
    protected Enums.Sign sign;

    public Edge(String i, String j, boolean directed, Enums.Sign sign) {
        this.i = i;
        this.j = j;
        this.directed = directed;
        this.sign = sign;
        this.key = this.makeKey();
    }

    public Edge(String i, String j, boolean directed) {
        this(i, j, directed, Enums.Sign.UNKNOWN);
    }

    public Edge(String i, String j, Enums.Sign sign) {
        this(i, j, false, sign);
    }

    private String makeKey() {
        String d = this.directed ? "d" : "u";
        return String.format("%s.%s.%s.%s", this.i, this.j, d, this.sign.abbrev());
    }

    public boolean isDirected() {
        return this.directed;
    }

    public Enums.Sign sign() {
        return this.sign;
    }

    public boolean isSelfLoop() {
        return this.i.equals(this.j);
    }

    public String i() {
        return this.i;
    }

    public String j() {
        return this.j;
    }

    public Set<String> nodes() {
        HashSet<String> nodes = new HashSet<String>();
        nodes.add(this.i);
        nodes.add(this.j);
        return nodes;
    }

    public boolean isSource(String a) {
        if (this.directed) {
            return a.equals(this.i);
        }
        return a.equals(this.i) || a.equals(this.j);
    }

    public boolean isTarget(String a) {
        if (this.directed) {
            return a.equals(this.j);
        }
        return a.equals(this.i) || a.equals(this.j);
    }

    public String toString() {
        return this.key;
    }

    public boolean equals(Object other) {
        if (!(other instanceof Edge)) {
            return false;
        }
        return this.toString().equals(other.toString());
    }

    @Override
    public int compareTo(Edge other) {
        return this.key.compareTo(other.key);
    }

    public int hashCode() {
        return this.key.hashCode();
    }
}

