/*
 * Decompiled with CFR 0.152.
 */
package structures;

import java.util.HashMap;
import structures.Value;

public class Continuous
extends Value {
    private double value;
    private static HashMap<String, Continuous> created = new HashMap();

    private Continuous(String s) throws NumberFormatException {
        this.value = Double.parseDouble(s);
    }

    private Continuous(double d) {
        this.value = d;
    }

    public double getValue() {
        return this.value;
    }

    @Override
    public Value.Type getType() {
        return Value.Type.CONTINUOUS;
    }

    public static Continuous makeValue(String ds) {
        if (!created.containsKey(ds)) {
            Continuous cont = new Continuous(Double.parseDouble(ds));
            created.put(ds, cont);
        }
        return created.get(ds);
    }

    public static Continuous makeValue(double d) {
        String ds = Double.toString(d);
        return Continuous.makeValue(ds);
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object other) {
        if (!(other instanceof Continuous)) {
            return false;
        }
        return this.toString().equals(other.toString());
    }

    @Override
    public int compareTo(Continuous other) {
        return Double.compare(this.value, other.value);
    }

    @Override
    public int compareTo(Value other) {
        if (other instanceof Continuous) {
            return this.compareTo((Continuous)other);
        }
        return this.toString().compareTo(other.toString());
    }
}

