/*
 * Decompiled with CFR 0.152.
 */
package structures;

import exceptions.DuplicateException;
import exceptions.IncomparableException;
import exceptions.InvalidValueException;
import filters.EdgeFilterManager;
import filters.Filter;
import filters.FilterManager;
import filters.GraphNodeFilterManager;
import filters.NodeFilterManager;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import pathfinders.PathFinder;
import structures.Edge;
import structures.EdgeCollapser;
import structures.EdgeLibrary;
import structures.Feature;
import structures.Graph;
import structures.NodeLibrary;
import structures.Pair;
import structures.PairDirectory;
import structures.ScoredPairDirectory;
import structures.Subgraph;
import structures.Value;
import utilities.Enums;
import utilities.GamsPrinter;
import utilities.GraphUtils;

public final class Configuration {
    public static final String NODE_FEATURE = "NFEATURE";
    public static final String EDGE_FEATURE = "EFEATURE";
    public static final String EDGE_FILTER = "EFILTER";
    public static final String NODE_FILTER = "NFILTER";
    public static final String EDGE_LIBRARY = "EDGE_LIBRARY";
    public static final String NFILTER_MODE = "NFILTERMODE";
    public static final String EFILTER_MODE = "EFILTERMODE";
    public static final String NODE_FILTER_MAN = "NFILTERMANAGER";
    public static final String EDGE_FILTER_MAN = "EFILTERMANAGER";
    public static final String NAME = "NAME";
    public static final String PATHFINDER = "PATHFINDER";
    public static final String GRAPH_FILTER = "GFILTER";
    public static final String G_FILTER_MAN = "GFILTERMANAGER";
    public static final String FILTER_GRAPH = "FILTER_GRAPH";
    public static final String GAMS_FILE = "GAMS_FILE";
    public static final String INDIRECTORY = "INDIRECTORY";
    public static final String PAIRS = "ST_PAIRS";
    public static final String COLLAPSER = "COLLAPSER";
    public static final String OUTPUT = "OUT_PREFIX";
    public static final String SUBGRAPH = "SUBGRAPH";
    public static final String GAMS_REQ_CAND = "GAMS_REQ_CAND";
    public static final String GAMS_EFEATS = "GAMS_EFEATS";
    public static final String GAMS_NFEATS = "GAMS_NFEATS";
    public static final String GAMS_LABEL_MODE = "GAMS_LABEL_MODE";
    public static final String SCORED_PAIRDIR = "SCORED_PAIRS";
    public static final String HIDE_HIT_DIR = "HIDE_HIT_DIR";
    public static final String AND = "and";
    public static final String OR = "or";
    public static final String VAL_DELIM = "\\|";
    public static final String COMMENT = "#";
    protected HashMap<String, NodeFilterManager> nodeFilterMans;
    protected HashMap<String, GraphNodeFilterManager> graphFilterMans;
    protected HashMap<String, EdgeFilterManager> edgeFilterMans;
    protected HashMap<String, Filter> nodeFilters;
    protected HashMap<String, Filter> edgeFilters;
    protected HashMap<String, Filter> graphFilters;
    protected ArrayList<FilterManager> applyToGraph;
    protected NodeLibrary nodeLibe;
    protected EdgeLibrary edgeLibe;
    protected HashSet<String> graphFeats;
    protected HashMap<String, PairDirectory> pairDirs;
    protected HashMap<String, ScoredPairDirectory> scoredPairs;
    protected ArrayList<PathFinder> pathFinders;
    protected HashMap<String, Subgraph> subgraphs;
    protected HashMap<String, Enums.AddEdgeMode> subgraphAddMode;
    protected EdgeCollapser collapser;
    protected String gamsFn = "System.out";
    protected String outPrefix = "output";
    protected String hideHitDir = null;
    protected String[] gamsEFeats = null;
    protected String[] gamsNFeats = null;
    protected GamsPrinter.LabelMode gamsLabelMode = GamsPrinter.LabelMode.STRIP;

    protected Configuration() {
        this.nodeLibe = new NodeLibrary();
        this.edgeLibe = new EdgeLibrary();
        this.nodeFilters = new HashMap();
        this.edgeFilters = new HashMap();
        this.graphFilters = new HashMap();
        this.nodeFilterMans = new HashMap();
        this.graphFilterMans = new HashMap();
        this.edgeFilterMans = new HashMap();
        this.applyToGraph = new ArrayList();
        this.pairDirs = new HashMap();
        this.pathFinders = new ArrayList();
        this.subgraphs = new HashMap();
        this.subgraphAddMode = new HashMap();
    }

    public Graph buildGraph() throws DuplicateException {
        Graph g = Graph.createFromEdgeLibrary(this.edgeLibrary());
        for (FilterManager fm : this.applyToGraph) {
            g = fm.filter(g);
        }
        return g;
    }

    public NodeLibrary nodeLibrary() {
        return this.nodeLibe;
    }

    public EdgeLibrary edgeLibrary() {
        return this.edgeLibe;
    }

    public Map<String, Filter> nodeFilters() {
        return Collections.unmodifiableMap(this.nodeFilters);
    }

    public ArrayList<PathFinder> pathFinders() {
        return this.pathFinders;
    }

    public String getGamsFileName() {
        return this.gamsFn;
    }

    protected void setGamsFile(String gamsFn) {
        this.gamsFn = gamsFn;
    }

    public GamsPrinter.LabelMode getGamsLabelMode() {
        return this.gamsLabelMode;
    }

    protected void setGamsLabelMode(GamsPrinter.LabelMode mode) {
        this.gamsLabelMode = mode;
    }

    public String[] getGamsEdgeFeatureNames() {
        return this.gamsEFeats;
    }

    protected void setGamsEdgeFeatureNames(String[] feats) {
        this.gamsEFeats = feats;
    }

    public String[] getGamsNodeFeatureNames() {
        return this.gamsNFeats;
    }

    protected void setGamsNodeFeatureNames(String[] feats) {
        this.gamsNFeats = feats;
    }

    public String getOutputPrefix() {
        return this.outPrefix;
    }

    protected void setOutputPrefix(String pref) {
        this.outPrefix = pref;
    }

    public String getHiddenHitDirectory() {
        return this.hideHitDir;
    }

    protected void setHiddenHitDirectory(String fn) {
        this.hideHitDir = fn;
    }

    public Filter getNodeFilter(String name) {
        return this.nodeFilters.get(name);
    }

    public NodeFilterManager getNodeFilterManager(String name) {
        return this.nodeFilterMans.get(name);
    }

    public EdgeFilterManager getEdgeFilterManager(String name) {
        return this.edgeFilterMans.get(name);
    }

    public GraphNodeFilterManager getGraphFilterManager(String name) {
        return this.graphFilterMans.get(name);
    }

    public Subgraph getSubgraph(String name) {
        return this.subgraphs.get(name);
    }

    public Map<String, Subgraph> subgraphs() {
        return Collections.unmodifiableMap(this.subgraphs);
    }

    public Map<String, Enums.AddEdgeMode> subgraphAddModes() {
        return Collections.unmodifiableMap(this.subgraphAddMode);
    }

    public Map<String, GraphNodeFilterManager> graphFilterManagers() {
        return Collections.unmodifiableMap(this.graphFilterMans);
    }

    public Map<String, NodeFilterManager> nodeFilterManagers() {
        return Collections.unmodifiableMap(this.nodeFilterMans);
    }

    public Map<String, Filter> edgeFilters() {
        return Collections.unmodifiableMap(this.edgeFilters);
    }

    public Filter getEdgeFilter(String name) {
        return this.edgeFilters.get(name);
    }

    public Map<String, Filter> graphFilters() {
        return Collections.unmodifiableMap(this.graphFilters);
    }

    public Filter getGraphFilter(String name) {
        return this.graphFilters.get(name);
    }

    public Map<String, PairDirectory> pairDirectories() {
        return Collections.unmodifiableMap(this.pairDirs);
    }

    public PairDirectory getPairDirectory(String name) {
        return this.pairDirs.get(name);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Configuration:\n");
        sb.append(String.format("%s\n", this.nodeLibe.toString()));
        sb.append(String.format("%s", this.edgeLibe.toString()));
        return sb.toString();
    }

    protected boolean addNodeFeature(Feature f, Map<String, Value> vals) {
        return this.nodeLibe.addValues(f, vals);
    }

    public static Configuration readConfigFile(String configFile) throws DuplicateException, IOException, InvalidValueException, IncomparableException, EdgeLibrary.IncompatibleException {
        Scanner s = null;
        try {
            s = new Scanner(new File(configFile));
        }
        catch (FileNotFoundException fnfe) {
            throw new FileNotFoundException(String.format("Unable to find config file '%s'", configFile));
        }
        Configuration config = new Configuration();
        while (s.hasNext()) {
            String f;
            int n;
            int n2;
            String[] stringArray;
            String[] feats;
            Filter filter;
            Object f2;
            String line = s.nextLine().trim();
            if (line.startsWith(COMMENT) || line.length() == 0) continue;
            String[] sp = line.split("\t");
            if (sp[0].equals(NODE_FEATURE) && sp.length > 2) {
                Pair<Feature, Map<String, Value>> pair = Configuration.readNodeFeature(sp);
                config.addNodeFeature(pair.first(), pair.second());
                continue;
            }
            if (sp.length == 2 && (sp[0].equals(NODE_FEATURE) || sp[0].equals(EDGE_FEATURE))) {
                Feature feat = Feature.readFeatureDeclaration(sp[1], "read from config", configFile);
                try {
                    GraphUtils.GraphFeature gf = GraphUtils.GraphFeature.valueOf(feat.name());
                    throw new InvalidValueException(String.format("Declared feature name '%s' is reserved for graphs.", feat.name()));
                }
                catch (IllegalArgumentException gf) {
                    if (sp[0].equals(NODE_FEATURE)) {
                        config.nodeLibe.addFeature(feat);
                        continue;
                    }
                    config.edgeLibe.addFeature(feat);
                    continue;
                }
            }
            if (sp[0].equals(EDGE_LIBRARY)) {
                EdgeLibrary newEl = Configuration.readEdgeFile(config, sp);
                config.edgeLibe.addAll(newEl);
                if (config.collapser == null) continue;
                config.edgeLibe = config.edgeLibe.collapse(config.collapser);
                continue;
            }
            if (sp[0].equals(NODE_FILTER)) {
                f2 = config.nodeLibe.getFeature(sp[3]);
                if (f2 == null) {
                    throw new InvalidValueException(String.format("Node feature '%s' not declared (at least not before before Filter '%s')", sp[3], sp[1]));
                }
                filter = Filter.makeFilter(sp, (Feature)f2);
                if (filter == null) {
                    throw new InvalidValueException(String.format("Filter type '%s' not yet implemented", sp[1]));
                }
                config.addNodeFilter(filter);
                continue;
            }
            if (sp[0].equals(EDGE_FILTER)) {
                f2 = config.edgeLibe.getFeature(sp[3]);
                if (f2 == null) {
                    throw new InvalidValueException(String.format("Edge feature '%s' not declared (at least not before before Filter '%s')", sp[3], sp[1]));
                }
                filter = Filter.makeFilter(sp, (Feature)f2);
                config.addEdgeFilter(filter);
                continue;
            }
            if (sp[0].equals(GRAPH_FILTER)) {
                f2 = Configuration.makeGraphFilter(sp);
                config.addGraphFilter((Filter)f2);
                continue;
            }
            if (sp[0].equals(NODE_FILTER_MAN)) {
                NodeFilterManager nFilterMan = NodeFilterManager.readFilterManager(sp, config);
                config.addFilterManager(nFilterMan);
                continue;
            }
            if (sp[0].equals(EDGE_FILTER_MAN)) {
                EdgeFilterManager eFilterMan = EdgeFilterManager.readFilterManager(sp, config);
                config.addFilterManager(eFilterMan);
                continue;
            }
            if (sp[0].equals(G_FILTER_MAN)) {
                GraphNodeFilterManager gfm = GraphNodeFilterManager.readFilterManager(sp, config);
                config.addFilterManager(gfm);
                continue;
            }
            if (sp[0].equals(PATHFINDER)) {
                PathFinder pf = PathFinder.readPathFinder(sp, config);
                config.addPathFinder(pf);
                continue;
            }
            if (sp[0].equals(FILTER_GRAPH)) {
                config.setGraphFiltering(sp);
                continue;
            }
            if (sp[0].equals(GAMS_FILE)) {
                config.setGamsFile(sp[1]);
                continue;
            }
            if (sp[0].equals(GAMS_LABEL_MODE)) {
                config.setGamsLabelMode(GamsPrinter.LabelMode.valueOf(sp[1].toUpperCase()));
                continue;
            }
            if (sp[0].equals(OUTPUT)) {
                config.setOutputPrefix(sp[1]);
                continue;
            }
            if (sp[0].equals(HIDE_HIT_DIR)) {
                if (new File(sp[1]).isDirectory()) {
                    config.setHiddenHitDirectory(sp[1]);
                    continue;
                }
                throw new InvalidValueException("Can't find directory of held-aside hit files: " + sp[1]);
            }
            if (sp[0].equals(INDIRECTORY) || sp[0].equals(PAIRS)) {
                PairDirectory indie = null;
                if (sp[0].equals(INDIRECTORY)) {
                    indie = PairDirectory.readIndirectory(sp[2], sp[1]);
                } else if (sp[0].equals(PAIRS)) {
                    indie = Configuration.readPairDir(sp);
                }
                PairDirectory overwrite = config.addPairDirectory(sp[1], indie);
                if (overwrite == null) continue;
                throw new DuplicateException("Found duplicate PairDirectory name: " + sp[1]);
            }
            if (sp[0].equals(COLLAPSER)) {
                EdgeCollapser.Collapser c = EdgeCollapser.Collapser.fromName(sp[1]);
                if (c == null) {
                    throw new InvalidValueException(String.format("Requested EdgeCollapser %s doesn't exist yet.", sp[1]));
                }
                String[] args = new String[sp.length - 2];
                System.arraycopy(sp, 2, args, 0, args.length);
                config.collapser = c.make(args);
                continue;
            }
            if (sp[0].equals(SUBGRAPH)) {
                System.out.println("Constructing subgraph...");
                Subgraph sub = Configuration.makeSubgraph(sp, config);
                Enums.AddEdgeMode addMode = Enums.AddEdgeMode.ALL;
                if (sp.length > 3) {
                    try {
                        addMode = Enums.AddEdgeMode.valueOf(sp[3]);
                    }
                    catch (IllegalArgumentException iae) {
                        throw new InvalidValueException("Invalid edge-addition mode:" + sp[3]);
                    }
                }
                if (config.subgraphs.containsKey(sub.name())) {
                    throw new DuplicateException(String.format("Subgraph with name %s has already been declared.", sub.name()));
                }
                config.addSubgraph(sub.name(), sub);
                config.setSubgraphAddMode(sub.name(), addMode);
                continue;
            }
            if (sp[0].equals(GAMS_EFEATS)) {
                stringArray = feats = sp[1].split(VAL_DELIM);
                n2 = feats.length;
                n = 0;
                while (n < n2) {
                    f = stringArray[n];
                    if (!config.edgeLibe.featureNames().contains(f)) {
                        throw new InvalidValueException("Requested invalid edge feature for GAMS output:" + f);
                    }
                    ++n;
                }
                config.setGamsEdgeFeatureNames(feats);
                continue;
            }
            if (sp[0].equals(GAMS_NFEATS)) {
                stringArray = feats = sp[1].split(VAL_DELIM);
                n2 = feats.length;
                n = 0;
                while (n < n2) {
                    f = stringArray[n];
                    if (!config.nodeLibe.featureNames().contains(f)) {
                        throw new InvalidValueException("Requested invalid node feature for GAMS output:" + f);
                    }
                    ++n;
                }
                config.setGamsNodeFeatureNames(feats);
                continue;
            }
            System.err.println("Config line type not implemented:" + sp[0]);
        }
        return config;
    }

    protected static Filter makeGraphFilter(String[] line) throws InvalidValueException, IncomparableException {
        assert (line[0].equals(GRAPH_FILTER)) : "You shouldn't call makeGraphFilter on a non-graphfilter.\n" + Arrays.toString(line);
        GraphUtils.GraphFeature graphFeat = null;
        try {
            graphFeat = GraphUtils.GraphFeature.valueOf(line[3].toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new InvalidValueException(String.format("Graph feature %s not implemented.", line[3]));
        }
        Feature f = graphFeat.feature();
        Filter filter = Filter.makeFilter(line, f);
        return filter;
    }

    protected static Subgraph makeSubgraph(String[] line, Configuration config) throws InvalidValueException {
        String[] mans;
        String name = line[1];
        HashSet<Edge> edges = new HashSet<Edge>();
        HashSet<String> nodes = new HashSet<String>();
        String[] stringArray = mans = line[2].split(VAL_DELIM);
        int n = mans.length;
        int n2 = 0;
        while (n2 < n) {
            List accepted;
            String man = stringArray[n2];
            String[] msp = man.split("=");
            if (msp[0].equalsIgnoreCase("edges")) {
                EdgeFilterManager efm = config.getEdgeFilterManager(msp[1]);
                if (efm == null) {
                    throw new InvalidValueException(String.format("Subgraph %s declaration: Unable to find EdgeFilterManager %s.", name, msp[1]));
                }
                accepted = efm.apply(((EdgeLibrary)efm.library()).items());
                edges.addAll(accepted);
            } else if (msp[0].equalsIgnoreCase("nodes")) {
                NodeFilterManager nfm = config.getNodeFilterManager(msp[1]);
                if (nfm == null) {
                    throw new InvalidValueException(String.format("Subgraph %s declaration: Unable to find NodeFilterManager %s.", name, msp[1]));
                }
                accepted = nfm.apply(((NodeLibrary)nfm.library()).items());
                nodes.addAll(accepted);
            }
            ++n2;
        }
        Subgraph sub = new Subgraph(name, nodes, edges);
        return sub;
    }

    protected void setGraphFiltering(String[] sp) throws InvalidValueException {
        String[] manNames;
        String[] stringArray = manNames = sp[1].split(VAL_DELIM);
        int n = manNames.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            if (this.nodeFilterMans.containsKey(name)) {
                this.applyToGraph.add(this.nodeFilterMans.get(name));
            } else if (this.graphFilterMans.containsKey(name)) {
                this.applyToGraph.add(this.graphFilterMans.get(name));
            } else if (this.edgeFilterMans.containsKey(name)) {
                this.applyToGraph.add(this.edgeFilterMans.get(name));
            } else {
                throw new InvalidValueException("Couldn't find requested FilterManager " + name);
            }
            ++n2;
        }
    }

    protected void addFilterManager(FilterManager man) {
        if (man instanceof NodeFilterManager) {
            this.nodeFilterMans.put(man.name(), (NodeFilterManager)man);
        } else if (man instanceof GraphNodeFilterManager) {
            this.graphFilterMans.put(man.name(), (GraphNodeFilterManager)man);
        } else if (man instanceof EdgeFilterManager) {
            this.edgeFilterMans.put(man.name(), (EdgeFilterManager)man);
        } else assert (false) : "Tried to add illegal filter manager to config";
    }

    protected void addNodeFilter(Filter filt) {
        this.nodeFilters.put(filt.name(), filt);
    }

    protected void addEdgeFilter(Filter filt) {
        this.edgeFilters.put(filt.name(), filt);
    }

    protected void addGraphFilter(Filter filt) {
        this.graphFilters.put(filt.name(), filt);
    }

    protected void addPathFinder(PathFinder pf) {
        this.pathFinders.add(pf);
    }

    protected PairDirectory addPairDirectory(String name, PairDirectory dir) {
        return this.pairDirs.put(name, dir);
    }

    protected ScoredPairDirectory addScoredPairDirectory(String name, ScoredPairDirectory pdir) {
        return this.scoredPairs.put(name, pdir);
    }

    protected Subgraph addSubgraph(String name, Subgraph subgraph) {
        return this.subgraphs.put(name, subgraph);
    }

    protected Enums.AddEdgeMode setSubgraphAddMode(String name, Enums.AddEdgeMode val) {
        return this.subgraphAddMode.put(name, val);
    }

    protected static PairDirectory readPairDir(String[] sp) throws InvalidValueException, IOException, DuplicateException {
        String name = sp[1];
        String filename = sp[2];
        String format = "%s";
        String posText = null;
        String negText = null;
        boolean readSigns = false;
        if (sp.length == 2) {
            return PairDirectory.readOrderedPairs(filename, name);
        }
        if (sp.length > 3) {
            String[] args;
            String[] stringArray = args = sp[3].split(",");
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                String[] again = s.split("=");
                if (again.length != 2) {
                    throw new InvalidValueException(String.format("Invalid argument to PairDirectory %s: %s", name, s));
                }
                if (again[0].equalsIgnoreCase("positive")) {
                    posText = again[1];
                    readSigns = true;
                } else if (again[0].equalsIgnoreCase("negative")) {
                    negText = again[1];
                    readSigns = true;
                } else if (again[0].equalsIgnoreCase("format")) {
                    format = again[1];
                }
                ++n2;
            }
        }
        return PairDirectory.readOrderedPairs(filename, name, format, readSigns, posText, negText);
    }

    protected ScoredPairDirectory readScoredPairLine(String[] sp) {
        throw new RuntimeException("NOT IMPLEMENTED YET");
    }

    public static EdgeLibrary readEdgeFile(Configuration config, String[] line) throws InvalidValueException, IOException, DuplicateException {
        String filename = line[1];
        HashMap<Feature, Value> autoFeats = null;
        boolean hasAuto = line[2].contains("=");
        if (config != null && hasAuto) {
            String[] afStrs;
            autoFeats = new HashMap<Feature, Value>();
            String[] stringArray = afStrs = line[2].split(VAL_DELIM);
            int n = afStrs.length;
            int n2 = 0;
            while (n2 < n) {
                String af = stringArray[n2];
                String[] autoSplit = af.split("=");
                Feature autoFeat = config.edgeLibe.getFeature(autoSplit[0]);
                if (autoFeat == null) {
                    throw new InvalidValueException(String.format("You must declare the auto feature %s before reading the edge library.", autoSplit[0]));
                }
                Value autoValue = autoFeat.legal(autoSplit[1]);
                if (autoValue == null) {
                    throw new InvalidValueException(String.format("Illegal value %s requested for auto feature %s.", autoSplit[1], autoSplit[0]));
                }
                if (autoFeats.containsKey(autoFeat) && !autoFeats.get(autoFeat).equals(autoValue)) {
                    throw new InvalidValueException(String.format("File %s: Tried to assign more than one auto value for auto feature %s.", filename, autoSplit[0]));
                }
                autoFeats.put(autoFeat, autoValue);
                ++n2;
            }
        } else if (config == null && hasAuto) {
            throw new InvalidValueException(String.format("Invalid edge library request: %s", Arrays.toString(line)));
        }
        int start = -1;
        try {
            start = Integer.parseInt(line[3]);
        }
        catch (NumberFormatException nfe) {
            throw new InvalidValueException(String.format("Invalid start column ID for file '%s': '%s'", filename, line[3]));
        }
        HashSet<Integer> readCols = null;
        if (line.length > 4) {
            String[] colS;
            readCols = new HashSet<Integer>();
            String[] stringArray = colS = line[4].split(VAL_DELIM);
            int autoSplit = colS.length;
            int n = 0;
            while (n < autoSplit) {
                String s = stringArray[n];
                try {
                    int c = Integer.parseInt(s);
                    readCols.add(c);
                }
                catch (NumberFormatException nfe) {
                    throw new InvalidValueException(String.format("Invalid column ID for feature-reading from file '%s'", filename, s));
                }
                ++n;
            }
        }
        String srcFormat = null;
        String tarFormat = null;
        if (line.length > 5) {
            String[] sp;
            String[] stringArray = sp = line[5].split(",");
            int n = sp.length;
            int n3 = 0;
            while (n3 < n) {
                String s = stringArray[n3];
                String[] again = s.split("=");
                if (again.length != 2) {
                    throw new InvalidValueException(String.format("Invalid format argument to edge library %s: %s", filename, s));
                }
                if (again[0].equalsIgnoreCase("source")) {
                    srcFormat = again[1];
                } else if (again[0].equalsIgnoreCase("target")) {
                    tarFormat = again[1];
                }
                ++n3;
            }
        }
        EdgeLibrary el = EdgeLibrary.readEdges(filename, start, autoFeats, readCols, srcFormat, tarFormat);
        return el;
    }

    public static Pair<Feature, Map<String, Value>> readNodeFeature(String[] line) throws InvalidValueException, IOException {
        assert (line[0].equals(NODE_FEATURE)) : "Should be node feature?" + line[0];
        if (line.length < 6) {
            throw new InvalidValueException(String.format("Not enough fields in declaration of node feature '%s'.", Arrays.toString(line)));
        }
        String declaration = line[1];
        String note = line[2];
        String filename = line[3];
        Feature f = Feature.readFeatureDeclaration(declaration, note, filename);
        GraphUtils.GraphFeature gf = null;
        try {
            gf = GraphUtils.GraphFeature.valueOf(f.name());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (gf != null) {
            throw new InvalidValueException(String.format("Declared node feature name '%s' is reserved for graphs.", f.name()));
        }
        String delim = line[4];
        Value defVal = null;
        int col = -1;
        String colStr = line[5];
        if (colStr.contains("=")) {
            String[] sp = colStr.split("=");
            colStr = sp[0];
            defVal = f.legal(sp[1]);
        }
        try {
            col = Integer.parseInt(colStr);
        }
        catch (NumberFormatException e) {
            throw new InvalidValueException(String.format("Bad column ID for feature '%s': %s", f.name(), line[5]));
        }
        HashMap<String, Value> values = null;
        values = defVal == null ? Feature.readNodeFeature(f, filename, delim, col) : Feature.readNodeFeatureDefaultValue(f, defVal, filename, delim, col);
        return new Pair<Feature, Map<String, Value>>(f, values);
    }

    public Graph runNodeFilters(FilterManager.FilterItemMode mode) throws DuplicateException {
        Graph g = Graph.createFromEdgeLibrary(this.edgeLibrary());
        switch (mode) {
            case AND: {
                g = GraphUtils.filterAnd(g, this.nodeFilters.values(), this.nodeLibe);
                break;
            }
            case OR: {
                g = GraphUtils.filterOr(g, this.nodeFilters.values(), this.nodeLibe);
            }
        }
        return g;
    }
}

