/*
 * Decompiled with CFR 0.152.
 */
package structures;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import java.util.TreeSet;
import structures.Discrete;
import structures.Value;
import utilities.StringUtils;

public class CatSet
extends Value {
    private TreeSet<Discrete> vals = new TreeSet();
    private static HashMap<String, CatSet> created = new HashMap();

    private CatSet(Collection<Discrete> vals) {
        for (Discrete v : vals) {
            this.vals.add(v);
        }
    }

    public Set<Discrete> getValue() {
        return Collections.unmodifiableSet(this.vals);
    }

    @Override
    public Value.Type getType() {
        return Value.Type.SET;
    }

    public static CatSet makeValue(Collection<Discrete> vals) {
        CatSet cat = new CatSet(vals);
        String catstr = cat.toString();
        if (!created.containsKey(catstr)) {
            created.put(catstr, cat);
        }
        return created.get(catstr);
    }

    public Set<Discrete> intersection(CatSet other) {
        TreeSet<Discrete> shared = new TreeSet<Discrete>(this.getValue());
        shared.retainAll(other.getValue());
        return shared;
    }

    public String toString() {
        return StringUtils.join(this.vals, "|");
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object other) {
        if (!(other instanceof CatSet)) {
            return false;
        }
        return this.toString().equals(other.toString());
    }

    @Override
    public int compareTo(CatSet o) {
        return this.toString().compareTo(o.toString());
    }

    @Override
    public int compareTo(Value o) {
        return this.toString().compareTo(o.toString());
    }
}

