/*
 * Decompiled with CFR 0.152.
 */
package structures;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import structures.Edge;
import structures.Path;
import utilities.StringUtils;

public class BranchyPath
extends Path {
    protected final HashSet<String> termini = new HashSet();
    protected final HashSet<Edge> terminalEdges = new HashSet();

    protected BranchyPath() {
    }

    public BranchyPath(Path body, Set<String> termini, Set<Edge> termEdges) {
        this();
        this.nodes.addAll(body.nodes);
        this.edges.addAll(body.edges);
        this.termini.addAll(termini);
        this.terminalEdges.addAll(termEdges);
        this.toString = this.buildString();
    }

    @Override
    public String getNode(int i) {
        int index = i;
        if (i < 0) {
            index = this.nodes.size() + i + 1;
        }
        if (i == this.nodes.size() - 1) {
            throw new RuntimeException("Tried to access last item of a BranchyPath; not unique.");
        }
        return (String)this.nodes.get(index);
    }

    @Override
    public Edge getEdge(int i) {
        int index = i;
        if (i < 0) {
            index = this.edges.size() + i;
        }
        if (i == this.edges.size() - 1) {
            throw new RuntimeException("Tried to access last edge of a BranchyPath; not unique.");
        }
        return (Edge)this.edges.get(index);
    }

    @Override
    public int edgeLength() {
        int len = this.edges.size() + (this.terminalEdges.size() > 0 ? 1 : 0);
        return len;
    }

    @Override
    public List<String> nodes() {
        ArrayList<String> allNodes = new ArrayList<String>(this.nodes);
        allNodes.addAll(this.termini);
        return allNodes;
    }

    @Override
    public List<Edge> edges() {
        ArrayList<Edge> allEdges = new ArrayList<Edge>(this.edges);
        allEdges.addAll(this.terminalEdges);
        return allEdges;
    }

    public Set<Edge> terminalEdges() {
        return Collections.unmodifiableSet(this.terminalEdges);
    }

    @Override
    public Set<String> termini() {
        return Collections.unmodifiableSet(this.termini);
    }

    @Override
    public Path copy() {
        BranchyPath copy = new BranchyPath(this.bodyPath(), new HashSet<String>(this.termini), new HashSet<Edge>(this.terminalEdges));
        return copy;
    }

    public Path bodyPath() {
        return new Path(this.nodes, this.edges);
    }

    @Override
    protected String buildString() {
        assert (this.nodes.size() >= this.edges.size()) : "Missed node while adding edge?";
        if (this.nodes.size() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(this.getNode(0));
        int i = 1;
        while (i < this.nodes.size()) {
            String nextN = (String)this.nodes.get(i);
            Edge e = (Edge)this.edges.get(i - 1);
            if (!e.directed) {
                switch (e.sign) {
                    case UNKNOWN: {
                        sb.append(" -- ");
                        break;
                    }
                    case POSITIVE: {
                        sb.append(" <--> ");
                        break;
                    }
                    case NEGATIVE: {
                        sb.append(" |--| ");
                    }
                }
            } else if (e.directed) {
                switch (e.sign) {
                    case UNKNOWN: {
                        sb.append(" --+ ");
                        break;
                    }
                    case POSITIVE: {
                        sb.append(" --> ");
                        break;
                    }
                    case NEGATIVE: {
                        sb.append(" --| ");
                    }
                }
            }
            sb.append(nextN);
            ++i;
        }
        sb.append(String.format(" --+ [%d termini (%s)]", this.termini.size(), StringUtils.join(this.termini, "|")));
        return sb.toString();
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof Path)) {
            return false;
        }
        return this.toString().equals(other.toString());
    }

    @Override
    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public Path.PathOrder order(String a, String b) {
        boolean bTerm;
        int ai = this.nodes.indexOf(a);
        int bi = this.nodes.indexOf(b);
        boolean aTerm = ai < 0 && this.termini.contains(a);
        boolean bl = bTerm = bi < 0 && this.termini.contains(b);
        if (ai < 0 && !aTerm || bi < 0 && !bTerm || aTerm && bTerm) {
            return Path.PathOrder.NA;
        }
        assert (ai != bi) : "Called Path.order on the same node.";
        if (ai < bi) {
            return Path.PathOrder.ABOVE;
        }
        if (bi < ai) {
            return Path.PathOrder.BELOW;
        }
        return Path.PathOrder.NA;
    }
}

