/*
 * Decompiled with CFR 0.152.
 */
package pathfinders;

import exceptions.InvalidValueException;
import filters.EdgeFilterManager;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import pathfinders.PairPathFinder;
import pathfinders.PathFinder;
import structures.Configuration;
import structures.Graph;
import structures.PairDirectory;
import structures.Path;
import structures.PathManager;
import utilities.DebugTools;

public class SourceRegTargetPathFinder
extends PairPathFinder {
    protected PairDirectory penultimateFilter;
    protected HashMap<EdgeFilterManager, Integer> typeLimiter;

    public SourceRegTargetPathFinder(String name, PairDirectory stPairs, PairDirectory candRegs, int depth) {
        super(name, stPairs, depth);
        this.collapseMode = PathFinder.CollapseMode.ALL_BUT_LAST;
        this.penultimateFilter = candRegs;
    }

    @Override
    public PathManager findPathsIterative(Graph g, int addDepth, double stop) {
        PathManager found = new PathManager();
        if (this.depth == 0) {
            return found;
        }
        Set<String> startNodes = this.stPairs.getFirsts();
        for (String node : startNodes) {
            Set<String> targets = this.stPairs.getSeconds(node);
            HashSet<String> totT = new HashSet<String>(g.nodes());
            totT.retainAll(targets);
            System.out.format("%s has %d targets in graph \n", node, totT.size());
            Set<String> cands = this.penultimateFilter.getSeconds(node);
            HashSet<String> totR = new HashSet<String>();
            for (String c : cands) {
                int deg = g.degree(node, Graph.RType.INCOMING) + g.degree(node, Graph.RType.UNDIRECTED);
                if (deg <= 0) continue;
                totR.add(c);
            }
            System.out.format("%s has %d candidate TFs/RBPs in graph \n", node, totR.size());
            if (!g.contains(node)) {
                if (!DebugTools.DEBUG) continue;
                System.out.println("Node not in graph: " + node);
                continue;
            }
            double cov = 0.0;
            int atDepth = this.depth;
            PathManager npaths = null;
            while (cov < stop && atDepth < this.depth + addDepth) {
                npaths = this.findPaths(g, node, atDepth);
                if (DebugTools.DEBUG && npaths.size() > 0) {
                    System.out.println(String.format("Found %d paths for starting node %s at depth %d.", npaths.size(), node, atDepth));
                }
                int tfound = 0;
                for (String t : targets) {
                    if (!npaths.contains(t)) continue;
                    ++tfound;
                }
                HashSet<String> used = new HashSet<String>();
                for (Path p : npaths.allPaths()) {
                    used.add(p.getNode(-2));
                }
                cov = (double)used.size() / (double)totR.size();
                double tcov = (double)tfound / (double)targets.size();
                ++atDepth;
                System.out.format("\tCovered %f (%d) of %d candidate TFs/RBPs; %f (%d) targets.\n", cov, used.size(), totR.size(), tcov, tfound, targets.size());
            }
            if (npaths == null) continue;
            found.addAll(npaths);
        }
        return found;
    }

    @Override
    protected PathFinder.PathStatus verify(Path p, int depth) {
        PathFinder.PathStatus pairVerify = super.verify(p, depth);
        if (pairVerify == PathFinder.PathStatus.SAVE_AND_STOP) {
            String penultimate;
            boolean isRegPair;
            String first = p.getNode(0);
            boolean bl = isRegPair = this.penultimateFilter.getOrder(first, penultimate = p.getNode(-2)) == PairDirectory.PartialOrder.ABOVE || first.equals(penultimate) && this.penultimateFilter.hasSelfPair(first);
            if (isRegPair) {
                return PathFinder.PathStatus.SAVE_AND_STOP;
            }
            return PathFinder.PathStatus.STOP;
        }
        if (depth == 0) {
            return PathFinder.PathStatus.STOP;
        }
        return PathFinder.PathStatus.CONTINUE;
    }

    public static PairPathFinder readPathFinder(String[] line, Configuration config) throws InvalidValueException {
        PairDirectory regs;
        String err = "";
        if (line.length < 6 || !line[2].equals("SourceRegTargetPathFinder")) {
            throw new InvalidValueException("Does not declare a SourceRegTargetPathFinder: " + Arrays.toString(line));
        }
        String name = line[1];
        int depth = 0;
        PairDirectory pairs = config.getPairDirectory(line[3]);
        if (pairs == null) {
            err = "Invalid source-target PairDirectory: " + line[3];
        }
        if ((regs = config.getPairDirectory(line[4])) == null) {
            err = "Invalid source-regulator PairDirectory: " + line[4];
        }
        try {
            depth = Integer.parseInt(line[5]);
        }
        catch (NumberFormatException nfe) {
            err = "Invalid depth:" + line[5];
        }
        if (err.length() > 0) {
            throw new InvalidValueException(err);
        }
        return new SourceRegTargetPathFinder(name, pairs, regs, depth);
    }
}

