/*
 * Decompiled with CFR 0.152.
 */
package pathfinders;

import exceptions.InvalidValueException;
import filters.EdgeFilterManager;
import java.util.Arrays;
import pathfinders.PairPathFinder;
import pathfinders.PathFinder;
import structures.Configuration;
import structures.Edge;
import structures.PairDirectory;
import structures.Path;

public class RegPairPathFinder
extends PairPathFinder {
    protected EdgeFilterManager finalEdgeFilter;

    public RegPairPathFinder(String name, PairDirectory index, EdgeFilterManager finalEdgeManager, int depth) {
        super(name, index, depth);
        this.finalEdgeFilter = finalEdgeManager;
    }

    @Override
    protected PathFinder.PathStatus verify(Path p, int depth) {
        PathFinder.PathStatus superStatus = super.verify(p, depth);
        assert (superStatus != PathFinder.PathStatus.SAVE_AND_CONTINUE) : "PathStatus.Save_and_continue not implemented";
        if (superStatus == PathFinder.PathStatus.SAVE_AND_STOP) {
            Edge finalE = p.getEdge(-1);
            if (this.finalEdgeFilter.accept(finalE)) {
                return PathFinder.PathStatus.SAVE_AND_STOP;
            }
            return PathFinder.PathStatus.CONTINUE;
        }
        return superStatus;
    }

    public static PairPathFinder readPathFinder(String[] line, Configuration config) throws InvalidValueException {
        EdgeFilterManager finalEdgeMan;
        String err = "";
        if (line.length < 5 || !line[2].equals("RegPairPathFinder")) {
            throw new InvalidValueException("Does not declare a RegPairPathFinder: " + Arrays.toString(line));
        }
        String name = line[1];
        int depth = 0;
        PairDirectory pairs = config.getPairDirectory(line[3]);
        if (pairs == null) {
            err = "Invalid PairDirectory: " + line[3];
        }
        if ((finalEdgeMan = config.getEdgeFilterManager(line[4])) == null) {
            err = String.format("%sInvalid PairDirectory: %s", err, line[4]);
        }
        try {
            depth = Integer.parseInt(line[5]);
        }
        catch (NumberFormatException nfe) {
            err = "Invalid depth:" + line[5];
        }
        if (err.length() > 0) {
            throw new InvalidValueException(err);
        }
        return new RegPairPathFinder(name, pairs, finalEdgeMan, depth);
    }

    @Override
    public String toString() {
        return String.format("RegPairPathFinder %s pairs=%s, final_edge_manager=%s, depth=%d", this.name, this.stPairs.filename(), this.finalEdgeFilter.name(), this.depth);
    }
}

