/*
 * Decompiled with CFR 0.152.
 */
package pathfinders;

import exceptions.InvalidValueException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import pathfinders.BasicFilteredPathFinder;
import pathfinders.BasicFreeEdgePathFinder;
import pathfinders.BasicPathFinder;
import pathfinders.EndlessPathFinder;
import pathfinders.PairPathFinder;
import pathfinders.RegPairPathFinder;
import pathfinders.SourceRegTargetPathFinder;
import structures.BranchyPath;
import structures.Configuration;
import structures.Edge;
import structures.Graph;
import structures.Path;
import structures.PathManager;

public abstract class PathFinder {
    protected String name;
    protected CollapseMode collapseMode = CollapseMode.NO;

    public String name() {
        return this.name;
    }

    public abstract PathManager findPaths(Graph var1);

    public PathManager findPaths(Graph g, String start, int depth) {
        if (!g.contains(start)) {
            return null;
        }
        PathManager pm = new PathManager();
        Path init = new Path(start);
        PathStatus verify = this.verify(init, depth);
        boolean validStatus = false;
        if (verify == PathStatus.SAVE_AND_STOP || verify == PathStatus.SAVE_AND_CONTINUE) {
            validStatus = true;
            pm.add(init, this.name());
        }
        if (verify == PathStatus.CONTINUE || verify == PathStatus.SAVE_AND_CONTINUE || verify == PathStatus.CONTINUE_FOR_FREE) {
            validStatus = true;
            pm = this.search(g, init, depth);
        }
        assert (validStatus) : "Shouldn't have received status for starting node: " + verify.toString();
        return pm;
    }

    public abstract PathManager findPathsIterative(Graph var1, int var2, double var3);

    protected abstract PathStatus verify(Path var1, int var2);

    public PathManager search(Graph g, Path currPath, int depth) {
        PathManager found = new PathManager();
        if (depth == 0) {
            return found;
        }
        String last = currPath.getNode(-1);
        HashSet<Edge> further = new HashSet<Edge>(g.incident(last, Graph.RType.OUTGOING));
        further.addAll(g.incident(last, Graph.RType.UNDIRECTED));
        ArrayList<Edge> potentialBranches = new ArrayList<Edge>();
        for (Edge e : further) {
            PathManager deeper;
            Path next = currPath.copyAdd(e);
            if (next == null) continue;
            PathStatus verify = this.verify(next, depth);
            if (verify == PathStatus.SAVE_AND_STOP || verify == PathStatus.SAVE_AND_CONTINUE) {
                if (this.collapseMode == CollapseMode.ALL_BUT_LAST) {
                    potentialBranches.add(e);
                } else {
                    found.add(next, this.name());
                }
            }
            if (verify == PathStatus.SAVE_AND_STOP || verify == PathStatus.STOP) continue;
            if (verify == PathStatus.SAVE_AND_CONTINUE || verify == PathStatus.CONTINUE) {
                deeper = this.search(g, next, depth - 1);
                found.addAll(deeper);
                continue;
            }
            if (verify != PathStatus.CONTINUE_FOR_FREE) continue;
            deeper = this.search(g, next, depth);
            found.addAll(deeper);
        }
        if (this.collapseMode == CollapseMode.ALL_BUT_LAST && potentialBranches.size() > 0) {
            Path next;
            if (potentialBranches.size() == 1) {
                next = currPath.copyAdd((Edge)potentialBranches.get(0));
            } else {
                HashSet<String> termini = new HashSet<String>();
                HashSet<Edge> termEdges = new HashSet<Edge>(potentialBranches);
                for (Edge e : potentialBranches) {
                    for (String n : e.nodes()) {
                        if (n.equals(last)) continue;
                        termini.add(n);
                    }
                }
                next = new BranchyPath(currPath, termini, termEdges);
            }
            found.add(next, this.name());
        }
        return found;
    }

    public static PathFinder readPathFinder(String[] line, Configuration config) throws InvalidValueException {
        if (line.length < 2) {
            throw new InvalidValueException("Invalid pathfinder declaration: " + Arrays.toString(line));
        }
        Implemented imp = null;
        try {
            imp = Implemented.valueOf(line[2].toUpperCase());
        }
        catch (IllegalArgumentException iae) {
            throw new InvalidValueException("Unimplemented pathfinder type: " + Arrays.toString(line));
        }
        PathFinder pf = null;
        switch (imp) {
            case BASICPATHFINDER: {
                pf = BasicPathFinder.readPathFinder(line, config);
                break;
            }
            case BASICFILTEREDPATHFINDER: {
                pf = BasicFilteredPathFinder.readPathFinder(line, config);
                break;
            }
            case BASICFREEEDGEPATHFINDER: {
                pf = BasicFreeEdgePathFinder.readPathFinder(line, config);
                break;
            }
            case ENDLESSPATHFINDER: {
                pf = EndlessPathFinder.readPathFinder(line, config);
                break;
            }
            case PAIRPATHFINDER: {
                pf = PairPathFinder.readPathFinder(line, config);
                break;
            }
            case REGPAIRPATHFINDER: {
                pf = RegPairPathFinder.readPathFinder(line, config);
                break;
            }
            case SOURCEREGTARGETPATHFINDER: {
                pf = SourceRegTargetPathFinder.readPathFinder(line, config);
            }
        }
        return pf;
    }

    public static enum CollapseMode {
        NO,
        ALL_BUT_LAST;

    }

    public static enum Implemented {
        BASICPATHFINDER,
        BASICFILTEREDPATHFINDER,
        BASICFREEEDGEPATHFINDER,
        ENDLESSPATHFINDER,
        PAIRPATHFINDER,
        SOURCEREGTARGETPATHFINDER,
        REGPAIRPATHFINDER;

    }

    public static enum PathStatus {
        SAVE_AND_CONTINUE,
        SAVE_AND_STOP,
        STOP,
        CONTINUE,
        CONTINUE_FOR_FREE;

    }
}

