/*
 * Decompiled with CFR 0.152.
 */
package pathfinders;

import exceptions.InvalidValueException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import pathfinders.PathFinder;
import structures.Configuration;
import structures.Graph;
import structures.PairDirectory;
import structures.Path;
import structures.PathManager;
import utilities.DebugTools;

public class PairPathFinder
extends PathFinder {
    protected PairDirectory stPairs;
    protected int depth;

    public PairPathFinder(String name, PairDirectory index, int depth) {
        this.name = name;
        this.stPairs = index;
        this.depth = depth;
    }

    @Override
    public PathManager findPaths(Graph g) {
        PathManager found = new PathManager();
        if (this.depth == 0) {
            return found;
        }
        Set<String> startNodes = this.stPairs.getFirsts();
        for (String node : startNodes) {
            if (!g.contains(node)) {
                if (!DebugTools.DEBUG) continue;
                System.out.println("Node not in graph: " + node);
                continue;
            }
            PathManager npaths = this.findPaths(g, node, this.depth);
            if (DebugTools.DEBUG && npaths.size() > 0) {
                System.out.println(String.format("Found %d paths for starting node %s.", npaths.size(), node));
            }
            if (npaths == null) continue;
            found.addAll(npaths);
        }
        return found;
    }

    @Override
    public PathManager findPathsIterative(Graph g, int addDepth, double stop) {
        PathManager found = new PathManager();
        if (this.depth == 0) {
            return found;
        }
        Set<String> startNodes = this.stPairs.getFirsts();
        for (String node : startNodes) {
            Set<String> targets = this.stPairs.getSeconds(node);
            HashSet<String> tot = new HashSet<String>(g.nodes());
            tot.retainAll(targets);
            if (DebugTools.DEBUG) {
                System.out.format("%s has %d targets in graph \n", node, tot.size());
            }
            if (!g.contains(node)) {
                if (!DebugTools.DEBUG) continue;
                System.out.println("Node not in graph: " + node);
                continue;
            }
            double cov = 0.0;
            int atDepth = this.depth;
            PathManager npaths = null;
            while (cov < stop && atDepth < this.depth + addDepth) {
                npaths = this.findPaths(g, node, atDepth);
                if (DebugTools.DEBUG && npaths.size() > 0) {
                    System.out.println(String.format("Found %d paths for starting node %s at depth %d.", npaths.size(), node, atDepth));
                }
                int tfound = 0;
                for (String t : targets) {
                    if (!npaths.contains(t)) continue;
                    ++tfound;
                }
                cov = (double)tfound / (double)targets.size();
                ++atDepth;
                if (!DebugTools.DEBUG) continue;
                System.out.format("\tCovered %f (%d) of %d targets.\n", cov, tfound, targets.size());
                for (Path p : npaths.allPaths()) {
                    System.out.println(p.toString());
                }
            }
            if (npaths == null) continue;
            found.addAll(npaths);
        }
        return found;
    }

    @Override
    protected PathFinder.PathStatus verify(Path p, int depth) {
        String last;
        boolean isEndpoint;
        String first = p.getNode(0);
        boolean bl = isEndpoint = this.stPairs.getOrder(first, last = p.getNode(-1)) == PairDirectory.PartialOrder.ABOVE;
        if (isEndpoint) {
            return PathFinder.PathStatus.SAVE_AND_STOP;
        }
        if (depth == 0) {
            return PathFinder.PathStatus.STOP;
        }
        return PathFinder.PathStatus.CONTINUE;
    }

    public static PairPathFinder readPathFinder(String[] line, Configuration config) throws InvalidValueException {
        String err = "";
        if (line.length < 5 || !line[2].equals("PairPathFinder")) {
            throw new InvalidValueException("Does not declare a PairPathFinder: " + Arrays.toString(line));
        }
        String name = line[1];
        int depth = 0;
        PairDirectory pairs = config.getPairDirectory(line[3]);
        if (pairs == null) {
            err = "Invalid PairDirectory: " + line[3];
        }
        try {
            depth = Integer.parseInt(line[4]);
        }
        catch (NumberFormatException nfe) {
            err = "Invalid depth:" + line[4];
        }
        if (err.length() > 0) {
            throw new InvalidValueException(err);
        }
        return new PairPathFinder(name, pairs, depth);
    }

    public String toString() {
        return String.format("PairPathFinder %s pairs=%s, depth=%d", this.name, this.stPairs.filename(), this.depth);
    }

    public static /* bridge */ /* synthetic */ PathFinder readPathFinder(String[] stringArray, Configuration configuration) throws InvalidValueException {
        return PairPathFinder.readPathFinder(stringArray, configuration);
    }
}

