/*
 * Decompiled with CFR 0.152.
 */
package pathfinders;

import exceptions.InvalidValueException;
import filters.NodeFilterManager;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import pathfinders.PathFinder;
import structures.Configuration;
import structures.Edge;
import structures.Graph;
import structures.PairDirectory;
import structures.Path;
import structures.PathManager;
import utilities.DebugTools;

public class EndlessPathFinder
extends PathFinder {
    protected NodeFilterManager start;
    protected final int depth;
    protected PairDirectory indie;

    public EndlessPathFinder(String name, NodeFilterManager start, int depth) {
        this.name = name;
        this.start = start;
        this.depth = depth;
    }

    public EndlessPathFinder(String name, NodeFilterManager start, int depth, PairDirectory indie) {
        this(name, start, depth);
        this.indie = indie;
    }

    @Override
    public PathManager findPaths(Graph g) {
        PathManager found = new PathManager();
        if (this.depth == 0) {
            return found;
        }
        List<String> startNodes = this.start.apply(g.nodes());
        for (String node : startNodes) {
            if (!g.contains(node)) {
                if (!DebugTools.DEBUG) continue;
                System.out.println("Node not in graph: " + node);
                continue;
            }
            PathManager npaths = this.findPaths(g, node, this.depth);
            if (DebugTools.DEBUG && npaths.size() > 0) {
                System.out.println(String.format("Found %d paths for starting node %s.", npaths.size(), node));
            }
            if (npaths == null) continue;
            found.addAll(npaths);
        }
        return found;
    }

    @Override
    public PathManager findPaths(Graph g, String start, int depth) {
        if (!g.contains(start)) {
            return null;
        }
        PathManager pm = new PathManager();
        Path init = new Path(start);
        PathFinder.PathStatus verify = this.verify(init, depth);
        if (verify == PathFinder.PathStatus.SAVE_AND_STOP) {
            pm.add(init, this.name());
        } else if (verify == PathFinder.PathStatus.CONTINUE) {
            pm = this.search(g, new Path(start), depth);
        } else assert (false) : "Shouldn't receive any other path status.";
        return pm;
    }

    @Override
    public PathManager findPathsIterative(Graph g, int addDepth, double stop) {
        assert (false) : "Iterative-deepening search option not implemented for EndlessPathFinder.";
        return null;
    }

    @Override
    public PathManager search(Graph g, Path currPath, int depth) {
        PathManager found = new PathManager();
        if (depth == 0) {
            found.add(currPath, this.name());
            return found;
        }
        String last = currPath.getNode(-1);
        HashSet<Edge> further = new HashSet<Edge>(g.incident(last, Graph.RType.OUTGOING));
        further.addAll(g.incident(last, Graph.RType.UNDIRECTED));
        if (further.size() == 0) {
            found.add(currPath, this.name());
        }
        for (Edge e : further) {
            Path next = currPath.copyAdd(e);
            if (next == null) continue;
            PathFinder.PathStatus verify = this.verify(next, depth);
            assert (verify != PathFinder.PathStatus.SAVE_AND_CONTINUE) : "Not implemented.";
            if (verify == PathFinder.PathStatus.SAVE_AND_STOP) {
                found.add(next, this.name());
                continue;
            }
            if (verify == PathFinder.PathStatus.CONTINUE) {
                PathManager deeper = this.search(g, next, depth - 1);
                found.addAll(deeper);
                continue;
            }
            if (verify != PathFinder.PathStatus.STOP) continue;
        }
        return found;
    }

    @Override
    protected PathFinder.PathStatus verify(Path p, int depth) {
        boolean dirOkay;
        boolean bl = dirOkay = this.indie == null ? true : this.testIndirectoryOrder(p);
        if (!dirOkay) {
            return PathFinder.PathStatus.STOP;
        }
        if (depth == 0) {
            return PathFinder.PathStatus.SAVE_AND_STOP;
        }
        return PathFinder.PathStatus.CONTINUE;
    }

    protected boolean testIndirectoryOrder(Path p) {
        String last = p.getNode(-1);
        int i = 0;
        while (i < p.edgeLength()) {
            String q = p.getNode(i);
            PairDirectory.PartialOrder required = this.indie.getOrder(q, last);
            if (required == PairDirectory.PartialOrder.BELOW) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String toString() {
        String indir = this.indie == null ? "" : ", Indirectory " + this.indie.filename();
        return String.format("EndlessPathFinder %s start=%s, depth=%d%s", this.name(), this.start.name(), this.depth, indir);
    }

    public static EndlessPathFinder readPathFinder(String[] line, Configuration config) throws InvalidValueException {
        String err = "";
        if (line.length < 5 || !line[2].equals("EndlessPathFinder")) {
            throw new InvalidValueException("Does not declare a EndlessPathFinder: " + Arrays.toString(line));
        }
        String name = line[1];
        int depth = 0;
        NodeFilterManager start = config.getNodeFilterManager(line[3]);
        if (start == null) {
            err = "Invalid NodeFilterManager: " + line[3];
        }
        try {
            depth = Integer.parseInt(line[4]);
        }
        catch (NumberFormatException nfe) {
            err = "Invalid depth:" + line[4];
        }
        PairDirectory indie = null;
        if (line.length > 6) {
            indie = config.getPairDirectory(line[5]);
        }
        if (err.length() > 0) {
            throw new InvalidValueException(err);
        }
        if (indie == null) {
            return new EndlessPathFinder(name, start, depth);
        }
        return new EndlessPathFinder(name, start, depth, indie);
    }

    public static /* bridge */ /* synthetic */ PathFinder readPathFinder(String[] stringArray, Configuration configuration) throws InvalidValueException {
        return EndlessPathFinder.readPathFinder(stringArray, configuration);
    }
}

