/*
 * Decompiled with CFR 0.152.
 */
package pathfinders;

import exceptions.InvalidValueException;
import filters.NodeFilterManager;
import java.util.Arrays;
import java.util.List;
import pathfinders.PathFinder;
import structures.Configuration;
import structures.Graph;
import structures.PairDirectory;
import structures.Path;
import structures.PathManager;
import utilities.DebugTools;

public class BasicPathFinder
extends PathFinder {
    protected NodeFilterManager start;
    protected NodeFilterManager end;
    protected final int depth;
    protected PairDirectory pairs;
    protected boolean stopAtFirstEndpoint = false;

    public BasicPathFinder(String name, NodeFilterManager start, NodeFilterManager end, int depth) {
        this.name = name;
        this.start = start;
        this.end = end;
        this.depth = depth;
    }

    public BasicPathFinder(String name, NodeFilterManager start, NodeFilterManager end, int depth, boolean stopAtFirstEndpoint) {
        this(name, start, end, depth);
        this.stopAtFirstEndpoint = stopAtFirstEndpoint;
    }

    public BasicPathFinder(String name, NodeFilterManager start, NodeFilterManager end, int depth, boolean stopAtFirstEndpoint, PairDirectory pairs) {
        this(name, start, end, depth, stopAtFirstEndpoint);
        this.pairs = pairs;
    }

    @Override
    public PathManager findPaths(Graph g) {
        PathManager found = new PathManager();
        if (this.depth == 0) {
            return found;
        }
        List<String> startNodes = this.start.apply(g.nodes());
        for (String node : startNodes) {
            if (!g.contains(node)) {
                if (!DebugTools.DEBUG) continue;
                System.out.println("Node not in graph: " + node);
                continue;
            }
            PathManager npaths = this.findPaths(g, node, this.depth);
            if (DebugTools.DEBUG && npaths.size() > 0) {
                System.out.println(String.format("Found %d paths for starting node %s.", npaths.size(), node));
            }
            if (npaths == null) continue;
            found.addAll(npaths);
        }
        return found;
    }

    @Override
    public PathManager findPathsIterative(Graph g, int addDepth, double stop) {
        assert (false) : "Iterative-deepening search option not implemented for BasicPathFinder.";
        return null;
    }

    @Override
    protected PathFinder.PathStatus verify(Path p, int depth) {
        boolean dirOkay;
        boolean bl = dirOkay = this.pairs == null ? true : this.testPairOrder(p);
        if (!dirOkay) {
            return PathFinder.PathStatus.STOP;
        }
        String last = p.getNode(-1);
        boolean isEndpoint = this.end.accept(last);
        if (isEndpoint && p.edgeLength() > 0) {
            if (this.stopAtFirstEndpoint) {
                return PathFinder.PathStatus.SAVE_AND_STOP;
            }
            return PathFinder.PathStatus.SAVE_AND_CONTINUE;
        }
        if (depth == 0) {
            return PathFinder.PathStatus.STOP;
        }
        return PathFinder.PathStatus.CONTINUE;
    }

    protected boolean testPairOrder(Path p) {
        String last = p.getNode(-1);
        int i = 0;
        while (i < p.edgeLength()) {
            String q = p.getNode(i);
            PairDirectory.PartialOrder required = this.pairs.getOrder(q, last);
            if (required == PairDirectory.PartialOrder.BELOW) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String toString() {
        String indir = this.pairs == null ? "" : ", PairDirectory " + this.pairs.filename();
        return String.format("BasicPathFinder %s start=%s, end=%s, depth=%d%s", this.name(), this.start.name(), this.end.name(), this.depth, indir);
    }

    public static BasicPathFinder readPathFinder(String[] line, Configuration config) throws InvalidValueException {
        NodeFilterManager end;
        String err = "";
        if (line.length < 6 || !line[2].equals("BasicPathFinder")) {
            throw new InvalidValueException("Does not declare a BasicPathFinder: " + Arrays.toString(line));
        }
        String name = line[1];
        int depth = 0;
        NodeFilterManager start = config.getNodeFilterManager(line[3]);
        if (start == null) {
            err = "Invalid NodeFilterManager: " + line[3];
        }
        if ((end = config.getNodeFilterManager(line[4])) == null) {
            err = "Invalid NodeFilterManager: " + line[4];
        }
        try {
            depth = Integer.parseInt(line[5]);
        }
        catch (NumberFormatException nfe) {
            err = "Invalid depth: " + line[5];
        }
        PairDirectory pairs = null;
        boolean stopAtFirstEndpoint = false;
        if (line.length > 6) {
            int i = 6;
            while (i < line.length) {
                pairs = config.getPairDirectory(line[i]);
                if (pairs == null && line[i].toUpperCase().contains("STOP")) {
                    stopAtFirstEndpoint = true;
                } else if (pairs == null) {
                    err = "Invalid pair directory: " + line[i];
                }
                ++i;
            }
        }
        if (err.length() > 0) {
            throw new InvalidValueException(err);
        }
        if (pairs == null) {
            return new BasicPathFinder(name, start, end, depth, stopAtFirstEndpoint);
        }
        return new BasicPathFinder(name, start, end, depth, stopAtFirstEndpoint, pairs);
    }

    public static /* bridge */ /* synthetic */ PathFinder readPathFinder(String[] stringArray, Configuration configuration) throws InvalidValueException {
        return BasicPathFinder.readPathFinder(stringArray, configuration);
    }
}

