/*
 * Decompiled with CFR 0.152.
 */
package pathfinders;

import exceptions.InvalidValueException;
import filters.EdgeFilterManager;
import filters.NodeFilterManager;
import java.util.Arrays;
import pathfinders.BasicPathFinder;
import pathfinders.PathFinder;
import structures.Configuration;
import structures.PairDirectory;
import structures.Path;

public class BasicFreeEdgePathFinder
extends BasicPathFinder {
    protected EdgeFilterManager filterMan;

    public BasicFreeEdgePathFinder(String name, NodeFilterManager start, NodeFilterManager end, int depth, EdgeFilterManager filterMan) {
        super(name, start, end, depth);
        this.filterMan = filterMan;
    }

    public BasicFreeEdgePathFinder(String name, NodeFilterManager start, NodeFilterManager end, int depth, boolean stopAtFirstEndpoint, EdgeFilterManager filterMan) {
        super(name, start, end, depth, stopAtFirstEndpoint);
        this.filterMan = filterMan;
    }

    public BasicFreeEdgePathFinder(String name, NodeFilterManager start, NodeFilterManager end, int depth, boolean stopAtFirstEndpoint, PairDirectory pairs, EdgeFilterManager filterMan) {
        super(name, start, end, depth, stopAtFirstEndpoint, pairs);
        this.filterMan = filterMan;
    }

    @Override
    protected PathFinder.PathStatus verify(Path p, int depth) {
        PathFinder.PathStatus plain = super.verify(p, depth);
        if (plain == PathFinder.PathStatus.CONTINUE || depth == 0 && plain == PathFinder.PathStatus.STOP) {
            if (this.filterAccept(p)) {
                return PathFinder.PathStatus.CONTINUE_FOR_FREE;
            }
            return plain;
        }
        return plain;
    }

    protected boolean filterAccept(Path p) {
        if (p.edgeLength() == 0) {
            return false;
        }
        return this.filterMan.accept(p.getEdge(-1));
    }

    @Override
    public String toString() {
        String indir = this.pairs == null ? "" : ", Indirectory " + this.pairs.filename();
        return String.format("BasicFreeEdgePathFinder %s start=%s, end=%s, depth=%d, free_edge_filter=%s%s", this.name, this.start.name(), this.end.name(), this.depth, this.filterMan.name(), indir);
    }

    public static BasicFreeEdgePathFinder readPathFinder(String[] line, Configuration config) throws InvalidValueException {
        NodeFilterManager end;
        String err = "";
        if (line.length < 7 || !line[2].equals("BasicFreeEdgePathFinder")) {
            throw new InvalidValueException("Does not declare a BasicFreeEdgePathFinder: " + Arrays.toString(line));
        }
        String name = line[1];
        int depth = 0;
        NodeFilterManager start = config.getNodeFilterManager(line[3]);
        if (start == null) {
            err = "Invalid NodeFilterManager: " + line[3];
        }
        if ((end = config.getNodeFilterManager(line[4])) == null) {
            err = "Invalid NodeFilterManager: " + line[4];
        }
        try {
            depth = Integer.parseInt(line[5]);
        }
        catch (NumberFormatException nfe) {
            err = "Invalid depth:" + line[5];
        }
        EdgeFilterManager free = config.getEdgeFilterManager(line[6]);
        if (end == null) {
            err = "Invalid EdgeFilterManager: " + line[6];
        }
        PairDirectory pairs = null;
        boolean stopAtFirstEndpoint = false;
        if (line.length > 7) {
            int i = 7;
            while (i < line.length) {
                pairs = config.getPairDirectory(line[i]);
                if (pairs == null && line[i].toUpperCase().contains("STOP")) {
                    stopAtFirstEndpoint = true;
                } else if (pairs == null) {
                    err = "Invalid pair directory: " + line[i];
                }
                ++i;
            }
        }
        if (err.length() > 0) {
            throw new InvalidValueException(err);
        }
        if (pairs == null) {
            return new BasicFreeEdgePathFinder(name, start, end, depth, stopAtFirstEndpoint, free);
        }
        return new BasicFreeEdgePathFinder(name, start, end, depth, stopAtFirstEndpoint, pairs, free);
    }

    public static /* bridge */ /* synthetic */ BasicPathFinder readPathFinder(String[] stringArray, Configuration configuration) throws InvalidValueException {
        return BasicFreeEdgePathFinder.readPathFinder(stringArray, configuration);
    }
}

