/*
 * Decompiled with CFR 0.152.
 */
package pathfinders;

import exceptions.InvalidValueException;
import filters.NodeFilterManager;
import java.util.Arrays;
import pathfinders.BasicPathFinder;
import pathfinders.PathFinder;
import structures.Configuration;
import structures.PairDirectory;
import structures.Path;

public class BasicFilteredPathFinder
extends BasicPathFinder {
    protected NodeFilterManager tester;

    public BasicFilteredPathFinder(String name, NodeFilterManager start, NodeFilterManager end, int depth, NodeFilterManager tester) {
        super(name, start, end, depth);
        this.tester = tester;
    }

    public BasicFilteredPathFinder(String name, NodeFilterManager start, NodeFilterManager end, int depth, boolean stopAtFirstEndpoint, NodeFilterManager tester) {
        super(name, start, end, depth, stopAtFirstEndpoint);
        this.tester = tester;
    }

    public BasicFilteredPathFinder(String name, NodeFilterManager start, NodeFilterManager end, int depth, boolean stopAtFirstEndpoint, PairDirectory pairs, NodeFilterManager tester) {
        super(name, start, end, depth, stopAtFirstEndpoint, pairs);
        this.tester = tester;
    }

    @Override
    protected PathFinder.PathStatus verify(Path p, int depth) {
        PathFinder.PathStatus plain = super.verify(p, depth);
        if (plain == PathFinder.PathStatus.SAVE_AND_STOP || plain == PathFinder.PathStatus.SAVE_AND_CONTINUE) {
            if (this.filterAccept(p)) {
                return plain;
            }
            return PathFinder.PathStatus.STOP;
        }
        return plain;
    }

    protected boolean filterAccept(Path p) {
        return this.tester.accept(p.nodes());
    }

    @Override
    public String toString() {
        String indir = this.pairs == null ? "" : ", Indirectory " + this.pairs.filename();
        return String.format("BasicFilteredPathFinder %s start=%s, end=%s, depth=%d, filter=%s%s", this.name, this.start.name(), this.end.name(), this.depth, this.tester.name(), indir);
    }

    public static BasicFilteredPathFinder readPathFinder(String[] line, Configuration config) throws InvalidValueException {
        NodeFilterManager end;
        String err = "";
        if (line.length < 7 || !line[2].equals("BasicFilteredPathFinder")) {
            throw new InvalidValueException("Does not declare a BasicFilteredPathFinder: " + Arrays.toString(line));
        }
        String name = line[1];
        int depth = 0;
        NodeFilterManager start = config.getNodeFilterManager(line[3]);
        if (start == null) {
            err = "Invalid NodeFilterManager: " + line[3];
        }
        if ((end = config.getNodeFilterManager(line[4])) == null) {
            err = "Invalid NodeFilterManager: " + line[4];
        }
        try {
            depth = Integer.parseInt(line[5]);
        }
        catch (NumberFormatException nfe) {
            err = "Invalid depth:" + line[5];
        }
        NodeFilterManager contains = config.getNodeFilterManager(line[6]);
        if (end == null) {
            err = "Invalid NodeFilterManager: " + line[6];
        }
        PairDirectory pairs = null;
        boolean stopAtFirstEndpoint = false;
        if (line.length > 7) {
            int i = 7;
            while (i < line.length) {
                pairs = config.getPairDirectory(line[i]);
                if (pairs == null && line[i].toUpperCase().contains("STOP")) {
                    stopAtFirstEndpoint = true;
                } else if (pairs == null) {
                    err = "Invalid pair directory: " + line[i];
                }
                ++i;
            }
        }
        if (err.length() > 0) {
            throw new InvalidValueException(err);
        }
        if (pairs == null) {
            return new BasicFilteredPathFinder(name, start, end, depth, stopAtFirstEndpoint, contains);
        }
        return new BasicFilteredPathFinder(name, start, end, depth, stopAtFirstEndpoint, pairs, contains);
    }

    public static /* bridge */ /* synthetic */ BasicPathFinder readPathFinder(String[] stringArray, Configuration configuration) throws InvalidValueException {
        return BasicFilteredPathFinder.readPathFinder(stringArray, configuration);
    }
}

