/*
 * Decompiled with CFR 0.152.
 */
package filters;

import exceptions.IncomparableException;
import exceptions.InvalidValueException;
import filters.Filter;
import structures.Feature;
import structures.Value;

public class OrderedFilter
extends Filter {
    protected final Value threshold;
    protected final Order order;

    protected OrderedFilter(String name, Feature f, boolean acceptNull, Value threshold, Order order) {
        super(name, f, acceptNull);
        this.threshold = threshold;
        this.order = order;
    }

    public Value threshold() {
        return this.threshold;
    }

    public Order order() {
        return this.order;
    }

    @Override
    public boolean accept(Value v) {
        if (this.acceptNull && v == null) {
            return true;
        }
        if (v == null || this.feature.legal(v.toString()) == null) {
            return false;
        }
        return v.compareTo(this.threshold) == this.order.value();
    }

    public String toString() {
        String acceptNull = this.acceptNull ? "|null" : "";
        return String.format("%s %s %s%s", this.feature.name(), this.order.toString(), this.threshold.toString(), acceptNull);
    }

    public static OrderedFilter makeFilter(String name, Feature f, boolean acceptNull, Value threshold, Order order) throws InvalidValueException, IncomparableException {
        if (!f.isComparable()) {
            throw new IncomparableException(String.format("Cannot base OrderedFilter on feature %s: not comparable.", f.name()));
        }
        if (threshold == null || f.legal(threshold.toString()) == null) {
            throw new InvalidValueException(String.format("In OrderedFilter(), cannot combine feature %s and value %s.", f.name(), threshold.toString()));
        }
        return new OrderedFilter(name, f, acceptNull, threshold, order);
    }

    public static OrderedFilter makeFilter(String[] line, Feature f) throws InvalidValueException, IncomparableException {
        if (line.length < 6) {
            throw new InvalidValueException("OrderedNodeFilter not declared correctly.");
        }
        String name = line[1];
        boolean acceptNull = line[4].contains("null");
        String valString = line[4];
        if (acceptNull) {
            valString = valString.replace("|null", "").replace("null|", "").replace("null", "");
        }
        Value v = f.legal(valString);
        Order o = Order.valueOf(line[5].toUpperCase());
        return OrderedFilter.makeFilter(name, f, acceptNull, v, o);
    }

    public static /* bridge */ /* synthetic */ Filter makeFilter(String[] stringArray, Feature feature) throws InvalidValueException, IncomparableException {
        return OrderedFilter.makeFilter(stringArray, feature);
    }

    public static enum Order {
        LESSER(-1),
        EQUAL(0),
        GREATER(1);

        private final int resVal;

        private Order(int res) {
            this.resVal = res;
        }

        public int value() {
            return this.resVal;
        }
    }
}

