/*
 * Decompiled with CFR 0.152.
 */
package filters;

import exceptions.InvalidValueException;
import filters.EqualsFilter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import structures.CatSet;
import structures.Discrete;
import structures.Feature;
import structures.Value;
import utilities.StringUtils;

public class NotEqualsFilter
extends EqualsFilter {
    protected final HashSet<Value> legal;
    public static final String VAL_DELIM = "\\|";

    private NotEqualsFilter(String name, Feature f, boolean acceptNull, Value[] legal) {
        super(name, f, acceptNull, legal);
        this.legal = new HashSet<Value>(Arrays.asList(legal));
    }

    @Override
    public boolean accept(Value v) {
        return !super.accept(v);
    }

    @Override
    public String toString() {
        String acceptNull = this.acceptNull ? "|null" : "";
        return String.format("NotEquals %s [%s%s]", this.feature.name(), StringUtils.join(this.legal, "|"), acceptNull);
    }

    public static NotEqualsFilter makeFilter(String[] line, Feature f) throws InvalidValueException {
        String name = line[1];
        if (f == null) {
            throw new InvalidValueException(String.format("Undefined feature %s expected by NotEqualsFilter %s.", line[3], name));
        }
        String valString = line[4];
        boolean acceptNull = line[4].contains("null");
        if (acceptNull) {
            valString = line[4].replace("|null", "").replace("null|", "").replace("null", "");
        }
        String[] vals = valString.split(VAL_DELIM);
        Value[] v = new Value[vals.length];
        if (f.type() == Value.Type.SET) {
            CatSet vi = (CatSet)f.legal(valString);
            if (vi == null) {
                throw new InvalidValueException(String.format("%s is not a legal value for Feature %s.", vi, f.toString()));
            }
            Set<Discrete> catvals = vi.getValue();
            Iterator<Discrete> catiter = catvals.iterator();
            int i = 0;
            while (i < vals.length) {
                v[i] = catiter.next();
                ++i;
            }
        } else {
            int i = 0;
            while (i < vals.length) {
                v[i] = f.legal(vals[i]);
                if (v[i] == null) {
                    throw new InvalidValueException(String.format("%s is not a legal value for Feature %s.", vals[i], f.toString()));
                }
                ++i;
            }
        }
        return NotEqualsFilter.makeFilter(name, f, acceptNull, v);
    }

    public static NotEqualsFilter makeFilter(String name, Feature f, boolean acceptNull, Value[] legal) throws InvalidValueException {
        Value[] valueArray = legal;
        int n = legal.length;
        int n2 = 0;
        while (n2 < n) {
            Value v = valueArray[n2];
            if (v == null) {
                System.err.println("err");
            }
            if (f.legal(v.toString()) == null) {
                throw new InvalidValueException(String.format("In this filter, cannot combine feature %s and value %s.", f.name(), v.toString()));
            }
            ++n2;
        }
        return new NotEqualsFilter(name, f, acceptNull, legal);
    }

    public static /* bridge */ /* synthetic */ EqualsFilter makeFilter(String string, Feature feature, boolean bl, Value[] valueArray) throws InvalidValueException {
        return NotEqualsFilter.makeFilter(string, feature, bl, valueArray);
    }

    public static /* bridge */ /* synthetic */ EqualsFilter makeFilter(String[] stringArray, Feature feature) throws InvalidValueException {
        return NotEqualsFilter.makeFilter(stringArray, feature);
    }
}

