/*
 * Decompiled with CFR 0.152.
 */
package filters;

import exceptions.InvalidValueException;
import filters.Filter;
import filters.FilterManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import structures.Configuration;
import structures.Feature;
import structures.Graph;
import structures.NodeLibrary;
import structures.Value;
import utilities.StringUtils;

public class NodeFilterManager
extends FilterManager<String, Filter, NodeLibrary> {
    public NodeFilterManager(String name, Collection<Filter> filters, FilterManager.FilterItemMode itemMode, FilterManager.FilterSetMode setMode, NodeLibrary library) {
        super(name, filters, itemMode, setMode, library);
    }

    public NodeFilterManager(String name, Filter filter, FilterManager.FilterItemMode itemMode, FilterManager.FilterSetMode setMode, NodeLibrary library) {
        super(name, filter, itemMode, setMode, library);
    }

    @Override
    protected Value getValue(String node, Feature f) {
        return ((NodeLibrary)this.library).getValue(node, f);
    }

    @Override
    public Graph filter(Graph orig) {
        HashSet<String> keepNodes = new HashSet<String>();
        for (String n : orig.nodes()) {
            if (!this.accept(n)) continue;
            keepNodes.add(n);
        }
        Graph copy = orig.restrict(keepNodes);
        return copy;
    }

    public static NodeFilterManager readFilterManager(String[] line, Configuration config) throws InvalidValueException {
        String[] fsplit;
        if (line.length < 5) {
            throw new InvalidValueException("NodeFilterManager not declared properly: " + Arrays.toString(line));
        }
        String name = line[1];
        FilterManager.FilterItemMode itemMode = FilterManager.FilterItemMode.valueOf(line[2].toUpperCase());
        FilterManager.FilterSetMode setMode = FilterManager.FilterSetMode.valueOf(line[3].toUpperCase());
        ArrayList<Filter> filters = new ArrayList<Filter>();
        String[] stringArray = fsplit = line[4].split("\\|");
        int n = fsplit.length;
        int n2 = 0;
        while (n2 < n) {
            String fname = stringArray[n2];
            Filter filt = config.getNodeFilter(fname);
            if (filt == null) {
                throw new InvalidValueException(String.format("Filter %s not declared before NodeFilterManager %s.", fname, name));
            }
            filters.add(filt);
            ++n2;
        }
        NodeFilterManager man = new NodeFilterManager(name, (Collection<Filter>)filters, itemMode, setMode, config.nodeLibrary());
        return man;
    }

    public String toString() {
        String report = String.format("NodeFilterManager %s\t%s\t%s\n\t%s", new Object[]{this.name, this.itemMode, this.setMode, StringUtils.sortJoin(this.filters, "\n\t")});
        return report;
    }
}

