/*
 * Decompiled with CFR 0.152.
 */
package filters;

import exceptions.InvalidValueException;
import filters.Filter;
import filters.FilterManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import structures.Configuration;
import structures.Feature;
import structures.Graph;
import structures.Value;
import utilities.GraphUtils;
import utilities.StringUtils;

public class GraphNodeFilterManager
extends FilterManager<String, Filter, Graph> {
    public GraphNodeFilterManager(String name, Filter filter, FilterManager.FilterItemMode itemMode, FilterManager.FilterSetMode setMode, Graph g) {
        super(name, filter, itemMode, setMode, g);
    }

    public GraphNodeFilterManager(String name, Collection<Filter> filters, FilterManager.FilterItemMode itemMode, FilterManager.FilterSetMode setMode, Graph g) {
        super(name, filters, itemMode, setMode, g);
    }

    @Override
    protected Value getValue(String item, Feature f) {
        return GraphUtils.getValue(item, f, (Graph)this.library);
    }

    public String toString() {
        String report = String.format("GraphNodeFilterManager %s\t%s\t%s\n\t%s", new Object[]{this.name, this.itemMode, this.setMode, StringUtils.sortJoin(this.filters, "\n\t")});
        return report;
    }

    public static GraphNodeFilterManager readFilterManager(String[] line, Configuration config) throws InvalidValueException {
        String[] fsplit;
        if (line.length < 5) {
            throw new InvalidValueException("GraphFilterManager not declared properly: " + Arrays.toString(line));
        }
        String name = line[1];
        FilterManager.FilterItemMode itemMode = FilterManager.FilterItemMode.valueOf(line[2].toUpperCase());
        FilterManager.FilterSetMode setMode = FilterManager.FilterSetMode.valueOf(line[3].toUpperCase());
        ArrayList<Filter> filters = new ArrayList<Filter>();
        String[] stringArray = fsplit = line[4].split("\\|");
        int n = fsplit.length;
        int n2 = 0;
        while (n2 < n) {
            String fname = stringArray[n2];
            Filter filt = config.getGraphFilter(fname);
            if (filt == null) {
                throw new InvalidValueException(String.format("GraphFilter %s not declared before GraphFilterManager %s.", fname, name));
            }
            filters.add(filt);
            ++n2;
        }
        GraphNodeFilterManager man = new GraphNodeFilterManager(name, filters, itemMode, setMode, null);
        return man;
    }

    @Override
    public Graph filter(Graph g) {
        this.setLibrary(g);
        HashSet<String> keepNodes = new HashSet<String>();
        for (String n : g.nodes()) {
            if (!this.accept(n)) continue;
            keepNodes.add(n);
        }
        Graph copy = g.restrict(keepNodes);
        return copy;
    }
}

