/*
 * Decompiled with CFR 0.152.
 */
package filters;

import exceptions.InvalidValueException;
import filters.Filter;
import filters.FilterManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import structures.Configuration;
import structures.Edge;
import structures.Feature;
import structures.Graph;
import structures.Value;
import utilities.GraphUtils;
import utilities.StringUtils;

public class GraphEdgeFilterManager
extends FilterManager<Edge, Filter, Graph> {
    public GraphEdgeFilterManager(String name, Filter filter, FilterManager.FilterItemMode itemMode, FilterManager.FilterSetMode setMode, Graph g) {
        super(name, filter, itemMode, setMode, g);
    }

    public GraphEdgeFilterManager(String name, Collection<Filter> filters, FilterManager.FilterItemMode itemMode, FilterManager.FilterSetMode setMode, Graph g) {
        super(name, filters, itemMode, setMode, g);
    }

    @Override
    protected Value getValue(Edge item, Feature f) {
        return GraphUtils.getValue(item, f, (Graph)this.library);
    }

    public String toString() {
        String report = String.format("GraphEdgeFilterManager %s\t%s\t%s\n\t%s", new Object[]{this.name, this.itemMode, this.setMode, StringUtils.sortJoin(this.filters, "\n\t")});
        return report;
    }

    public static GraphEdgeFilterManager readFilterManager(String[] line, Configuration config) throws InvalidValueException {
        String[] fsplit;
        if (line.length < 5) {
            throw new InvalidValueException("GraphFilterManager not declared properly: " + Arrays.toString(line));
        }
        String name = line[1];
        FilterManager.FilterItemMode itemMode = FilterManager.FilterItemMode.valueOf(line[2].toUpperCase());
        FilterManager.FilterSetMode setMode = FilterManager.FilterSetMode.valueOf(line[3].toUpperCase());
        ArrayList<Filter> filters = new ArrayList<Filter>();
        String[] stringArray = fsplit = line[4].split("\\|");
        int n = fsplit.length;
        int n2 = 0;
        while (n2 < n) {
            String fname = stringArray[n2];
            Filter filt = config.getGraphFilter(fname);
            if (filt == null) {
                throw new InvalidValueException(String.format("GraphFilter %s not declared before GraphFilterManager %s.", fname, name));
            }
            filters.add(filt);
            ++n2;
        }
        GraphEdgeFilterManager man = new GraphEdgeFilterManager(name, filters, itemMode, setMode, null);
        return man;
    }

    @Override
    public Graph filter(Graph g) {
        this.setLibrary(g);
        HashSet<Edge> keepEdges = new HashSet<Edge>();
        for (Edge e : g.edges()) {
            if (!this.accept(e)) continue;
            keepEdges.add(e);
        }
        Graph copy = new Graph(keepEdges);
        return copy;
    }
}

