/*
 * Decompiled with CFR 0.152.
 */
package filters;

import filters.Filter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import structures.Feature;
import structures.Graph;
import structures.Value;

public abstract class FilterManager<T, F extends Filter, L> {
    public static final String DELIM = "\\|";
    protected FilterItemMode itemMode;
    protected FilterSetMode setMode;
    protected ArrayList<F> filters;
    protected String name;
    protected L library;

    protected FilterManager(String name, FilterItemMode itemMode, FilterSetMode setMode, L library) {
        this.itemMode = itemMode;
        this.setMode = setMode;
        this.name = name;
        this.library = library;
    }

    protected FilterManager(String name, F filter, FilterItemMode itemMode, FilterSetMode setMode, L library) {
        this(name, itemMode, setMode, library);
        this.filters = new ArrayList();
        this.filters.add(filter);
    }

    protected FilterManager(String name, Collection<F> filters, FilterItemMode itemMode, FilterSetMode setMode, L library) {
        this(name, itemMode, setMode, library);
        this.filters = new ArrayList<F>(filters);
    }

    public FilterItemMode itemMode() {
        return this.itemMode;
    }

    public FilterSetMode setMode() {
        return this.setMode;
    }

    public String name() {
        return this.name;
    }

    public void setLibrary(L library) {
        this.library = library;
    }

    public L library() {
        return this.library;
    }

    protected abstract Value getValue(T var1, Feature var2);

    public abstract Graph filter(Graph var1);

    public boolean accept(T item) {
        assert (this.library != null) : "Need to give a library to the filter manager.";
        boolean accept = true;
        switch (this.itemMode) {
            case AND: {
                accept = this.acceptAnd(item);
                break;
            }
            case OR: {
                accept = this.acceptOr(item);
                break;
            }
            default: {
                accept = true;
            }
        }
        return accept;
    }

    public boolean accept(Collection<T> items) {
        boolean accept = true;
        switch (this.setMode) {
            case ANY: {
                accept = this.acceptAny(items);
                break;
            }
            case ALL: {
                accept = this.acceptAll(items);
                break;
            }
            default: {
                accept = true;
            }
        }
        return accept;
    }

    protected boolean acceptAll(Collection<T> items) {
        for (T item : items) {
            if (this.accept(item)) continue;
            return false;
        }
        return true;
    }

    protected boolean acceptAny(Collection<T> items) {
        for (T item : items) {
            if (!this.accept(item)) continue;
            return true;
        }
        return false;
    }

    protected boolean acceptAnd(T item) {
        for (Filter f : this.filters) {
            Value v;
            if (f.accept(v = this.getValue(item, f.feature()))) continue;
            return false;
        }
        return true;
    }

    protected boolean acceptOr(T item) {
        for (Filter f : this.filters) {
            Value v;
            if (!f.accept(v = this.getValue(item, f.feature()))) continue;
            return true;
        }
        return false;
    }

    public List<T> apply(Collection<T> items) {
        ArrayList<T> accepted = new ArrayList<T>();
        for (T item : items) {
            if (!this.accept(item)) continue;
            accepted.add(item);
        }
        return accepted;
    }

    public static enum FilterItemMode {
        AND,
        OR,
        NONE;

    }

    public static enum FilterSetMode {
        ALL,
        ANY,
        NONE;

    }
}

