/*
 * Decompiled with CFR 0.152.
 */
package filters;

import exceptions.IncomparableException;
import exceptions.InvalidValueException;
import filters.EqualsFilter;
import filters.NotEqualsFilter;
import filters.OrderedFilter;
import structures.Feature;
import structures.Value;

public abstract class Filter {
    protected final String name;
    protected final Feature feature;
    protected final boolean acceptNull;

    protected Filter(String name, Feature feat, boolean acceptNull) {
        this.name = name;
        this.feature = feat;
        this.acceptNull = acceptNull;
    }

    public String name() {
        return this.name;
    }

    public Feature feature() {
        return this.feature;
    }

    public abstract boolean accept(Value var1);

    public static Filter makeFilter(String[] line, Feature f) throws InvalidValueException, IncomparableException {
        FilterType type = FilterType.byName(line[2]);
        if (type == null) {
            throw new InvalidValueException("Invalid filter type: " + line[2]);
        }
        Filter filter = null;
        switch (type) {
            case ORDERED: {
                filter = OrderedFilter.makeFilter(line, f);
                break;
            }
            case EQUALS: {
                filter = EqualsFilter.makeFilter(line, f);
                break;
            }
            case NOT: {
                filter = NotEqualsFilter.makeFilter(line, f);
                break;
            }
            default: {
                filter = null;
            }
        }
        return filter;
    }

    public static enum FilterType {
        ORDERED("OrderedFilter"),
        EQUALS("EqualsFilter"),
        NOT("NotEqualsFilter");

        private String className;

        private FilterType(String name) {
            this.className = name;
        }

        public static FilterType byName(String name) {
            FilterType[] filterTypeArray = FilterType.values();
            int n = filterTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                FilterType t = filterTypeArray[n2];
                if (name.equals(t.className)) {
                    return t;
                }
                ++n2;
            }
            return null;
        }

        public String className() {
            return this.className;
        }
    }
}

