/*
 * Decompiled with CFR 0.152.
 */
package filters;

import exceptions.IncomparableException;
import exceptions.InvalidValueException;
import filters.Filter;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import structures.CatSet;
import structures.Discrete;
import structures.Feature;
import structures.Value;
import utilities.StringUtils;

public class EqualsFilter
extends Filter {
    protected final HashSet<Value> legal;
    public static final String VAL_DELIM = "\\|";

    protected EqualsFilter(String name, Feature f, boolean acceptNull, Value[] legal) {
        super(name, f, acceptNull);
        this.legal = new HashSet<Value>(Arrays.asList(legal));
    }

    @Override
    public Feature feature() {
        return this.feature;
    }

    public Set<Value> legal() {
        return Collections.unmodifiableSet(this.legal);
    }

    @Override
    public boolean accept(Value v) {
        if (this.acceptNull && v == null) {
            return true;
        }
        if (v == null) {
            return false;
        }
        if (v.getType() == Value.Type.SET) {
            CatSet catv = (CatSet)v;
            HashSet<Discrete> set = new HashSet<Discrete>(catv.getValue());
            set.retainAll(this.legal);
            return set.size() > 0;
        }
        return this.legal.contains(v);
    }

    public String toString() {
        String acceptNull = this.acceptNull ? "|null" : "";
        return String.format("%s [%s%s]", this.feature.name(), StringUtils.join(this.legal, "|"), acceptNull);
    }

    public static EqualsFilter makeFilter(String[] line, Feature f) throws InvalidValueException {
        String name = line[1];
        if (f == null) {
            throw new InvalidValueException(String.format("Undefined feature %s expected by EqualsFilter %s.", line[3], name));
        }
        String valString = line[4];
        boolean acceptNull = line[4].contains("null");
        if (acceptNull) {
            valString = line[4].replace("|null", "").replace("null|", "").replace("null", "");
        }
        String[] vals = valString.split(VAL_DELIM);
        Value[] v = new Value[vals.length];
        if (f.type() == Value.Type.SET) {
            CatSet vi = (CatSet)f.legal(valString);
            if (vi == null) {
                throw new InvalidValueException(String.format("%s is not a legal value for Feature %s.", vi, f.toString()));
            }
            Set<Discrete> catvals = vi.getValue();
            Iterator<Discrete> catiter = catvals.iterator();
            int i = 0;
            while (i < vals.length) {
                v[i] = catiter.next();
                ++i;
            }
        } else {
            int i = 0;
            while (i < vals.length) {
                v[i] = f.legal(vals[i]);
                if (v[i] == null) {
                    throw new InvalidValueException(String.format("%s is not a legal value for Feature %s.", vals[i], f.toString()));
                }
                ++i;
            }
        }
        return EqualsFilter.makeFilter(name, f, acceptNull, v);
    }

    public static EqualsFilter makeFilter(String name, Feature f, boolean acceptNull, Value[] legal) throws InvalidValueException {
        Value[] valueArray = legal;
        int n = legal.length;
        int n2 = 0;
        while (n2 < n) {
            Value v = valueArray[n2];
            if (v == null) {
                System.err.println("err");
            }
            if (f.legal(v.toString()) == null) {
                throw new InvalidValueException(String.format("In this filter, cannot combine feature %s and value %s.", f.name(), v.toString()));
            }
            ++n2;
        }
        return new EqualsFilter(name, f, acceptNull, legal);
    }

    public static /* bridge */ /* synthetic */ Filter makeFilter(String[] stringArray, Feature feature) throws InvalidValueException, IncomparableException {
        return EqualsFilter.makeFilter(stringArray, feature);
    }
}

