/*
 * Decompiled with CFR 0.152.
 */
package filters;

import exceptions.InvalidValueException;
import filters.Filter;
import filters.FilterManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import structures.Configuration;
import structures.Edge;
import structures.EdgeLibrary;
import structures.Feature;
import structures.Graph;
import structures.Value;
import utilities.StringUtils;

public class EdgeFilterManager
extends FilterManager<Edge, Filter, EdgeLibrary> {
    public EdgeFilterManager(String name, Collection<Filter> filters, FilterManager.FilterItemMode itemMode, FilterManager.FilterSetMode setMode, EdgeLibrary library) {
        super(name, filters, itemMode, setMode, library);
    }

    @Override
    protected Value getValue(Edge item, Feature f) {
        return ((EdgeLibrary)this.library).getValue(item, f);
    }

    @Override
    public Graph filter(Graph g) {
        Graph newG = new Graph();
        for (Edge e : g.edges()) {
            if (!this.accept(e)) continue;
            newG.add(e);
        }
        return newG;
    }

    public static EdgeFilterManager readFilterManager(String[] line, Configuration config) throws InvalidValueException {
        String[] fsplit;
        if (line.length < 5) {
            throw new InvalidValueException("EdgeFilterManager not declared properly: " + Arrays.toString(line));
        }
        String name = line[1];
        FilterManager.FilterItemMode itemMode = FilterManager.FilterItemMode.valueOf(line[2].toUpperCase());
        FilterManager.FilterSetMode setMode = FilterManager.FilterSetMode.valueOf(line[3].toUpperCase());
        ArrayList<Filter> filters = new ArrayList<Filter>();
        String[] stringArray = fsplit = line[4].split("\\|");
        int n = fsplit.length;
        int n2 = 0;
        while (n2 < n) {
            String fname = stringArray[n2];
            Filter filt = config.getEdgeFilter(fname);
            if (filt == null) {
                throw new InvalidValueException(String.format("Filter %s not declared before EdgeFilterManager %s.", fname, name));
            }
            filters.add(filt);
            ++n2;
        }
        EdgeFilterManager man = new EdgeFilterManager(name, (Collection<Filter>)filters, itemMode, setMode, config.edgeLibrary());
        return man;
    }

    public String toString() {
        String report = String.format("EdgeFilterManager %s\t%s\t%s\n\t%s", new Object[]{this.name, this.itemMode, this.setMode, StringUtils.sortJoin(this.filters, "\n\t")});
        return report;
    }
}

