/*
 * Decompiled with CFR 0.152.
 */
package apps;

import exceptions.DuplicateException;
import exceptions.IncomparableException;
import exceptions.InvalidValueException;
import filters.EqualsFilter;
import filters.Filter;
import filters.FilterManager;
import filters.GraphNodeFilterManager;
import filters.NodeFilterManager;
import filters.OrderedFilter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import pathfinders.PathFinder;
import structures.Configuration;
import structures.Continuous;
import structures.Edge;
import structures.EdgeLibrary;
import structures.Feature;
import structures.Graph;
import structures.IfConsistentCollapser;
import structures.NodeLibrary;
import structures.Pair;
import structures.PairDirectory;
import structures.Path;
import structures.PathManager;
import structures.Subgraph;
import structures.Value;
import utilities.GamsPrinter;
import utilities.GraphUtils;
import utilities.StringUtils;

public class Tester {
    public static Random RAND = new Random(12345L);

    public static void main(String[] args) {
        ArrayList tests = new ArrayList();
        int tempI = 0;
        File out = null;
        String[][] configs = new String[][]{{"test/test0.config", "test/expected_output/test0.out", "test0"}, {"test/test1.config", "test/expected_output/test1.out", "test1"}, {"test/test2.config", "test/expected_output/test2.out", "test2"}, {"test/test3.config", "test/expected_output/test3.out", "test3"}, {"test/test4.config", "test/expected_output/test4.out", "test4"}, {"test/test5.config", "test/expected_output/test5.out", "test5"}, {"test/test6.config", "test/expected_output/test6.out", "test6"}, {"test/test7.config", "test/expected_output/test7.out", "test7"}};
        String outPattern = "test/temp_output/temp_out_%d.out";
        String[][] stringArrayArray = configs;
        int n = configs.length;
        int n2 = 0;
        while (n2 < n) {
            String[] confPair = stringArrayArray[n2];
            String confFile = confPair[0];
            String expOut = confPair[1];
            String test = confPair[2];
            File exp = new File(expOut);
            if (!exp.exists()) {
                System.out.format("Cannot find expected output %s.\n", expOut);
            }
            String temp = String.format(outPattern, tempI);
            out = new File(temp);
            try {
                if (test.equals("test0")) {
                    Tester.mainTestGraph0(confFile, new PrintStream(out));
                } else if (test.equals("test1")) {
                    Tester.mainTestGraph1(confFile, new PrintStream(out));
                } else if (test.equals("test2")) {
                    Tester.mainTestGraph2(confFile, new PrintStream(out));
                } else if (test.equals("test3")) {
                    Tester.mainTestGraph3(confFile, new PrintStream(out));
                } else if (test.equals("test4")) {
                    Tester.mainTestGraph4(confFile, new PrintStream(out));
                } else if (test.equals("test5")) {
                    Tester.mainTestGraph5(confFile, new PrintStream(out));
                } else if (test.equals("test6")) {
                    Tester.mainTestGraph6(confFile, new PrintStream(out));
                } else if (test.equals("test7")) {
                    Tester.mainTestGraph7(confFile, new PrintStream(out));
                }
                ++tempI;
            }
            catch (FileNotFoundException fnfe) {
                System.err.format("Unable to write to output file %s?\n", temp);
            }
            System.out.format("Comparing  expected %s to actual %s\n", expOut, temp);
            boolean result = Tester.diff(expOut, temp);
            System.out.format("Result: %s\n", result ? "success" : "failure");
            ++n2;
        }
    }

    public static boolean diff(String expected, String actual) {
        Process p = null;
        try {
            p = Runtime.getRuntime().exec(String.format("diff %s %s", expected, actual));
        }
        catch (IOException e) {
            System.out.format("Unable to find correct output file %s.\n", expected);
            return false;
        }
        BufferedReader errs = new BufferedReader(new InputStreamReader(p.getErrorStream()));
        String s = "";
        StringBuilder sb = new StringBuilder();
        try {
            while ((s = errs.readLine()) != null) {
                sb.append("\t" + s + "\n");
            }
        }
        catch (IOException e) {
            System.out.format("Problem reading diff results?\n", new Object[0]);
            return false;
        }
        if (sb.length() > 0) {
            System.out.format("Problem running diff: %s", sb.toString());
            return false;
        }
        BufferedReader stdInput = new BufferedReader(new InputStreamReader(p.getInputStream()));
        int lines = 0;
        s = "";
        try {
            while ((s = stdInput.readLine()) != null) {
                System.out.println(s);
                ++lines;
            }
        }
        catch (IOException e) {
            System.out.format("Problem reading diff results?\n", new Object[0]);
            return false;
        }
        return lines == 0;
    }

    public static boolean mainTestGraph7(String config, PrintStream out) {
        boolean success = false;
        boolean allSuccess = true;
        PrintStream stdout = System.out;
        System.setOut(out);
        System.out.println("Testing source-target pair reading and pathfinding...");
        success = Tester.testPairsBasic(true, config);
        System.out.format("...%s!\n", success ? "success" : "failed");
        System.setOut(stdout);
        return allSuccess &= success;
    }

    public static boolean mainTestGraph6(String config, PrintStream out) {
        boolean success = false;
        boolean allSuccess = true;
        PrintStream stdout = System.out;
        System.setOut(out);
        System.out.println("Testing reaction edge usage...");
        success = Tester.testReaction(true, config);
        System.out.format("...%s!\n", success ? "success" : "failed");
        System.setOut(stdout);
        return allSuccess &= success;
    }

    public static boolean mainTestGraph5(String config, PrintStream out) {
        boolean success = false;
        boolean allSuccess = true;
        PrintStream stdout = System.out;
        System.setOut(out);
        System.out.println("Testing reading collapser from config...");
        success = Tester.testEdgeLibraryCollapseAndRedirectFromConfig(true, config);
        System.out.format("...%s!\n", success ? "success" : "failed");
        allSuccess &= success;
        System.out.println("Testing graph filtering based on edge filter");
        success = Tester.testGraphFiltering(true, config);
        System.out.format("...%s!\n", success ? "success" : "failed");
        System.setOut(stdout);
        return allSuccess &= success;
    }

    public static boolean mainTestGraph4(String config, PrintStream out) {
        boolean success = false;
        boolean allSuccess = true;
        PrintStream stdout = System.out;
        System.setOut(out);
        System.out.println("Testing Indirectory reading business... ");
        success = Tester.testIndirectoryReading(true, config);
        System.out.format("...%s!\n", success ? "success" : "failed");
        allSuccess &= success;
        System.out.println("Testing Indirectory config business... ");
        success = Tester.testIndieFiltering(true, config);
        System.out.format("...%s!\n", success ? "success" : "failed");
        allSuccess &= success;
        System.out.println("Testing edge library IfConsistentCollapser... ");
        success = Tester.testEdgeLibraryCollapse(true, config);
        System.out.format("...%s!\n", success ? "success" : "failed");
        allSuccess &= success;
        System.out.println("Testing edge library IfConsistentCollapser with redirection... ");
        success = Tester.testEdgeLibraryRedirectCollapse(true, config);
        System.out.format("...%s!\n", success ? "success" : "failed");
        System.setOut(stdout);
        return allSuccess &= success;
    }

    public static boolean mainTestGraph3(String config, PrintStream out) {
        boolean success = false;
        boolean allSuccess = true;
        PrintStream stdout = System.out;
        System.setOut(out);
        System.out.println("Testing printing GAMS sets for node features.");
        success = Tester.testGAMSfeatures(true, config);
        System.out.format("...%s!\n", success ? "success" : "failed");
        System.setOut(stdout);
        return allSuccess &= success;
    }

    public static boolean mainTestGraph2(String config, PrintStream out) {
        boolean allSuccess = true;
        PrintStream stdout = System.out;
        System.setOut(out);
        System.out.println("Testing graph filtering based on graph features.");
        boolean success = Tester.testGraphFiltering(true, config);
        System.out.format("...%s!\n", success ? "success" : "failed");
        System.setOut(stdout);
        return allSuccess &= success;
    }

    public static boolean mainTestGraph1(String config, PrintStream out) {
        boolean allSuccess = true;
        PrintStream stdout = System.out;
        System.setOut(out);
        System.out.println("Testing the basic pathfinder.");
        boolean success = Tester.testBasicPathFinder(true, config);
        System.out.format("...%s!\n", success ? "success" : "failed");
        System.setOut(stdout);
        return allSuccess &= success;
    }

    public static boolean mainTestGraph0(String config, PrintStream out) {
        boolean allSuccess = true;
        PrintStream stdout = System.out;
        System.setOut(out);
        System.out.println("Testing building a graph.");
        boolean success = Tester.testBuildGraph(true, config);
        System.out.format("...%s!\n", success ? "success" : "failed");
        allSuccess &= success;
        System.out.println("Testing node filter managers. ");
        success = Tester.testNodeFilterManager(true, config);
        System.out.format("...%s!\n", success ? "success" : "failed");
        allSuccess &= success;
        System.out.println("Testing graph filtering. ");
        success = Tester.testNodeFilterGraph(true, config);
        System.out.format("...%s!\n", success ? "success" : "failed");
        allSuccess &= success;
        System.out.println("Testing config reading...");
        success = Tester.testConfigAndFeatureReading(true, config);
        System.out.format("...%s!\n", success ? "success" : "failed");
        allSuccess &= success;
        System.out.println("Testing library reading and combining...");
        success = Tester.testReadAndCombineEdgeLibraries(true, new String[][]{"EDGE_LIBRARY\ttest/test0.tab\thost\t0".split("\t"), "EDGE_LIBRARY\ttest/test1.tab\thost-virus\t0".split("\t"), "EDGE_LIBRARY\ttest/test01.tab\thost\t0".split("\t")});
        System.out.format("...%s!\n", success ? "success" : "failed");
        allSuccess &= success;
        System.out.println("Testing OrderedNode- and EqualsNodeFilters. ");
        success = Tester.testSimpleFilter(true, config);
        System.out.format("...%s!\n", success ? "success" : "failed");
        System.setOut(stdout);
        return allSuccess &= success;
    }

    protected static void printPathAssociationFile(Configuration config, PathManager paths, GamsPrinter printer, PrintStream outStream) {
        outStream.format("#pid\tgene_ids\teids\tsubgraphs\n", new Object[0]);
        for (Path p : paths.allPaths()) {
            String pid = printer.gamsify(p);
            String elist = printer.edgeString(p);
            String nlist = printer.nodeString(p);
            ArrayList<String> slist = printer.gamsifyList(paths.getLabels(p));
            outStream.format("%s\t%s\t%s\t%s\n", pid, nlist, elist, StringUtils.join(slist, "|"));
        }
    }

    public static boolean testPairsBasic(boolean printMessage, String configFile) {
        Configuration config = null;
        Graph g = null;
        boolean success = false;
        try {
            config = Configuration.readConfigFile(configFile);
            g = config.buildGraph();
            success = true;
        }
        catch (Exception e) {
            if (printMessage) {
                System.out.println(e.getMessage());
                e.printStackTrace();
            }
            success = false;
            return false;
        }
        System.out.format("Read %d edges.\n%s\n", config.edgeLibrary().size(), config.edgeLibrary().toString());
        System.out.println(config.nodeLibrary().toString());
        PairDirectory stpairs = config.getPairDirectory("st_pairs");
        System.out.println(stpairs.toString());
        System.out.println(stpairs.tabFormat());
        PairDirectory srpairs = config.getPairDirectory("sr_pairs");
        System.out.println(srpairs.toString());
        System.out.println(srpairs.tabFormat());
        ArrayList<PathFinder> pfs = config.pathFinders();
        PathManager paths = new PathManager();
        try {
            for (PathFinder pf : pfs) {
                PathManager found = pf.findPaths(g);
                System.out.format("Applied %s: %d paths\n", pf.toString(), found.size());
                for (Path p : found.allPaths()) {
                    System.out.println("\t" + p);
                }
                paths.addAll(found);
            }
            System.out.format("Total: %d paths\n", paths.size());
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
        for (Path p : paths.allPaths()) {
            System.out.format("\t%s\t%s\n", p, paths.getLabels(p));
        }
        Graph pathGraph = PathManager.makeGraph(paths);
        GamsPrinter printer = new GamsPrinter(g, paths, config.nodeLibrary(), config.edgeLibrary());
        Tester.printPathAssociationFile(config, paths, printer, System.out);
        return success;
    }

    public static boolean testReaction(boolean printMessage, String configFile) {
        Configuration config = null;
        Graph g = null;
        boolean success = false;
        try {
            config = Configuration.readConfigFile(configFile);
            g = config.buildGraph();
            success = true;
        }
        catch (Exception e) {
            if (printMessage) {
                System.out.println(e.getMessage());
                e.printStackTrace();
            }
            success = false;
            return false;
        }
        ArrayList<PathFinder> pfs = config.pathFinders();
        PathManager paths = new PathManager();
        try {
            for (PathFinder pf : pfs) {
                PathManager found = pf.findPaths(g);
                System.out.format("Applied %s: %d paths\n", pf.toString(), found.size());
                paths.addAll(found);
            }
            System.out.format("Total: %d paths\n", paths.size());
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
        Graph gPaths = PathManager.makeGraph(paths);
        for (Subgraph sg : config.subgraphs().values()) {
            Collection<Edge> edges = PathManager.filterEdges(paths, sg.edges(), config.subgraphAddModes().get(sg.name()));
            gPaths.addAll(edges);
        }
        System.out.format("Paths and subgraphs contain %d nodes and %d edges.\n", g.nodes().size(), g.edges().size());
        GamsPrinter printer = new GamsPrinter(g, paths, config.nodeLibrary(), config.edgeLibrary(), config.subgraphs());
        printer.printNodeSets(System.out);
        printer.printEdgeSets(System.out, true);
        printer.printPathSets(System.out);
        printer.printSubgraphSets(System.out, config.subgraphAddModes());
        return success;
    }

    public static boolean testEdgeLibraryCollapseAndRedirectFromConfig(boolean printMessage, String configFile) {
        Configuration config = null;
        Graph g = null;
        boolean success = false;
        try {
            config = Configuration.readConfigFile(configFile);
            g = config.buildGraph();
            success = true;
        }
        catch (Exception e) {
            if (printMessage) {
                System.out.println(e.getMessage());
                e.printStackTrace();
            }
            success = false;
            return false;
        }
        EdgeLibrary newLibe = config.edgeLibrary();
        if (printMessage) {
            ArrayList<Feature> feats = new ArrayList<Feature>(newLibe.features());
            ArrayList<String> fnames = new ArrayList<String>();
            for (Feature f : feats) {
                fnames.add(f.name());
            }
            System.out.format("\nedge\t%s\n", StringUtils.join(fnames, "\t"));
            for (Edge e : newLibe.items()) {
                System.out.format("%s", e);
                for (Feature f : feats) {
                    System.out.format("\t%s", newLibe.getValue(e, f));
                }
                System.out.println();
            }
        }
        return success;
    }

    public static boolean testEdgeLibraryRedirectCollapse(boolean printMessage, String configFile) {
        Configuration config = null;
        Graph g = null;
        boolean success = false;
        try {
            config = Configuration.readConfigFile(configFile);
            g = config.buildGraph();
            success = true;
        }
        catch (Exception e) {
            if (printMessage) {
                System.out.println(e.getMessage());
                e.printStackTrace();
            }
            success = false;
            return false;
        }
        IfConsistentCollapser redirect = new IfConsistentCollapser(new String[]{"redirect=(F)"});
        IfConsistentCollapser coll = new IfConsistentCollapser();
        IfConsistentCollapser[] ifConsistentCollapserArray = new IfConsistentCollapser[]{redirect, coll};
        int n = ifConsistentCollapserArray.length;
        int n2 = 0;
        while (n2 < n) {
            IfConsistentCollapser icc = ifConsistentCollapserArray[n2];
            if (printMessage) {
                System.out.println("\nTrying collapser " + icc.toString());
            }
            EdgeLibrary newLibe = config.edgeLibrary().collapse(icc);
            if (printMessage) {
                ArrayList<Feature> feats = new ArrayList<Feature>(newLibe.features());
                ArrayList<String> fnames = new ArrayList<String>();
                for (Feature f : feats) {
                    fnames.add(f.name());
                }
                System.out.format("edge\t%s\n", StringUtils.join(fnames, "\t"));
                for (Edge e : newLibe.items()) {
                    System.out.format("%s", e);
                    for (Feature f : feats) {
                        System.out.format("\t%s", newLibe.getValue(e, f));
                    }
                    System.out.println();
                }
            }
            ++n2;
        }
        return success;
    }

    public static boolean testEdgeLibraryCollapse(boolean printMessage, String configFile) {
        Configuration config = null;
        Graph g = null;
        boolean success = false;
        try {
            config = Configuration.readConfigFile(configFile);
            g = config.buildGraph();
            success = true;
        }
        catch (Exception e) {
            if (printMessage) {
                System.out.println(e.getMessage());
                e.printStackTrace();
            }
            success = false;
            return false;
        }
        IfConsistentCollapser coll = new IfConsistentCollapser();
        EdgeLibrary libe = config.edgeLibrary();
        HashMap<Edge, HashSet<Edge>> map = coll.collapse(libe);
        if (printMessage) {
            System.out.println();
            for (Edge e : map.keySet()) {
                System.out.format("%s\t%s\n", e, StringUtils.join((Collection)map.get(e), ", "));
            }
        }
        EdgeLibrary newLibe = config.edgeLibrary().collapse(coll);
        if (printMessage) {
            ArrayList<Feature> feats = new ArrayList<Feature>(newLibe.features());
            ArrayList<String> fnames = new ArrayList<String>();
            for (Feature f : feats) {
                fnames.add(f.name());
            }
            System.out.format("edge\t%s\n", StringUtils.join(fnames, "\t"));
            for (Edge e : newLibe.items()) {
                System.out.format("%s", e);
                for (Feature f : feats) {
                    System.out.format("\t%s", newLibe.getValue(e, f));
                }
                System.out.println();
            }
        }
        return success;
    }

    public static boolean testIndirectoryReading(boolean printMessage, String configFile) {
        boolean success = false;
        PairDirectory indie = null;
        try {
            indie = PairDirectory.readIndirectory("features/regulation_events_ge_5_pmids.tab", "whee");
        }
        catch (Exception e) {
            if (printMessage) {
                System.out.println(e.getMessage());
                e.printStackTrace();
            }
            success = false;
            return false;
        }
        if (printMessage) {
            System.out.format("Read real Indirectory file of %d ordered pairs (features/regulation_events_ge_5_pmids.tab).\n", indie.size());
        }
        return true;
    }

    public static boolean testIndieFiltering(boolean printMessage, String configFile) {
        Configuration config = null;
        Graph g = null;
        boolean success = false;
        try {
            config = Configuration.readConfigFile(configFile);
            g = config.buildGraph();
            success = true;
        }
        catch (Exception exception) {
            if (printMessage) {
                System.out.println(exception.getMessage());
                exception.printStackTrace();
            }
            success = false;
            return false;
        }
        if (printMessage) {
            System.out.println("Read indirectories:");
            for (Map.Entry entry : config.pairDirectories().entrySet()) {
                System.out.println("\t" + (String)entry.getKey() + "\t" + ((PairDirectory)entry.getValue()).size());
            }
        }
        if (printMessage) {
            System.out.println("Trying the indie-filtered pathfinders.");
        }
        for (PathFinder pathFinder : config.pathFinders()) {
            if (printMessage) {
                System.out.println("Testing:" + pathFinder.toString());
            }
            PathManager pm = pathFinder.findPaths(g);
            if (!printMessage) continue;
            System.out.println(StringUtils.sortJoin(pm.allPaths(), "\t\n"));
        }
        return success;
    }

    public static boolean testGAMSfeatures(boolean printMessage, String configFile) {
        Configuration config = null;
        Graph g = null;
        boolean success = false;
        try {
            config = Configuration.readConfigFile(configFile);
            g = config.buildGraph();
            success = true;
        }
        catch (Exception e) {
            if (printMessage) {
                System.out.println(e.getMessage());
                e.printStackTrace();
            }
            success = false;
            return false;
        }
        PathManager pm = new PathManager();
        for (PathFinder pf : config.pathFinders()) {
            pm.addAll(pf.findPaths(g));
        }
        Graph pathG = PathManager.makeGraph(pm);
        GamsPrinter printer = new GamsPrinter(g, pm, config.nodeLibrary(), config.edgeLibrary());
        printer.printNodeSets(System.out);
        printer.printEdgeSets(System.out, true);
        printer.printPathSets(System.out);
        return success;
    }

    public static boolean testGraphFiltering(boolean printMessage, String configFile) {
        Configuration config = null;
        Graph g = null;
        boolean success = false;
        try {
            config = Configuration.readConfigFile(configFile);
            g = Graph.createFromEdgeLibrary(config.edgeLibrary());
            success = true;
        }
        catch (Exception e) {
            if (printMessage) {
                System.out.println(e.getMessage());
                e.printStackTrace();
            }
            success = false;
            return false;
        }
        if (printMessage) {
            System.out.println("\nPrinting the graph filter managers:");
        }
        for (GraphNodeFilterManager man : config.graphFilterManagers().values()) {
            if (printMessage) {
                System.out.println(man.toString());
            }
            Graph filtered = man.filter(g);
            if (!printMessage) continue;
            System.out.format("\t\t%d nodes, %d edges\n", filtered.nodes().size(), filtered.edges().size());
            System.out.format("\t\tNodes: %s\n", StringUtils.sortJoin(filtered.nodes(), ", "));
            System.out.format("\t\tEdges: %s\n", StringUtils.sortJoin(filtered.edges(), ", "));
        }
        if (printMessage) {
            System.out.println("Getting the auto-filtered graph.");
        }
        try {
            Graph g2 = config.buildGraph();
            if (printMessage) {
                System.out.println(g2.graphNeighborStructure());
            }
            success = true;
        }
        catch (DuplicateException de) {
            if (printMessage) {
                System.out.println(de.getMessage());
                de.printStackTrace();
            }
            success = false;
            return false;
        }
        return success;
    }

    public static boolean testBasicPathFinder(boolean printMessage, String configFile) {
        Configuration config = null;
        Graph g = null;
        boolean success = false;
        try {
            config = Configuration.readConfigFile(configFile);
            g = Graph.createFromEdgeLibrary(config.edgeLibrary());
            success = true;
        }
        catch (Exception e) {
            if (printMessage) {
                System.out.println(e.getMessage());
                e.printStackTrace();
            }
            success = false;
            return false;
        }
        System.out.println("\nPrinting the filter managers:");
        for (NodeFilterManager mans : config.nodeFilterManagers().values()) {
            System.out.println(mans.toString());
            Graph filtered = mans.filter(g);
            System.out.format("\t\t%d nodes, %d edges\n", filtered.nodes().size(), filtered.edges().size());
        }
        System.out.println("Trying the basic pathfinder from start to end.");
        for (PathFinder pf : config.pathFinders()) {
            System.out.println("Testing:" + pf.toString());
            PathManager pm = pf.findPaths(g);
            System.out.println(StringUtils.sortJoin(pm.allPaths(), "\t\n"));
        }
        return success;
    }

    public static boolean testNodeFilterManager(boolean printMessage, String configFile) {
        Configuration config = null;
        Graph g = null;
        boolean success = true;
        try {
            config = Configuration.readConfigFile(configFile);
            g = Graph.createFromEdgeLibrary(config.edgeLibrary());
            success = true;
        }
        catch (Exception e) {
            if (printMessage) {
                System.out.println(e.getMessage());
            }
            success = false;
            return false;
        }
        Map<String, NodeFilterManager> mans = config.nodeFilterManagers();
        for (String man : mans.keySet()) {
            Graph filtered = null;
            NodeFilterManager manager = mans.get(man);
            filtered = manager.filter(g);
            HashSet<String> keep = new HashSet<String>(g.nodes());
            keep.retainAll(filtered.nodes());
            HashSet<String> lost = new HashSet<String>(g.nodes());
            lost.removeAll(filtered.nodes());
            if (printMessage) {
                System.out.format("Filtered graph (one at a time) with %s.\n", manager.name());
                System.out.format("\tKept: %s\n", StringUtils.sortJoin(keep, ", "));
                System.out.format("\tLost: %s\n", StringUtils.sortJoin(lost, ", "));
            }
            ArrayList<String> rnodes = new ArrayList<String>(g.nodes());
            int rand = RAND.nextInt(rnodes.size() - 1) + 1;
            HashSet<String> subnodes = new HashSet<String>(rnodes.subList(0, rand));
            boolean accept = manager.accept(subnodes);
            if (!printMessage) continue;
            System.out.format("Filtered set %s with %s=%s: %s\n", new Object[]{StringUtils.sortJoin(subnodes, ","), manager.name(), manager.setMode(), accept});
        }
        return success;
    }

    public static boolean testNodeFilterGraph(boolean printMessage, String configFile) {
        Configuration config = null;
        Graph g = null;
        boolean success = false;
        try {
            config = Configuration.readConfigFile(configFile);
            g = Graph.createFromEdgeLibrary(config.edgeLibrary());
            success = true;
        }
        catch (Exception e) {
            if (printMessage) {
                System.out.println(e.getMessage());
            }
            success = false;
            return false;
        }
        NodeLibrary libe = config.nodeLibrary();
        for (Filter filter : config.nodeFilters().values()) {
            Graph filtered = GraphUtils.filter(g, filter, libe);
            HashSet<String> keep = new HashSet<String>(g.nodes());
            keep.retainAll(filtered.nodes());
            HashSet<String> lost = new HashSet<String>(g.nodes());
            lost.removeAll(filtered.nodes());
            if (!printMessage) continue;
            System.out.format("Filtered graph with %s.\n", filter.name());
            System.out.format("\tKept: %s\n", StringUtils.sortJoin(keep, ", "));
            System.out.format("\tLost: %s\n", StringUtils.sortJoin(lost, ", "));
            System.out.format("\tRemaining edges: %d\n", filtered.edges().size());
        }
        try {
            Graph filterAnd = config.runNodeFilters(FilterManager.FilterItemMode.AND);
            Graph filterOr = config.runNodeFilters(FilterManager.FilterItemMode.OR);
            if (printMessage) {
                System.out.format("Filtered graph with all node filters: %d nodes\n\t%s\n", filterAnd.nodes().size(), StringUtils.sortJoin(filterAnd.nodes(), ", "));
                System.out.format("Filtered graph with any node filter: %d nodes\n\t%s\n", filterOr.nodes().size(), StringUtils.sortJoin(filterOr.nodes(), ", "));
            }
        }
        catch (Exception e) {
            if (printMessage) {
                System.out.println(e.getMessage());
            }
            return false;
        }
        return success;
    }

    public static boolean testBuildGraph(boolean printMessage, String configFile) {
        Configuration config = null;
        Graph g = null;
        boolean success = false;
        try {
            config = Configuration.readConfigFile(configFile);
            g = Graph.createFromEdgeLibrary(config.edgeLibrary());
            success = true;
        }
        catch (Exception e) {
            if (printMessage) {
                System.out.println(e.getMessage());
            }
            return false;
        }
        Graph g2 = g.copy();
        if (printMessage) {
            System.out.println("Testing neighbor info...");
        }
        String g1Str = g.graphNeighborStructure();
        String g2Str = g2.graphNeighborStructure();
        if (printMessage) {
            System.out.println(g1Str);
        }
        if (printMessage) {
            System.out.println(g2Str);
        }
        boolean copy = g1Str.equals(g2Str);
        if (printMessage) {
            System.out.println("Testing copy: " + copy);
        }
        if (!copy) {
            return false;
        }
        ArrayList<Edge> removed = new ArrayList<Edge>();
        ArrayList<String> nodes = new ArrayList<String>(g.nodes());
        Collections.sort(nodes);
        for (String n : nodes) {
            ArrayList<Edge> rem = new ArrayList<Edge>(g.remove(n));
            Collections.sort(rem);
            removed.addAll(rem);
            g1Str = g.graphNeighborStructure();
            if (printMessage) {
                System.out.println("Removed " + n + ", \n" + g1Str);
            }
            if (!(g2Str = g2.graphNeighborStructure()).equals(g1Str)) continue;
            success = false;
            if (printMessage) {
                System.out.println("Changed g1 caused change in g2.");
            }
            return false;
        }
        for (Edge e : removed) {
            g.add(e);
            g1Str = g.graphNeighborStructure();
            if (!printMessage) continue;
            System.out.println("Added edge " + e.toString() + ", \n" + g1Str);
        }
        if (printMessage) {
            System.out.println("Removing one edge at a time.");
        }
        int tot = g.edges().size();
        for (Edge e : g.edges()) {
            g.remove(e);
            if (g.edges().size() != tot - 1) {
                System.out.format("Tried to remove edge %s; removed %d edges.\n", e, tot - g.edges().size());
                success = false;
            }
            --tot;
        }
        return success;
    }

    public static boolean testSimpleFilter(boolean printMessage, String configFile) {
        Configuration config = null;
        Graph g = null;
        boolean success = false;
        try {
            config = Configuration.readConfigFile(configFile);
            g = Graph.createFromEdgeLibrary(config.edgeLibrary());
            success = true;
        }
        catch (Exception e) {
            if (printMessage) {
                System.out.println(e.getMessage());
            }
            return false;
        }
        NodeLibrary libe = config.nodeLibrary();
        ArrayList<Filter> filts = new ArrayList<Filter>();
        int filtCount = 0;
        for (Feature f : libe.features()) {
            if (f.type() == Value.Type.CONTINUOUS) {
                Value threshold = f.random();
                OrderedFilter onf = null;
                String name = String.format("rand_%d", filtCount);
                ++filtCount;
                try {
                    OrderedFilter.Order[] orderArray = OrderedFilter.Order.values();
                    int n = orderArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        OrderedFilter.Order o = orderArray[n2];
                        onf = OrderedFilter.makeFilter(name, f, false, threshold, o);
                        filts.add(onf);
                        ++n2;
                    }
                }
                catch (InvalidValueException ive) {
                    if (printMessage) {
                        System.out.println("You somehow failed to get a valid value using feature.random().");
                    }
                    return false;
                }
                catch (IncomparableException ie) {
                    if (printMessage) {
                        System.out.println("You somehow failed to choose a comparable feature.");
                    }
                    return false;
                }
            }
            Value[] randVals = f.random(5);
            String name = String.format("rand_%d", filtCount);
            ++filtCount;
            try {
                EqualsFilter efilt = EqualsFilter.makeFilter(name, f, false, randVals);
                filts.add(efilt);
            }
            catch (InvalidValueException ive) {
                if (printMessage) {
                    System.out.println("You somehow failed to get a valid value using feature.random(int).");
                }
                return false;
            }
        }
        String name = String.format("rand_%d", filtCount);
        ++filtCount;
        try {
            filts.add(OrderedFilter.makeFilter(name, ((Filter)filts.get(0)).feature(), false, Continuous.makeValue("0.25"), OrderedFilter.Order.EQUAL));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (printMessage) {
            System.out.println("Testing filters...");
        }
        if (printMessage) {
            System.out.format("Node\t%s\n", StringUtils.join(filts, "\t"));
        }
        ArrayList<String> nodes = new ArrayList<String>(g.nodes());
        Collections.sort(nodes);
        for (String n : nodes) {
            ArrayList<String> results = new ArrayList<String>();
            for (Filter filter : filts) {
                boolean accept = filter.accept(libe.getValue(n, filter.feature()));
                Value val = libe.getValue(n, filter.feature());
                if (val != null) {
                    results.add(String.format("%s=%s", val.toString(), accept));
                    continue;
                }
                results.add("--");
            }
            if (!printMessage) continue;
            System.out.format("%s\t%s\n", n, StringUtils.join(results, "\t"));
        }
        return success;
    }

    public static boolean testReadEdgeLibrary(boolean printMessage) {
        boolean success = false;
        String[] line = "EDGE_LIBRARY\tnetworks/human_id.tab\tnull\t1".split("\t");
        EdgeLibrary el = new EdgeLibrary();
        try {
            el = Configuration.readEdgeFile(null, line);
            List<String> filenames = el.getFilenames();
            String fns = StringUtils.sortJoin(filenames, ", ");
            if (printMessage) {
                System.out.format("Read %d edges from file(s) %s.\n", el.size(), fns);
                ArrayList edges = new ArrayList(el.items());
                Collections.sort(edges);
                for (Edge e : edges) {
                    System.out.format("\t%s\n", e);
                }
                ArrayList<Feature> feats = new ArrayList<Feature>(el.getFeatures());
                feats.remove(Feature.DEFAULT);
                System.out.format("Read %d features:", feats.size());
                Collections.sort(feats, new Comparator<Feature>(){

                    @Override
                    public int compare(Feature f1, Feature f2) {
                        return f1.toString().compareTo(f2.toString());
                    }
                });
                for (Feature f : feats) {
                    System.out.format("\n\t%s", f.name());
                }
            }
            success = true;
        }
        catch (Exception e) {
            if (printMessage) {
                System.out.println(e.getMessage());
            }
            success = false;
        }
        return success;
    }

    public static boolean testReadAndCombineEdgeLibraries(boolean printMessage, String[][] strings) {
        String fns;
        boolean success = false;
        EdgeLibrary[] els = new EdgeLibrary[strings.length];
        int i = 0;
        while (i < strings.length) {
            try {
                els[i] = Configuration.readEdgeFile(null, strings[i]);
                List<String> filenames = els[i].getFilenames();
                String fns2 = StringUtils.sortJoin(filenames, ", ");
                if (printMessage) {
                    System.out.format("Read %d edges from file(s) %s.\n", els[i].size(), fns2);
                    System.out.format("Read %d features:\n", els[i].getFeatures().size());
                    for (Feature f : els[i].getFeatures()) {
                        System.out.format("\t%s\n", f.toString());
                    }
                }
                success = true;
            }
            catch (Exception e) {
                if (printMessage) {
                    System.out.println(e.getMessage());
                }
                success = false;
                break;
            }
            ++i;
        }
        if (!success) {
            return success;
        }
        List<String> filenames = els[0].getFilenames();
        String prevFns = StringUtils.sortJoin(filenames, ", ");
        int i2 = 1;
        while (i2 < strings.length && success) {
            block13: {
                try {
                    els[0].addAll(els[i2]);
                    success = true;
                    if (printMessage) {
                        List<String> filenamesI = els[i2].getFilenames();
                        String fnsI = StringUtils.sortJoin(filenamesI, ", ");
                        filenames = els[0].getFilenames();
                        fns = StringUtils.sortJoin(filenames, ", ");
                        System.out.format("Combined libraries %s and %s.\n", prevFns, fnsI);
                        System.out.format("Result: %d edges, filenames %s\n", els[0].size(), fns);
                        prevFns = fns;
                    }
                }
                catch (EdgeLibrary.IncompatibleException ile) {
                    if (!printMessage) break block13;
                    System.out.println(ile.getMessage());
                    success = false;
                }
            }
            ++i2;
        }
        if (printMessage) {
            ArrayList elist = new ArrayList(els[0].items());
            Collections.sort(elist);
            for (Edge e : elist) {
                fns = StringUtils.sortJoin(els[0].getFilenames(e), ", ");
                System.out.format("%s\t%s\n", e.toString(), fns);
            }
        }
        return success;
    }

    public static boolean testConfigAndFeatureReading(boolean printMessage, String configFile) {
        Configuration config = null;
        boolean success = false;
        try {
            config = Configuration.readConfigFile(configFile);
            if (printMessage) {
                System.out.println(config.toString());
            }
            success = true;
        }
        catch (Exception e) {
            if (printMessage) {
                System.out.println(e.getMessage());
                e.printStackTrace();
            }
            success = false;
        }
        return success;
    }

    public static boolean testFeatureReading(boolean printMessage) {
        String line = "NFEATURE\treticulons\tdiscrete\treticulon_view\t\"reticulons and friends, host ER, viral transcription\"\tfeatures/reticulon_membrane_viral_transcription.tab\t\\t\t1";
        String[] split = line.trim().split("\t");
        Pair<Feature, Map<String, Value>> pair = null;
        boolean success = false;
        try {
            pair = Configuration.readNodeFeature(split);
            success = true;
        }
        catch (Exception e) {
            if (printMessage) {
                System.out.println(e.getMessage());
            }
            success = false;
        }
        Feature f = pair.first();
        Map<String, Value> vals = pair.second();
        if (printMessage) {
            System.out.println(f);
        }
        if (vals.keySet().size() != 1098) {
            success = false;
        }
        return success;
    }
}

