/*
 * Decompiled with CFR 0.152.
 */
package apps;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Set;
import pathfinders.PairPathFinder;
import pathfinders.PathFinder;
import structures.Configuration;
import structures.Graph;
import structures.NodeLibrary;
import structures.Path;
import structures.PathManager;
import utilities.CytoscapePrinter;
import utilities.GamsPrinter;
import utilities.StringUtils;

public class T4AMain {
    public static void main(String[] args) {
        String pathFn;
        block20: {
            Configuration config = null;
            Graph g = null;
            try {
                config = Configuration.readConfigFile(args[0]);
                g = config.buildGraph();
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
                e.printStackTrace();
                return;
            }
            System.out.format("Read %d edges.\n%s\n", config.edgeLibrary().size(), config.edgeLibrary().toString());
            System.out.println(config.nodeLibrary().toString());
            Graph gOrig = g.copy();
            NodeLibrary nl = config.nodeLibrary();
            Set pols = config.nodeLibrary().get(nl.getFeature("pol2"));
            for (String p : pols) {
                g.remove(p);
            }
            ArrayList<PathFinder> pfs = config.pathFinders();
            PathManager paths = new PathManager();
            try {
                for (PathFinder pf : pfs) {
                    PathManager found = null;
                    found = pf instanceof PairPathFinder ? pf.findPathsIterative(g, 2, 0.5) : pf.findPaths(g);
                    System.out.format("Applied pathfinder %s: found %d paths\n", pf.toString(), found.size());
                    if (found == null) continue;
                    paths.addAll(found);
                }
                System.out.format("Total found: %d paths\n", paths.size());
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
                e.printStackTrace();
            }
            boolean cleanMode = config.getGamsLabelMode() == GamsPrinter.LabelMode.STRIP;
            Graph gPathsOnly = PathManager.makeGraph(paths);
            GamsPrinter printer = new GamsPrinter(g, paths, config.nodeLibrary(), config.edgeLibrary());
            CytoscapePrinter.printSif(gPathsOnly, String.format("%s_paths.sif", config.getOutputPrefix()), cleanMode);
            CytoscapePrinter.printSif(g, String.format("%s_background.sif", config.getOutputPrefix()), cleanMode);
            CytoscapePrinter.printNodeFeatures(config.nodeLibrary(), String.format("%s_node_feats.tab", config.getOutputPrefix()), cleanMode);
            CytoscapePrinter.printEdgeFeatures(config.edgeLibrary(), String.format("%s_edge_feats.tab", config.getOutputPrefix()), cleanMode);
            System.out.println("Wrote Cytoscape files: " + config.getOutputPrefix());
            boolean cytoV3Format = true;
            CytoscapePrinter.printEdgeAttribute("gamsId", printer.getEdgeIDs(), String.format("%s_gamsId.edge", config.getOutputPrefix()), cytoV3Format, cleanMode);
            String gamsPref = config.getGamsFileName();
            String gamsFn = String.format("%s.gms", gamsPref);
            if (gamsFn != null) {
                PrintStream gamsStream = null;
                if (gamsFn.equals("System.out")) {
                    gamsStream = System.out;
                } else {
                    try {
                        gamsStream = new PrintStream(new File(gamsFn));
                    }
                    catch (IOException ioe) {
                        System.out.println("Unable to print gams file to " + gamsFn);
                    }
                }
                String[] nfeats = config.getGamsNodeFeatureNames();
                if (nfeats != null) {
                    printer.printNodeSets(gamsStream, nfeats);
                } else {
                    printer.printNodeSets(gamsStream);
                }
                String[] efeats = config.getGamsEdgeFeatureNames();
                if (efeats != null) {
                    printer.printEdgeSets(gamsStream, efeats, true);
                } else {
                    printer.printEdgeSets(gamsStream);
                }
                printer.printPathSets(gamsStream);
            }
            System.out.println("Wrote GAMS file to " + gamsFn);
            pathFn = String.format("%s_paths.tab", gamsPref);
            PrintStream pathStream = null;
            try {
                try {
                    pathStream = new PrintStream(new File(pathFn));
                    System.out.println("Opened new path file " + pathFn);
                    T4AMain.printPathAssociationFile(config, paths, printer, pathStream);
                }
                catch (IOException ioe) {
                    System.err.println("Unable to print paths to " + pathFn);
                    pathStream.close();
                    break block20;
                }
            }
            catch (Throwable throwable) {
                pathStream.close();
                throw throwable;
            }
            pathStream.close();
        }
        System.out.format("Printed path strings to %s\n", pathFn);
    }

    protected static void printPathAssociationFile(Configuration config, PathManager paths, GamsPrinter printer, PrintStream outStream) {
        outStream.format("#pid\tgene_ids\teids\tsubgraphs\n", new Object[0]);
        for (Path p : paths.allPaths()) {
            String pid = printer.gamsify(p);
            String elist = printer.edgeString(p);
            String nlist = printer.nodeString(p);
            ArrayList<String> slist = printer.gamsifyList(paths.getLabels(p));
            outStream.format("%s\t%s\t%s\t%s\n", pid, nlist, elist, StringUtils.join(slist, "|"));
        }
    }
}

