/*
 * Decompiled with CFR 0.152.
 */
package apps;

import java.util.ArrayList;
import java.util.Collection;
import pathfinders.PathFinder;
import structures.Configuration;
import structures.Edge;
import structures.Graph;
import structures.PathManager;
import structures.Subgraph;
import utilities.GamsPrinter;

public class RxnTester {
    public static void main(String[] args) {
        Configuration config = null;
        Graph g = null;
        try {
            config = Configuration.readConfigFile(args[0]);
            g = config.buildGraph();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
            return;
        }
        ArrayList<PathFinder> pfs = config.pathFinders();
        PathManager paths = new PathManager();
        try {
            for (PathFinder pf : pfs) {
                PathManager found = pf.findPaths(g);
                System.out.format("Applied %s: %d paths\n", pf.toString(), found.size());
                paths.addAll(found);
            }
            System.out.format("Total: %d paths\n", paths.size());
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
        Graph gPaths = PathManager.makeGraph(paths);
        for (Subgraph sg : config.subgraphs().values()) {
            Collection<Edge> edges = PathManager.filterEdges(paths, sg.edges(), config.subgraphAddModes().get(sg.name()));
            gPaths.addAll(edges);
        }
        System.out.format("Paths and subgraphs contain %d nodes and %d edges.\n", g.nodes().size(), g.edges().size());
        GamsPrinter printer = new GamsPrinter(g, paths, config.nodeLibrary(), config.edgeLibrary(), config.subgraphs());
        printer.printNodeSets(System.out);
        printer.printEdgeSets(System.out);
        printer.printPathSets(System.out);
        printer.printSubgraphSets(System.out, config.subgraphAddModes());
    }
}

