/*
 * Decompiled with CFR 0.152.
 */
package apps;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import pathfinders.PathFinder;
import structures.Configuration;
import structures.Edge;
import structures.Graph;
import structures.NodeLibrary;
import structures.PathManager;
import structures.Subgraph;
import utilities.CytoscapePrinter;
import utilities.GamsPrinter;
import utilities.GenUtils;
import utilities.GraphUtils;

public class MakeSampledGams {
    public static final boolean DO_PATHFINDING = true;

    public static void main(String[] args) {
        Configuration config = null;
        Graph g = null;
        Graph gOrig = null;
        try {
            config = Configuration.readConfigFile(args[0]);
            g = config.buildGraph();
            gOrig = Graph.createFromEdgeLibrary(config.edgeLibrary());
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            return;
        }
        gOrig = gOrig.removeSelfLoops();
        gOrig = gOrig.removeEdgeless();
        g = g.removeEdgeless();
        g = g.removeSelfLoops();
        NodeLibrary libe = config.nodeLibrary();
        System.out.format("Read graph with %d nodes and %d edges.\n", gOrig.nodes().size(), gOrig.edges().size());
        System.out.format("Auto-filtered to graph with %d nodes and %d edges.\n", g.nodes().size(), g.edges().size());
        Set<String> interfaces = GraphUtils.request(g, libe, libe.getFeature("pinterface"));
        Set<String> hits = GraphUtils.request(g, libe, libe.getFeature("rnai"));
        System.out.format("\tGraph has %d hits, %d interfaces.\n", hits.size(), interfaces.size());
        ArrayList<PathFinder> pfs = config.pathFinders();
        PathManager paths = new PathManager();
        try {
            for (PathFinder pf : pfs) {
                PathManager found = pf.findPaths(g);
                System.out.format("Applied %s: %d paths\n", pf.toString(), found.size());
                paths.addAll(found);
            }
            System.out.format("Total: %d paths\n", paths.size());
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
        g = PathManager.makeGraph(paths);
        for (Subgraph sg : config.subgraphs().values()) {
            Collection<Edge> edges = PathManager.filterEdges(paths, sg.edges(), config.subgraphAddModes().get(sg.name()));
            g.addAll(edges);
        }
        System.out.format("Paths and subgraphs contain %d nodes and %d edges.\n", g.nodes().size(), g.edges().size());
        interfaces = GraphUtils.request(g, libe, libe.getFeature("pinterface"));
        hits = GraphUtils.request(g, libe, libe.getFeature("rnai"));
        System.out.format("\tPaths contain %d hits, %d interfaces.\n", hits.size(), interfaces.size());
        boolean cleanMode = config.getGamsLabelMode() == GamsPrinter.LabelMode.STRIP;
        CytoscapePrinter.printSif(g, String.format("%s_paths.sif", config.getOutputPrefix()), cleanMode);
        CytoscapePrinter.printSif(gOrig, String.format("%s_background.sif", config.getOutputPrefix()), cleanMode);
        CytoscapePrinter.printNodeFeatures(libe, String.format("%s_node_feats.tab", config.getOutputPrefix()), cleanMode);
        CytoscapePrinter.printEdgeFeatures(config.edgeLibrary(), String.format("%s_edge_feats.tab", config.getOutputPrefix()), cleanMode);
        System.out.println("Wrote Cytoscape files: " + config.getOutputPrefix());
        GamsPrinter printer = new GamsPrinter(gOrig, paths, config.nodeLibrary(), config.edgeLibrary(), config.subgraphs());
        boolean cytoV3Format = false;
        CytoscapePrinter.printEdgeAttribute("gamsId", printer.getEdgeIDs(), String.format("%s_gamsId.edge", config.getOutputPrefix()), cytoV3Format, cleanMode);
        String gamsPref = config.getGamsFileName();
        if (gamsPref == null || gamsPref.equals("System.out")) {
            System.err.println("Sorry, stdout is not an option for the sampler. Please specify a gams prefix.");
            return;
        }
        File hideDir = new File(config.getHiddenHitDirectory());
        String[] files = hideDir.list();
        int count = 0;
        String[] stringArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            block17: {
                String fn = stringArray[n2];
                if (fn.endsWith(".tab")) {
                    File from = new File(fn);
                    String info = from.getName().replace("_hits_hide.tab", "");
                    String gamsFn = String.format("%s_%s.gms", gamsPref, info);
                    File to = new File(gamsFn);
                    if (to.exists()) {
                        System.out.format("Found existing file %s; skipping this job.\n", gamsFn);
                    } else {
                        Set<String> hidden = null;
                        try {
                            hidden = GenUtils.readFileSet(String.format("%s%s%s", hideDir.getAbsolutePath(), File.separator, fn), "#");
                        }
                        catch (FileNotFoundException fnfe) {
                            System.err.println(fnfe.getMessage());
                            break block17;
                        }
                        System.out.format("Read %d hits to hold aside from %s.\n", hidden.size(), fn);
                        HashSet<String> actualAside = new HashSet<String>();
                        for (String h : hidden) {
                            if (!paths.contains(h)) continue;
                            actualAside.add(h);
                        }
                        System.out.format("%d held-aside hits in paths.\n", actualAside.size());
                        if (actualAside.size() >= 1) {
                            PrintStream gamsStream = null;
                            try {
                                gamsStream = new PrintStream(new File(gamsFn));
                                System.out.println("Opened new gams file " + gamsFn);
                            }
                            catch (IOException ioe) {
                                System.err.println("Unable to print gams file to " + gamsFn);
                            }
                            printer.printNodeSets(gamsStream);
                            String[] efeats = new String[]{"organism", "etype", "inComplexEdge"};
                            printer.printEdgeSets(gamsStream, efeats, false);
                            printer.printPathSets(gamsStream, false, hidden);
                            PathManager reduced = paths.reduce(hidden, "hostvirusPM");
                            printer.printSubgraphSets(gamsStream, config.subgraphAddModes(), reduced);
                        }
                    }
                }
            }
            ++n2;
        }
        System.out.format("Wrote %d GAMS files with prefix %s.\n", count, config.getGamsFileName());
    }
}

