/*
 * Decompiled with CFR 0.152.
 */
package apps;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import pathfinders.PathFinder;
import structures.Configuration;
import structures.Edge;
import structures.Graph;
import structures.NodeLibrary;
import structures.Path;
import structures.PathManager;
import structures.Subgraph;
import utilities.CytoscapePrinter;
import utilities.GamsPrinter;
import utilities.GraphUtils;
import utilities.StringUtils;

public class MakeGamsSamplerMaster {
    public static final boolean DO_PATHFINDING = false;

    public static void main(String[] args) {
        Configuration config = null;
        Graph g = null;
        Graph gOrig = null;
        try {
            config = Configuration.readConfigFile(args[0]);
            g = config.buildGraph();
            gOrig = Graph.createFromEdgeLibrary(config.edgeLibrary());
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            return;
        }
        gOrig = gOrig.removeSelfLoops();
        gOrig = gOrig.removeEdgeless();
        g = g.removeEdgeless();
        g = g.removeSelfLoops();
        NodeLibrary libe = config.nodeLibrary();
        System.out.format("Read graph with %d nodes and %d edges.\n", gOrig.nodes().size(), gOrig.edges().size());
        int dir = 0;
        for (Edge e : gOrig.edges()) {
            if (!e.isDirected()) continue;
            ++dir;
        }
        System.out.format("Graph has %d directed edges.\n", dir);
        System.out.format("Auto-filtered to graph with %d nodes and %d edges.\n", g.nodes().size(), g.edges().size());
        Set<String> interfaces = GraphUtils.request(g, libe, libe.getFeature("pinterface"));
        Set<String> hits = GraphUtils.request(g, libe, libe.getFeature("rnai"));
        System.out.format("\tGraph has %d hits, %d interfaces.\n", hits.size(), interfaces.size());
        ArrayList<PathFinder> pfs = config.pathFinders();
        PathManager paths = new PathManager();
        interfaces = GraphUtils.request(g, libe, libe.getFeature("pinterface"));
        hits = GraphUtils.request(g, libe, libe.getFeature("rnai"));
        System.out.format("\tPaths contain %d hits, %d interfaces.\n", hits.size(), interfaces.size());
        boolean cleanMode = config.getGamsLabelMode() == GamsPrinter.LabelMode.STRIP;
        CytoscapePrinter.printSif(gOrig, String.format("%s_background.sif", config.getOutputPrefix()), cleanMode);
        CytoscapePrinter.printNodeFeatures(libe, String.format("%s_node_feats.tab", config.getOutputPrefix()), cleanMode);
        CytoscapePrinter.printEdgeFeatures(config.edgeLibrary(), String.format("%s_edge_feats.tab", config.getOutputPrefix()), cleanMode);
        System.out.println("Wrote Cytoscape files: " + config.getOutputPrefix());
        GamsPrinter printer = new GamsPrinter(gOrig, paths, config.nodeLibrary(), config.edgeLibrary(), config.subgraphs());
        boolean cytoV3Format = false;
        CytoscapePrinter.printEdgeAttribute("gamsId", printer.getEdgeIDs(), String.format("%s_gamsId.edge", config.getOutputPrefix()), cytoV3Format, cleanMode);
        String gamsPref = config.getGamsFileName();
        if (gamsPref == null || gamsPref.equals("System.out")) {
            System.err.println("Sorry, stdout is not an option for printing. Please specify a GAMS file prefix.");
            return;
        }
        String masterFn = String.format("%s_master.gms", gamsPref);
        PrintStream gamsStream = null;
        try {
            gamsStream = new PrintStream(new File(masterFn));
            System.out.println("Opened new master gams file " + masterFn);
        }
        catch (IOException ioe) {
            System.err.println("Unable to print master gams file to " + masterFn);
        }
        printer.printNodeSets(gamsStream);
        String[] efeats = new String[]{"organism", "etype", "inComplexEdge"};
        printer.printEdgeSets(gamsStream, efeats, false);
        String pathFn = String.format("%s_master_paths.tab", gamsPref);
        PrintStream pathStream = null;
        try {
            pathStream = new PrintStream(new File(pathFn));
            System.out.println("Opened new master path file " + pathFn);
        }
        catch (IOException ioe) {
            System.err.println("Unable to print master path file to " + pathFn);
        }
        MakeGamsSamplerMaster.printPathAssociationFile(config, paths, printer, pathStream);
        String subFn = String.format("%s_master_subgraphs.tab", gamsPref);
        PrintStream subStream = null;
        try {
            subStream = new PrintStream(new File(subFn));
            System.out.println("Opened new master path file " + subFn);
        }
        catch (IOException ioe) {
            System.err.println("Unable to print master path file to " + subFn);
        }
        MakeGamsSamplerMaster.printSubgraphFile(config, paths, printer, subStream);
    }

    protected static void printPathAssociationFile(Configuration config, PathManager paths, GamsPrinter printer, PrintStream outStream) {
        outStream.format("#pid\tstart\tend\tgene_ids\teids\tsubgraphs\n", new Object[0]);
        for (Path p : paths.allPaths()) {
            String pid = printer.gamsify(p);
            String start = p.getNode(0);
            String end = p.getNode(-1);
            ArrayList<String> elist = printer.gamsifyList(p.edges());
            ArrayList<String> nlist = printer.gamsifyList(p.nodes());
            ArrayList<String> slist = printer.gamsifyList(paths.getLabels(p));
            outStream.format("%s\t%s\t%s\t%s\t%s\n", pid, start, end, StringUtils.join(nlist, "|"), StringUtils.join(elist, "|"), StringUtils.join(slist, "|"));
        }
    }

    protected static void printSubgraphFile(Configuration config, PathManager paths, GamsPrinter printer, PrintStream outStream) {
        HashMap subgraphEdges = new HashMap();
        HashMap subgraphNodes = new HashMap();
        HashMap subgraphs = new HashMap();
        for (Subgraph sg : config.subgraphs().values()) {
            HashMap<Path, HashSet<Edge>> sedge = PathManager.filterSubgraphEdgesByPath(paths, sg.edges(), config.subgraphAddModes().get(sg.name()));
            for (Path path : sedge.keySet()) {
                String pid = printer.gamsify(path);
                if (!subgraphs.containsKey(pid)) {
                    subgraphs.put(pid, new HashSet());
                }
                ((HashSet)subgraphs.get(pid)).add(sg.name());
            }
            for (Map.Entry entry : sedge.entrySet()) {
                Path p = (Path)entry.getKey();
                String pid = printer.gamsify(p);
                for (Edge e : (HashSet)entry.getValue()) {
                    if (!subgraphEdges.containsKey(pid) || !subgraphNodes.containsKey(pid)) {
                        subgraphEdges.put(pid, new HashSet());
                        subgraphNodes.put(pid, new HashSet());
                    }
                    ((HashSet)subgraphEdges.get(pid)).add(printer.gamsify(e));
                    ((HashSet)subgraphNodes.get(pid)).addAll(printer.gamsifySet(e.nodes()));
                }
            }
        }
        ArrayList pids = new ArrayList(subgraphs.keySet());
        Collections.sort(pids);
        outStream.format("#pid\teids\tgene_ids\tsubgraphs\n", new Object[0]);
        for (String pid : pids) {
            String string = StringUtils.join((Collection)subgraphEdges.get(pid), "|");
            String nids = StringUtils.join((Collection)subgraphNodes.get(pid), "|");
            String sids = StringUtils.join((Collection)subgraphs.get(pid), "|");
            outStream.format("%s\t%s\t%s\t%s\n", pid, string, nids, sids);
        }
    }
}

