/*
 * Decompiled with CFR 0.152.
 */
package apps;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import pathfinders.PathFinder;
import structures.Configuration;
import structures.Edge;
import structures.EdgeLibrary;
import structures.Graph;
import structures.NodeLibrary;
import structures.Path;
import structures.PathManager;
import structures.Subgraph;
import utilities.CytoscapePrinter;
import utilities.GamsPrinter;
import utilities.StringUtils;

public class InfluenzaMain {
    public static final boolean DO_PATHFINDING = true;

    public static void main(String[] args) {
        String pathFn;
        block18: {
            String gamsFn;
            GamsPrinter printer;
            boolean cleanMode;
            PathManager paths;
            String gamsPref;
            Configuration config;
            block16: {
                config = null;
                Graph g = null;
                Graph gOrig = null;
                try {
                    config = Configuration.readConfigFile(args[0]);
                    g = config.buildGraph();
                    gOrig = config.buildGraph();
                }
                catch (Exception e) {
                    System.err.println(e.getMessage());
                    e.printStackTrace();
                    return;
                }
                gamsPref = config.getGamsFileName();
                if (gamsPref == null || gamsPref.equals("System.out")) {
                    System.err.println("Sorry, stdout is not an option for the sampler. Please specify a gams prefix.");
                    return;
                }
                gOrig = gOrig.removeSelfLoops();
                gOrig = gOrig.removeEdgeless();
                g = g.removeEdgeless();
                g = g.removeSelfLoops();
                NodeLibrary libe = config.nodeLibrary();
                EdgeLibrary elibe = config.edgeLibrary();
                System.out.println(libe.toString());
                System.out.println(elibe.toString());
                System.out.format("Read graph with %d nodes and %d edges.\n", gOrig.nodes().size(), gOrig.edges().size());
                System.out.format("Auto-filtered to graph with %d nodes and %d edges.\n", g.nodes().size(), g.edges().size());
                System.out.println("Summary of background network:");
                System.out.println(libe.summarize(g.nodes()));
                System.out.println(elibe.summarize(g.edges()));
                ArrayList<PathFinder> pfs = config.pathFinders();
                paths = new PathManager();
                try {
                    for (PathFinder pf : pfs) {
                        PathManager found = pf.findPaths(g);
                        System.out.format("Applied %s: %d paths\n", pf.toString(), found.size());
                        paths.addAll(found);
                    }
                    System.out.format("Total: %d paths\n", paths.size());
                }
                catch (Exception e) {
                    System.err.println(e.getMessage());
                    e.printStackTrace();
                }
                g = PathManager.makeGraph(paths);
                for (Subgraph sg : config.subgraphs().values()) {
                    Collection<Edge> edges = PathManager.filterEdges(paths, sg.edges(), config.subgraphAddModes().get(sg.name()));
                    g.addAll(edges);
                }
                System.out.format("Paths and subgraphs contain %d nodes and %d edges.\n", g.nodes().size(), g.edges().size());
                System.out.println(libe.summarize(g.nodes()));
                System.out.println(elibe.summarize(g.edges()));
                cleanMode = config.getGamsLabelMode() == GamsPrinter.LabelMode.STRIP;
                CytoscapePrinter.printSif(paths, String.format("%s_paths.sif", config.getOutputPrefix()), cleanMode);
                CytoscapePrinter.printSif(gOrig, String.format("%s_background.sif", config.getOutputPrefix()), cleanMode);
                CytoscapePrinter.printNodeFeatures(libe, String.format("%s_node_feats.tab", config.getOutputPrefix()), cleanMode);
                CytoscapePrinter.printEdgeFeatures(config.edgeLibrary(), String.format("%s_edge_feats.tab", config.getOutputPrefix()), cleanMode);
                System.out.println("Wrote Cytoscape files: " + config.getOutputPrefix());
                printer = new GamsPrinter(g, gOrig, paths, config.nodeLibrary(), config.edgeLibrary(), config.subgraphs(), config.pairDirectories());
                printer.setLabelMode(config.getGamsLabelMode());
                boolean cytoV3Format = false;
                CytoscapePrinter.printEdgeAttribute("gamsId", printer.getEdgeIDs(), String.format("%s_gamsId.edge", config.getOutputPrefix()), cytoV3Format, cleanMode);
                gamsFn = String.format("%s.gms", gamsPref);
                PrintStream gamsStream = null;
                try {
                    try {
                        gamsStream = new PrintStream(new File(gamsFn));
                        System.out.println("Opened new gams file " + gamsFn);
                        printer.printNodeSets(gamsStream);
                        String[] efeats = new String[]{"reg", "etype"};
                        printer.printEdgeSets(gamsStream, efeats, false);
                        printer.printPathSets(gamsStream, true);
                        printer.printPairSets(gamsStream, false);
                    }
                    catch (IOException ioe) {
                        System.err.println("Unable to print gams file to " + gamsFn);
                        gamsStream.close();
                        break block16;
                    }
                }
                catch (Throwable throwable) {
                    gamsStream.close();
                    throw throwable;
                }
                gamsStream.close();
            }
            System.out.format("Created GAMS output file %s\n", gamsFn);
            pathFn = String.format("%s_paths.tab", gamsPref);
            PrintStream pathStream = null;
            try {
                try {
                    pathStream = new PrintStream(new File(pathFn));
                    System.out.println("Opened new path file " + pathFn);
                    InfluenzaMain.printPathAssociationFile(config, paths, printer, pathStream, cleanMode);
                }
                catch (IOException ioe) {
                    System.err.println("Unable to print paths to " + pathFn);
                    pathStream.close();
                    break block18;
                }
            }
            catch (Throwable throwable) {
                pathStream.close();
                throw throwable;
            }
            pathStream.close();
        }
        System.out.format("Printed path strings to %s\n", pathFn);
    }

    protected static void printPathAssociationFile(Configuration config, PathManager paths, GamsPrinter printer, PrintStream outStream, boolean cleanMode) {
        outStream.format("#pid\tgene_ids\teids\tpathfinders\tsif_edges\n", new Object[0]);
        for (Path p : paths.allPaths()) {
            String pid = printer.gamsify(p);
            String elist = printer.edgeString(p);
            String nlist = printer.nodeString(p);
            ArrayList<String> slist = printer.gamsifyList(paths.getLabels(p));
            List<String> edgeSifs = CytoscapePrinter.edgeSifs(p, cleanMode);
            outStream.format("%s\t%s\t%s\t%s\t%s\n", pid, nlist, elist, StringUtils.join(slist, "|"), StringUtils.join(edgeSifs, "|"));
        }
    }
}

