/*
 * Decompiled with CFR 0.152.
 */
package apps;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import pathfinders.PathFinder;
import structures.Configuration;
import structures.Edge;
import structures.EdgeLibrary;
import structures.Graph;
import structures.NodeLibrary;
import structures.Path;
import structures.PathManager;
import structures.Subgraph;
import utilities.CytoscapePrinter;
import utilities.GamsPrinter;
import utilities.GraphUtils;
import utilities.StringUtils;

public class HIVMain {
    public static boolean DO_PATHFINDING = true;

    public static void main(String[] args) {
        boolean cleanMode;
        Configuration config = null;
        Graph g = null;
        try {
            config = Configuration.readConfigFile(args[0]);
            g = config.buildGraph();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
            return;
        }
        g = g.removeSelfLoops();
        g = g.removeEdgeless();
        NodeLibrary libe = config.nodeLibrary();
        EdgeLibrary elibe = config.edgeLibrary();
        System.out.println(libe.toString());
        System.out.println(elibe.toString());
        System.out.format("Read graph with %d nodes and %d edges (after any node-based filtering specified in config).\n", g.nodes().size(), g.edges().size());
        Graph hostOnly = g.copy();
        Set hiv_genes = libe.get(libe.getFeature("hiv_genes"));
        for (String s : hiv_genes) {
            hostOnly.remove(s);
        }
        for (String s : libe.get(libe.getFeature("complex"))) {
            hostOnly.remove(s);
        }
        hostOnly = hostOnly.removeEdgeless();
        System.out.format("Background network consisting of only host proteins (not complexes, not HIV) contains %d connected nodes and %d edges.\n", hiv_genes.size(), hostOnly.nodes().size(), hostOnly.edges().size());
        int dir = 0;
        for (Edge e : g.edges()) {
            if (!e.isDirected()) continue;
            ++dir;
        }
        System.out.format("Graph has %d directed edges.\n", dir);
        System.out.format("Auto-filtered to graph with %d nodes and %d edges.\n", g.nodes().size(), g.edges().size());
        Set<String> interfaces = GraphUtils.request(g, libe, libe.getFeature("pinterface"));
        Set<String> hits = GraphUtils.request(g, libe, libe.getFeature("rnai"));
        System.out.format("\tGraph has %d hits, %d interfaces.\n", hits.size(), interfaces.size());
        ArrayList<PathFinder> pfs = config.pathFinders();
        PathManager paths = new PathManager();
        Graph gPaths = null;
        if (DO_PATHFINDING) {
            try {
                for (PathFinder pf : pfs) {
                    PathManager found = pf.findPaths(g);
                    System.out.format("Applied %s: %d paths\n", pf.toString(), found.size());
                    paths.addAll(found);
                }
                System.out.format("Total: %d paths\n", paths.size());
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
                e.printStackTrace();
            }
            gPaths = PathManager.makeGraph(paths);
            for (Subgraph sg : config.subgraphs().values()) {
                Collection<Edge> edges = PathManager.filterEdges(paths, sg.edges(), config.subgraphAddModes().get(sg.name()));
                gPaths.addAll(edges);
            }
            System.out.format("Paths and subgraphs contain %d nodes and %d edges.\n", gPaths.nodes().size(), gPaths.edges().size());
        }
        interfaces = GraphUtils.request(gPaths, libe, libe.getFeature("pinterface"));
        hits = GraphUtils.request(gPaths, libe, libe.getFeature("rnai"));
        System.out.format("\tPaths contain %d hits, %d interfaces.\n", hits.size(), interfaces.size());
        boolean bl = cleanMode = config.getGamsLabelMode() == GamsPrinter.LabelMode.STRIP;
        if (DO_PATHFINDING) {
            CytoscapePrinter.printSif(gPaths, String.format("%s_paths.sif", config.getOutputPrefix()), cleanMode);
        }
        CytoscapePrinter.printSif(g, String.format("%s_background.sif", config.getOutputPrefix()), cleanMode);
        CytoscapePrinter.printSif(hostOnly, String.format("%s_background_no_hiv_cx.sif", config.getOutputPrefix()), cleanMode);
        CytoscapePrinter.printNodeFeatures(libe, String.format("%s_node_feats.tab", config.getOutputPrefix()), cleanMode);
        CytoscapePrinter.printEdgeFeatures(config.edgeLibrary(), String.format("%s_edge_feats.tab", config.getOutputPrefix()), cleanMode);
        System.out.println("Wrote Cytoscape files: " + config.getOutputPrefix());
        GamsPrinter printer = new GamsPrinter(g, paths, config.nodeLibrary(), config.edgeLibrary(), config.subgraphs());
        boolean cytoV3Format = false;
        CytoscapePrinter.printEdgeAttribute("gamsId", printer.getEdgeIDs(), String.format("%s_gamsId.edge", config.getOutputPrefix()), cytoV3Format, cleanMode);
        String gamsPref = config.getGamsFileName();
        if (gamsPref == null || gamsPref.equals("System.out")) {
            System.err.println("Sorry, stdout is not an option for printing. Please specify a GAMS file prefix.");
            return;
        }
        String masterFn = String.format("%s_master.gms", gamsPref);
        PrintStream gamsStream = null;
        try {
            gamsStream = new PrintStream(new File(masterFn));
            System.out.println("Opened new master gams file " + masterFn);
        }
        catch (IOException ioe) {
            System.err.println("Unable to print master gams file to " + masterFn);
        }
        printer.printNodeSets(gamsStream);
        String[] efeats = new String[]{"organism", "etype"};
        printer.printEdgeSets(gamsStream, efeats, false);
        String pathFn = String.format("%s_master_paths.tab", gamsPref);
        PrintStream pathStream = null;
        try {
            pathStream = new PrintStream(new File(pathFn));
            System.out.println("Opened new master path file " + pathFn);
        }
        catch (IOException ioe) {
            System.err.println("Unable to print master path file to " + pathFn);
        }
        HIVMain.printPathAssociationFile(config, paths, printer, pathStream);
        String subFn = String.format("%s_master_subgraphs.tab", gamsPref);
        PrintStream subStream = null;
        try {
            subStream = new PrintStream(new File(subFn));
            System.out.println("Opened new master subgraph file " + subFn);
        }
        catch (IOException ioe) {
            System.err.println("Unable to print master subgraph file to " + subFn);
        }
        HIVMain.printSubgraphFile(config, paths, printer, subStream);
    }

    protected static void printPathAssociationFile(Configuration config, PathManager paths, GamsPrinter printer, PrintStream outStream) {
        outStream.format("#pid\tgene_ids\teids\n", new Object[0]);
        for (Path p : paths.allPaths()) {
            String pid = printer.gamsify(p);
            ArrayList<String> elist = printer.gamsifyList(p.edges());
            ArrayList<String> nlist = printer.gamsifyList(p.nodes());
            outStream.format("%s\t%s\t%s\n", pid, StringUtils.join(nlist, "|"), StringUtils.join(elist, "|"));
        }
    }

    protected static void printSubgraphFile(Configuration config, PathManager paths, GamsPrinter printer, PrintStream outStream) {
        HashMap subgraphEdges = new HashMap();
        HashMap subgraphNodes = new HashMap();
        HashMap subgraphs = new HashMap();
        for (Subgraph sg : config.subgraphs().values()) {
            HashMap<Path, HashSet<Edge>> sedge = PathManager.filterSubgraphEdgesByPath(paths, sg.edges(), config.subgraphAddModes().get(sg.name()));
            for (Path path : sedge.keySet()) {
                String pid = printer.gamsify(path);
                if (!subgraphs.containsKey(pid)) {
                    subgraphs.put(pid, new HashSet());
                }
                ((HashSet)subgraphs.get(pid)).add(sg.name());
            }
            for (Map.Entry entry : sedge.entrySet()) {
                Path p = (Path)entry.getKey();
                String pid = printer.gamsify(p);
                for (Edge e : (HashSet)entry.getValue()) {
                    if (!subgraphEdges.containsKey(pid) || !subgraphNodes.containsKey(pid)) {
                        subgraphEdges.put(pid, new HashSet());
                        subgraphNodes.put(pid, new HashSet());
                    }
                    if (e == null) {
                        System.err.format("Null edge %s for path %s (pid %s)?\n", e, p, pid);
                    }
                    ((HashSet)subgraphEdges.get(pid)).add(printer.gamsify(e));
                    ((HashSet)subgraphNodes.get(pid)).addAll(printer.gamsifySet(e.nodes()));
                }
            }
        }
        ArrayList pids = new ArrayList(subgraphs.keySet());
        Collections.sort(pids);
        outStream.format("#pid\teids\tgene_ids\tsubgraphs\n", new Object[0]);
        for (String pid : pids) {
            String string = StringUtils.join((Collection)subgraphEdges.get(pid), "|");
            String nids = StringUtils.join((Collection)subgraphNodes.get(pid), "|");
            String sids = StringUtils.join((Collection)subgraphs.get(pid), "|");
            outStream.format("%s\t%s\t%s\t%s\n", pid, string, nids, sids);
        }
    }
}

