/*
 * Decompiled with CFR 0.152.
 */
package apps;

import java.util.ArrayList;
import java.util.Set;
import pathfinders.PathFinder;
import structures.Configuration;
import structures.Edge;
import structures.Graph;
import structures.NodeLibrary;
import structures.PathManager;
import utilities.CytoscapePrinter;
import utilities.GraphUtils;

public class ExploreMop3 {
    public static final boolean DO_PATHFINDING = false;

    public static void main(String[] args) {
        Configuration config = null;
        Graph g = null;
        Graph gOrig = null;
        try {
            config = Configuration.readConfigFile(args[0]);
            g = config.buildGraph();
            gOrig = Graph.createFromEdgeLibrary(config.edgeLibrary());
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            return;
        }
        int dir = 0;
        for (Edge e : g.edges()) {
            if (!e.isDirected()) continue;
            ++dir;
        }
        NodeLibrary libe = config.nodeLibrary();
        System.out.format("Read graph with %d nodes and %d edges.\n", gOrig.nodes().size(), gOrig.edges().size());
        System.out.format("Auto-filtered to graph with %d nodes and %d edges (%d directed).\n", g.nodes().size(), g.edges().size(), dir);
        ArrayList<PathFinder> pfs = config.pathFinders();
        PathManager paths = new PathManager();
        Set<String> pqueries = GraphUtils.request(g, libe, libe.getFeature("query"));
        Set<String> oqueries = GraphUtils.request(gOrig, libe, libe.getFeature("query"));
        System.out.format("Paths cover %d / %d possible queries in network.\n", pqueries.size(), oqueries.size());
        CytoscapePrinter.printSif(gOrig, String.format("%s_background.sif", config.getOutputPrefix()));
        CytoscapePrinter.printNodeFeatures(libe, String.format("%s_node_feats.tab", config.getOutputPrefix()), false);
        CytoscapePrinter.printEdgeFeatures(config.edgeLibrary(), String.format("%s_edge_feats.tab", config.getOutputPrefix()), false);
    }
}

