/*
 * Decompiled with CFR 0.152.
 */
package apps;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import pathfinders.PathFinder;
import structures.Configuration;
import structures.Edge;
import structures.Graph;
import structures.NodeLibrary;
import structures.PathManager;
import structures.Subgraph;
import utilities.CytoscapePrinter;
import utilities.GamsPrinter;
import utilities.GraphUtils;

public class ExploreGraph {
    public static final boolean DO_PATHFINDING = true;

    public static void main(String[] args) {
        Configuration config = null;
        Graph g = null;
        Graph gOrig = null;
        try {
            config = Configuration.readConfigFile(args[0]);
            g = config.buildGraph();
            gOrig = Graph.createFromEdgeLibrary(config.edgeLibrary());
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            return;
        }
        gOrig = gOrig.removeSelfLoops();
        gOrig = gOrig.removeEdgeless();
        g = g.removeEdgeless();
        g = g.removeSelfLoops();
        NodeLibrary libe = config.nodeLibrary();
        System.out.format("Read graph with %d nodes and %d edges.\n", gOrig.nodes().size(), gOrig.edges().size());
        System.out.format("Auto-filtered to graph with %d nodes and %d edges.\n", g.nodes().size(), g.edges().size());
        Set<String> interfaces = GraphUtils.request(g, libe, libe.getFeature("pinterface"));
        Set<String> hits = GraphUtils.request(g, libe, libe.getFeature("rnai"));
        System.out.format("\tGraph has %d hits, %d interfaces.\n", hits.size(), interfaces.size());
        ArrayList<PathFinder> pfs = config.pathFinders();
        PathManager paths = new PathManager();
        try {
            for (PathFinder pf : pfs) {
                PathManager found = pf.findPaths(g);
                System.out.format("Applied %s: %d paths\n", pf.toString(), found.size());
                paths.addAll(found);
            }
            System.out.format("Total: %d paths\n", paths.size());
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
        g = PathManager.makeGraph(paths);
        for (Subgraph sg : config.subgraphs().values()) {
            Collection<Edge> edges = PathManager.filterEdges(paths, sg.edges(), config.subgraphAddModes().get(sg.name()));
            g.addAll(edges);
        }
        System.out.format("Paths and subgraphs contain %d nodes and %d edges.\n", g.nodes().size(), g.edges().size());
        interfaces = GraphUtils.request(g, libe, libe.getFeature("pinterface"));
        hits = GraphUtils.request(g, libe, libe.getFeature("rnai"));
        System.out.format("\tPaths contain %d hits, %d interfaces.\n", hits.size(), interfaces.size());
        CytoscapePrinter.printSif(g, String.format("%s_paths.sif", config.getOutputPrefix()));
        CytoscapePrinter.printSif(gOrig, String.format("%s_background.sif", config.getOutputPrefix()));
        CytoscapePrinter.printNodeFeatures(libe, String.format("%s_node_feats.tab", config.getOutputPrefix()), false);
        CytoscapePrinter.printEdgeFeatures(config.edgeLibrary(), String.format("%s_edge_feats.tab", config.getOutputPrefix()), false);
        System.out.println("Wrote Cytoscape files: " + config.getOutputPrefix());
        GamsPrinter printer = new GamsPrinter(gOrig, paths, config.nodeLibrary(), config.edgeLibrary(), config.subgraphs());
        boolean cytoV3Format = false;
        CytoscapePrinter.printEdgeAttribute("gamsId", printer.getEdgeIDs(), String.format("%s_gamsId.edge", config.getOutputPrefix()), cytoV3Format, false);
        String gamsFn = config.getGamsFileName();
        if (gamsFn != null) {
            PrintStream gamsStream = null;
            if (gamsFn.equals("System.out")) {
                gamsStream = System.out;
            } else {
                try {
                    gamsStream = new PrintStream(new File(gamsFn));
                }
                catch (IOException ioe) {
                    System.out.println("Unable to print gams file to " + gamsFn);
                }
            }
            String[] nfeats = new String[]{};
            printer.printNodeSets(gamsStream, nfeats);
            String[] efeats = new String[]{"organism", "etype", "inComplexEdge"};
            printer.printEdgeSets(gamsStream, efeats, false);
            printer.printPathSets(gamsStream);
            printer.printSubgraphSets(gamsStream, config.subgraphAddModes());
        }
        System.out.println("Wrote GAMS files: " + config.getGamsFileName());
    }
}

