/*
 * Decompiled with CFR 0.152.
 */
package apps;

import structures.Configuration;
import structures.Graph;
import structures.NodeLibrary;
import structures.Subgraph;
import utilities.CytoscapePrinter;

public class ExploreEscrt {
    public static final boolean DO_PATHFINDING = false;

    public static void main(String[] args) {
        Configuration config = null;
        Graph g = null;
        Graph subG = null;
        try {
            config = Configuration.readConfigFile(args[0]);
            g = config.buildGraph();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            return;
        }
        g = g.removeSelfLoops();
        g = g.removeEdgeless();
        NodeLibrary libe = config.nodeLibrary();
        System.out.format("Read background network with %d nodes and %d edges.\n", g.nodes().size(), g.edges().size());
        Subgraph escrt = config.getSubgraph("sub0");
        subG = new Graph(escrt.edges());
        CytoscapePrinter.printSif(subG, String.format("%s_subgraph.sif", config.getOutputPrefix()));
        CytoscapePrinter.printNodeFeatures(libe, String.format("%s_node_feats.tab", config.getOutputPrefix()), false);
        CytoscapePrinter.printEdgeFeatures(config.edgeLibrary(), String.format("%s_edge_feats.tab", config.getOutputPrefix()), false);
    }
}

