#!/bin/bash

## Run job in current directory, join stderr & stdout, 
## output file 'Random.out'
#$ -cwd -j y -o Random.out

## reserve 4 slots per task on all.q
#$ -pe slots 4 -q all.q
## run tasks 1 through 202

#$ -t 1-202
#$ -tc 25

module load sratoolkit/2.8.2-1
DATADIR=/mnt/lustre/users/svenkat/ncbi/dbGaP-17253/sra/SRAFASTQ
JobFile=/mnt/lustre/users/svenkat/ncbi/dbGaP-17253/sra/SRAFilenamesAll.txt 
Accession=$(sed ${SGE_TASK_ID}!d ${JobFile})
AccessionFile=/mnt/lustre/users/svenkat/ncbi/dbGaP-17253/sra/${Accession}
echo ${AccessionFile}

fastq-dump --gzip --skip-technical  --readids --dumpbase --split-files --clip --outdir ${DATADIR} ${AccessionFile}; 