#!/bin/bash

## Run job in current directory, join stderr & stdout, 
## output file 'FASTQC.out'
#$ -cwd -j y -o FASTQC.out

## reserve 8 slots per task on all.q
#$ -pe slots 2 -q all.q

## run tasks 1 through 202 
#$ -t 1-100
#$ -tc 50

module load fastqc/0.11.5
DATADIR=/mnt/lustre/users/svenkat/Research/APA/GTeXNormalPan/SRAFASTQ/First50FASTQ
ReadPair1File=${DATADIR}/FASTQReadPair1.txt
ReadPair2File=${DATADIR}/FASTQReadPair2.txt
ReadPair1Name=$(sed ${SGE_TASK_ID}!d ${ReadPair1File})
ReadPair2Name=$(sed ${SGE_TASK_ID}!d ${ReadPair2File})
ReadPair1=${DATADIR}/${ReadPair1Name}
ReadPair2=${DATADIR}/${ReadPair2Name}

fastqc ${ReadPair1} ${ReadPair2} -o ${DATADIR}/First50FASTQC
