#!/bin/sh

## Run job in current directory, join stderr & stdout, 
## output file 'BamToBEDGRAPH.out'
#$ -cwd -j y -o BamToBEDGRAPH.out

## reserve 1 slots per task on all.q
#$ -pe slots 1 -q all.q

## run tasks 1 through 184 
#$ -t 1-184
#$ -tc 25

module load bedtools/2.26
REF=/mnt/lustre/users/svenkat/Research/DaPars/DaPars1/hg38Chrominfo.txt
FILES=/mnt/lustre/users/svenkat/Research/APA/BAMFiles/GTeXNormal/BamFileList.txt
infile=`sed -n -e "${SGE_TASK_ID} p" ${FILES}`
bedtools genomecov -bg -ibam ${infile} -g ${REF} -split >${infile%.*}_hg38.bedgraph

## For TCGA folder the only change was line 16: FILES=/mnt/lustre/users/svenkat/Research/APA/BAMFiles/TCGAPanCancer/TCGABamFileList.txt
## As well as the number of samples/tasks was changed to 148